/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

public class RichTextSelection {
    protected String text = "";
    protected int offsetStart = 0;
    protected String fontName = "";
    protected String fontSize = "";
    protected String blockStyle = "";
    protected int flags = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int SUBSCRIPT = 8;
    public static final int SUPERSCRIPT = 16;

    public String getBlockStyle() {
        return this.blockStyle;
    }

    public void setBlockStyle(String string) {
        this.blockStyle = string;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String string) {
        this.fontSize = string;
    }

    public int getOffsetStart() {
        return this.offsetStart;
    }

    public void setOffsetStart(int n) {
        this.offsetStart = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public boolean isBold() {
        return (this.flags & 1) != 0;
    }

    public boolean isItalic() {
        return (this.flags & 2) != 0;
    }

    public boolean isUnderLine() {
        return (this.flags & 4) != 0;
    }

    public boolean isSubscript() {
        return (this.flags & 8) != 0;
    }

    public boolean isSuperscript() {
        return (this.flags & 0x10) != 0;
    }

    public void clear() {
        this.text = "";
        this.offsetStart = 0;
        this.fontName = "";
        this.fontSize = "";
        this.blockStyle = "";
        this.flags = 0;
    }

    public String toString() {
        String string = "Text: " + this.text + "\n";
        string = String.valueOf(string) + "fontName: " + this.fontName + "\n";
        string = String.valueOf(string) + "fontSize: " + this.fontSize + "\n";
        string = String.valueOf(string) + "blockStyle: " + this.blockStyle + "\n";
        string = String.valueOf(string) + "flags: " + this.flags + "\n";
        return string;
    }
}

