/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextComboAction;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontSizeAction
extends RichTextComboAction {
    public FontSizeAction(final IRichText iRichText) {
        super(iRichText);
        this.setToolTipText(RichTextResources.fontSizeAction_toolTipText);
        this.input = new ArrayList();
        this.input.add("Default");
        this.input.add("1");
        this.input.add("2");
        this.input.add("3");
        this.input.add("4");
        this.input.add("5");
        this.input.add("6");
        this.input.add("7");
        iRichText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                String string = iRichText.getSelected().getFontSize();
                int n = -1;
                if (string.equals("default")) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                FontSizeAction.this.setNotifyListeners(false);
                FontSizeAction.this.getCCombo().select(n);
                FontSizeAction.this.setNotifyListeners(true);
            }
        });
    }

    @Override
    public void execute(IRichText iRichText) {
        if (iRichText != null) {
            String string = this.getCComboSelection();
            if ("Default".equals(string)) {
                iRichText.executeCommand("setFontSize", "");
            } else {
                iRichText.executeCommand("setFontSize", string);
            }
        }
    }

    @Override
    public Collection<String> getInput() {
        return this.input;
    }
}

