/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.io.File;
import java.net.URL;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.ClipboardUtil;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class PasteAction
extends RichTextAction {
    private static final String SOURCE_URL = "SourceURL:";
    private static final String HTM_EXT = ".htm";
    private static final String HTML_EXT = ".html";
    private static final Pattern HREF_REFERENCES = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    protected static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    protected static String sourceURLStr = "";
    private Logger logger;
    private static String RESOURCES = "resources";

    public PasteAction(IRichText iRichText) {
        super(iRichText, 1);
        this.setImageDescriptor(RichTextImages.IMG_DESC_PASTE);
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_PASTE);
        this.setToolTipText(RichTextResources.pasteAction_toolTipText);
        this.logger = RichTextPlugin.getDefault().getLogger();
    }

    public boolean disableInSourceMode() {
        return false;
    }

    public void execute(IRichText iRichText) {
        if (iRichText != null) {
            this.copyLinkResources(iRichText);
            if (iRichText instanceof RichTextEditor && ((RichTextEditor)iRichText).isHTMLTabSelected()) {
                StyledText styledText = ((RichTextEditor)iRichText).getSourceEdit();
                styledText.paste();
            } else {
                iRichText.executeCommand("paste", sourceURLStr);
            }
        }
    }

    protected void copyLinkResources(IRichText iRichText) {
        try {
            sourceURLStr = ClipboardUtil.getHTMLSourceURL();
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            String string = (String)clipboard.getContents((Transfer)HTMLTransfer.getInstance());
            if (string != null && string.length() > 0) {
                String string2;
                File file;
                File file2;
                Object object;
                Object object2;
                String string3;
                URL uRL;
                String string4;
                String string5 = iRichText.getBasePath();
                URL uRL2 = null;
                uRL2 = sourceURLStr == null || sourceURLStr.length() == 0 || sourceURLStr.equals("about:blank") ? iRichText.getCopyURL() : new URL(sourceURLStr);
                Matcher matcher = HREF_REFERENCES.matcher(string);
                while (matcher.find()) {
                    string4 = NetUtil.decodeURL((String)matcher.group(1));
                    try {
                        uRL = new URL(uRL2, string4);
                        string3 = uRL.getProtocol();
                        if (string3 == null || !string3.equalsIgnoreCase("file")) continue;
                        object2 = uRL.getPath();
                        object = new File(NetUtil.decodeURL((String)object2));
                        file2 = null;
                        file = null;
                        if (string4.startsWith("#") || uRL2.sameFile(uRL)) continue;
                        if (string4.startsWith(RESOURCES) || string4.startsWith("./" + RESOURCES)) {
                            file2 = new File(string5, string4);
                            file = file2.getParentFile();
                        } else {
                            string2 = this.getSubdirectoryOfResources(string4);
                            file = file2 = new File(String.valueOf(string5) + RESOURCES, string2);
                        }
                        file.mkdirs();
                        FileUtil.copyFile((File)object, (File)file);
                    }
                    catch (Exception exception) {
                        this.logger.logError((Throwable)exception);
                    }
                }
                matcher = p_image_ref.matcher(string);
                while (matcher.find()) {
                    string4 = NetUtil.decodeURL((String)matcher.group(3));
                    try {
                        uRL = new URL(uRL2, string4);
                        string3 = uRL.getProtocol();
                        if (string3 == null || !string3.equalsIgnoreCase("file")) continue;
                        object2 = null;
                        object = uRL.getAuthority();
                        object2 = object != null ? new File(NetUtil.decodeURL((String)(String.valueOf(object) + uRL.getPath()))) : new File(NetUtil.decodeURL((String)uRL.getPath()));
                        file2 = null;
                        file = null;
                        if (string4.startsWith(RESOURCES) || string4.startsWith("./" + RESOURCES)) {
                            file2 = new File(string5, string4);
                            file = file2.getParentFile();
                        } else {
                            string2 = this.getSubdirectoryOfResources(string4);
                            file = file2 = new File(String.valueOf(string5) + RESOURCES, string2);
                        }
                        file.mkdirs();
                        FileUtil.copyFile((File)object2, (File)file);
                    }
                    catch (Exception exception) {
                        this.logger.logError((Throwable)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logger.logError((Throwable)exception);
        }
    }

    protected String getSourceURL(String string) {
        String string2 = null;
        int n = string.indexOf(SOURCE_URL);
        if (n > 0) {
            string2 = string.substring(n + SOURCE_URL.length());
            if ((string2 = string2.substring(0, string2.indexOf(FileUtil.LINE_SEP))).toLowerCase().endsWith(HTM_EXT) || string2.toLowerCase().endsWith(HTML_EXT)) {
                string2 = string2.substring(0, string2.indexOf(FileUtil.getFileName((String)string2)) - 1);
                string2 = string2.replace('\\', '/');
            }
            string2 = FileUtil.appendSeparator((String)string2, (String)"/");
        }
        return string2;
    }

    protected String getSubdirectoryOfResources(String string) {
        String string2 = "";
        int n = string.indexOf(RESOURCES);
        if (n != -1) {
            Stack<String> stack = new Stack<String>();
            File file = new File(string).getParentFile();
            while (!file.getName().equals(RESOURCES)) {
                stack.push(file.getName());
                file = file.getParentFile();
            }
            while (!stack.isEmpty()) {
                string2 = String.valueOf(string2) + (String)stack.pop() + File.separator;
            }
        }
        return string2;
    }
}

