/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.preferences;

import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RichTextPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    private IPreferenceStore store;
    private Text lineWidthText;
    private Button indentCheckbox;
    private Text indentSizeText;

    public void init(IWorkbench iWorkbench) {
        this.store = RichTextPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite3, 0);
        label.setText(RichTextResources.maxCharsPerLineLabel_text);
        this.lineWidthText = new Text(composite3, 2048);
        this.lineWidthText.setText(this.store.getString("htmlEditor.lineWidth"));
        this.lineWidthText.setTextLimit(3);
        GridData gridData = new GridData();
        gridData.widthHint = 25;
        this.lineWidthText.setLayoutData((Object)gridData);
        this.lineWidthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
            }
        });
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        composite4.setLayoutData((Object)new GridData(768));
        this.indentCheckbox = new Button(composite4, 32);
        this.indentCheckbox.setText(RichTextResources.indentHTMLCheckbox_text);
        this.indentCheckbox.setSelection(this.store.getBoolean("htmlEditor.indent"));
        new Label(composite4, 0);
        Label label2 = new Label(composite4, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        label2.setLayoutData((Object)gridData);
        label2.setText(RichTextResources.indentSizeLabel_text);
        this.indentSizeText = new Text(composite4, 2048);
        this.indentSizeText.setText(this.store.getString("htmlEditor.indentSize"));
        this.indentSizeText.setTextLimit(1);
        gridData = new GridData();
        gridData.widthHint = 10;
        this.indentSizeText.setLayoutData((Object)gridData);
        this.indentSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
            }
        });
        return composite2;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.lineWidthText.setText(this.store.getDefaultString("htmlEditor.lineWidth"));
        this.indentCheckbox.setSelection(this.store.getDefaultBoolean("htmlEditor.indent"));
        this.indentSizeText.setText(this.store.getDefaultString("htmlEditor.indentSize"));
    }

    public boolean performOk() {
        int n;
        String string = this.lineWidthText.getText();
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
                this.store.setValue("htmlEditor.lineWidth", n);
            }
            catch (Exception exception) {}
        }
        n = this.indentCheckbox.getSelection();
        this.store.setValue("htmlEditor.indent", n != 0);
        String string2 = this.indentSizeText.getText();
        if (string2 != null && string2.length() > 0) {
            try {
                int n2 = Integer.parseInt(string2);
                this.store.setValue("htmlEditor.indentSize", n2);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void modifyText(ModifyEvent modifyEvent) {
    }
}

