/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.gef.commands.ChangeBoundsCommand;
import org.eclipse.epf.authoring.gef.edit.LinkEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.policies.DiagramLayoutEditPolicy;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class DiagramEditPart
extends NodeContainerEditPart {
    Point cachedPoint = new Point(-1, -1);
    protected boolean debug = AuthoringUIPlugin.getDefault().isDebugging();
    private boolean markDirty = false;
    static int cachedWidth = 10;
    static int cachedHeight = 10;

    public DiagramEditPart(Diagram model) {
        super((NodeContainer)model);
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer(){

            protected void layout() {
                if (DiagramEditPart.this.hasMisplacedChildren()) {
                    DiagramEditPart.this.resetChildrenLocations();
                }
                super.layout();
            }
        };
        f.setBorder((Border)new MarginBorder(20));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        return f;
    }

    protected void resetChildrenLocations() {
        int y = 10;
        int occupied = 0;
        int xelements = 0;
        int x = 10;
        boolean locked = TngUtil.isLocked((EObject)((EObject)((Diagram)this.getModel()).getObject()));
        for (Object child : this.getChildren()) {
            Node node;
            Point p;
            if (!(child instanceof GraphicalEditPart)) continue;
            GraphicalEditPart part = (GraphicalEditPart)child;
            int width = part.getRoot().getViewer().getControl().getBounds().width;
            if (!(part.getModel() instanceof Node) || (p = (node = (Node)part.getModel()).getLocation().getCopy()) != null && p.x != -1) continue;
            if (x + part.getFigure().getPreferredSize().width > width) {
                y = this.cachedPoint.y + cachedHeight + 40;
                xelements = 0;
                x = 10;
                this.cachedPoint.x = -1;
                occupied = 0;
            }
            if (this.cachedPoint.x != -1) {
                x = this.cachedPoint.x + cachedWidth + 40;
            }
            ++xelements;
            if (p == null) {
                p = new Point(-1, -1);
            }
            p.x = x;
            p.y = y;
            if (!locked && ((Diagram)this.getModel()).isNew() && !((Diagram)this.getModel()).isReadOnly() && this.markDirty) {
                ChangeBoundsCommand cbc = new ChangeBoundsCommand(node, p, part.getFigure().getPreferredSize().width);
                this.getViewer().getEditDomain().getCommandStack().execute((Command)cbc);
            } else {
                node.setLocation(p);
            }
            this.cachedPoint = p;
            cachedWidth = part.getFigure().getPreferredSize().width;
            cachedHeight = part.getFigure().getPreferredSize().height;
            if (this.debug) {
                System.out.println("Point : " + new Point(x, y).toString());
                System.out.println("Cached : width: " + cachedWidth + " Height : " + cachedHeight);
            }
            occupied += x;
        }
    }

    protected boolean hasMisplacedChildren() {
        for (Object child : this.getChildren()) {
            Node node;
            Point p;
            Object model;
            if (!(child instanceof EditPart) || !((model = ((EditPart)child).getModel()) instanceof Node) || (p = (node = (Node)model).getLocation()) != null && p.x != -1) continue;
            return true;
        }
        return false;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new DiagramLayoutEditPolicy());
    }

    protected void addPartToEdit(Collection partsToEdit, Object node) {
        if (node instanceof NodeContainer) {
            NodeContainerEditPart editPart = (NodeContainerEditPart)this.findChildByModel(node);
            Iterator iter = ((NodeContainer)node).getNodes().iterator();
            while (iter.hasNext()) {
                editPart.addPartToEdit(partsToEdit, iter.next());
            }
        } else {
            super.addPartToEdit(partsToEdit, node);
        }
    }

    public void moveFigure(int moveX, int moveY) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof GraphicalEditPart)) continue;
            GraphicalEditPart part = (GraphicalEditPart)child;
            Rectangle bounds = part.getFigure().getBounds();
            Rectangle r = new Rectangle(new Point(bounds.x + moveX, bounds.y + moveY), bounds.getSize());
            List list = part.getSourceConnections();
            for (LinkEditPart linkpart : list) {
                Link link = (Link)linkpart.getModel();
                if (link.getBendpoints().size() <= 0) continue;
                PointList plist = ((PolylineConnection)linkpart.getFigure()).getPoints();
                ArrayList<AbsoluteBendpoint> points = new ArrayList<AbsoluteBendpoint>();
                int i = 1;
                while (i < plist.size() - 1) {
                    Point p = plist.getPoint(i);
                    p = p.translate(new Point(moveX, moveY));
                    AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
                    points.add(bp);
                    ++i;
                }
                linkpart.getConnectionFigure().setRoutingConstraint(points);
            }
            this.setLayoutConstraint((EditPart)part, part.getFigure(), r);
        }
    }

    public void markDirty(boolean markDirty) {
        this.markDirty = markDirty;
    }
}

