/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IModifyingAction;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class IndentAction
extends CommandActionHandler
implements IWorkbenchPartAction,
IModifyingAction {
    private static final String LABEL = AuthoringUIResources.ProcessEditor_Action_Indent;
    private ProcessEditor editor;

    public IndentAction(String text) {
        super(null, text);
    }

    public IndentAction() {
        this(LABEL);
        this.setImageDescriptor(RichTextImages.IMG_DESC_INDENT);
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_INDENT);
        this.setToolTipText(LABEL);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object e;
        boolean ret = false;
        if (selection.size() == 1 && (e = selection.getFirstElement()) instanceof Activity) {
            ret = super.updateSelection(selection);
        }
        this.setEnabled(ret);
        return ret;
    }

    public Command createCommand(Collection selection) {
        if (this.domain instanceof AdapterFactoryEditingDomain) {
            return new IndentCommand(selection, ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory());
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
        if (workbenchPart instanceof ProcessEditor) {
            this.editor = (ProcessEditor)workbenchPart;
        } else if (workbenchPart == null) {
            this.editor = null;
        }
    }

    private void superRun() {
        super.run();
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.editor.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IndentAction.this.superRun();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndentCommand
    extends AbstractCommand
    implements IResourceAwareCommand {
        private Collection<BreakdownElement> elements;
        private AdapterFactory adapterFactory;
        private Set modifiedResources;
        private BreakdownElement element;
        private Activity oldParent;
        private Activity newParent;
        private int oldIndex;
        private Map<WorkBreakdownElement, WorkOrder> circularWorkOrders;

        public IndentCommand(Collection<BreakdownElement> collection, AdapterFactory adapterFactory) {
            this.elements = collection;
            this.adapterFactory = adapterFactory;
            this.setLabel(LABEL);
        }

        public Collection getModifiedResources() {
            if (this.modifiedResources == null) {
                Resource resource;
                Process proc = null;
                Iterator<BreakdownElement> iter = this.elements.iterator();
                while (proc == null && iter.hasNext()) {
                    BreakdownElement e = iter.next();
                    proc = TngUtil.getOwningProcess((BreakdownElement)e);
                }
                if (proc != null && (resource = proc.eResource()) != null) {
                    this.modifiedResources = Collections.singleton(proc.eResource());
                }
                if (this.modifiedResources == null) {
                    this.modifiedResources = Collections.EMPTY_SET;
                }
            }
            return this.modifiedResources;
        }

        protected boolean prepare() {
            Object prev;
            this.element = this.elements.iterator().next();
            this.oldParent = this.element.getSuperActivities();
            if (this.oldParent == null) {
                return false;
            }
            this.oldIndex = this.oldParent.getBreakdownElements().indexOf(this.element);
            ITreeItemContentProvider ip = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)this.oldParent, ITreeItemContentProvider.class);
            LinkedList children = new LinkedList(ip.getChildren((Object)this.oldParent));
            int index = children.indexOf(this.element);
            if (index > 0 && (prev = children.get(index - 1)) instanceof Activity) {
                this.newParent = (Activity)prev;
                return DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)this.newParent, (Collection)Collections.singleton(this.element), (boolean)true);
            }
            return false;
        }

        public void execute() {
            this.newParent.getBreakdownElements().add(this.element);
            if (this.element instanceof WorkBreakdownElement) {
                WorkBreakdownElement wbe;
                if (this.circularWorkOrders == null) {
                    this.circularWorkOrders = new HashMap<WorkBreakdownElement, WorkOrder>();
                } else {
                    this.circularWorkOrders.clear();
                }
                WorkOrder wo = UmaUtil.findWorkOrder((WorkBreakdownElement)this.newParent, (Object)this.element);
                if (wo != null) {
                    this.newParent.getLinkToPredecessor().remove(wo);
                    this.circularWorkOrders.put((WorkBreakdownElement)this.newParent, wo);
                }
                if ((wo = UmaUtil.findWorkOrder((WorkBreakdownElement)(wbe = (WorkBreakdownElement)this.element), (Object)this.newParent)) != null) {
                    wbe.getLinkToPredecessor().remove(wo);
                    this.circularWorkOrders.put(wbe, wo);
                }
            }
            if (this.element instanceof Activity) {
                ProcessPackage parentPkg = (ProcessPackage)this.newParent.eContainer();
                parentPkg.getChildPackages().add((MethodPackage)this.element.eContainer());
            }
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
            if (this.circularWorkOrders != null && !this.circularWorkOrders.isEmpty()) {
                for (Map.Entry<WorkBreakdownElement, WorkOrder> entry : this.circularWorkOrders.entrySet()) {
                    entry.getKey().getLinkToPredecessor().add(entry.getValue());
                }
                this.circularWorkOrders.clear();
            }
            this.oldParent.getBreakdownElements().add(this.oldIndex, this.element);
            if (this.element instanceof Activity) {
                ProcessPackage parentPkg = (ProcessPackage)this.oldParent.eContainer();
                parentPkg.getChildPackages().add((MethodPackage)this.element.eContainer());
            }
        }

        public Collection getAffectedObjects() {
            return this.elements;
        }
    }
}

