/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationWizard;
import org.eclipse.epf.common.ui.util.ErrorDialogNoReason;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.MethodElementCreateChildCommand;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.dialogs.UncancelableListSelectionDialog;
import org.eclipse.epf.library.ui.dialogs.UserInputsDialog;
import org.eclipse.epf.library.ui.providers.DelegateLabelProvider;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class UserInteractionHandler
implements IUserInteractionHandler {
    private Shell shell;
    private IUserInteractionHandler.IMessenger messenger = new IUserInteractionHandler.IMessenger(){

        public void showWarning(final String title, final String msg) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayWarning(title, msg);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayWarning(title, msg);
            }
        }

        public void showError(final String title, final String msg, final IStatus status) {
            if (status == null) {
                this.showError(title, msg);
            } else if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, msg, status);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, msg, status);
            }
        }

        public void showError(final String title, final String msg, final String reason, final Exception exception) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason, (Throwable)exception);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason, (Throwable)exception);
            }
        }

        public void showWarning(final String title, final String msg, final String reason) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayWarning(title, msg, reason);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayWarning(title, msg, reason);
            }
        }

        public void showError(final String title, final String msg) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, msg);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, msg);
            }
        }

        public void showInfo(final String title, final String msg) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayInfo(title, msg);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayInfo(title, msg);
            }
        }

        public void showError(final String title, final String msg, final String reason, final String details, final Exception exception) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason, details, (Throwable)exception);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason, details, (Throwable)exception);
            }
        }
    };

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Object getUIContext() {
        if (this.shell == null) {
            return MsgBox.getDefaultShell();
        }
        return this.shell;
    }

    public List select(List objectsToSelect, IItemLabelProvider labelProvider, boolean multiple, List intitialSelection, String title, String msg) {
        DelegateLabelProvider lp = new DelegateLabelProvider(labelProvider);
        if (multiple) {
            ArrayContentProvider contentProvider = new ArrayContentProvider();
            UncancelableListSelectionDialog dlg = new UncancelableListSelectionDialog(this.shell, (Object)objectsToSelect, (IStructuredContentProvider)contentProvider, (ILabelProvider)lp, msg);
            dlg.setTitle(title);
            dlg.setBlockOnOpen(true);
            dlg.open();
            Object[] objs = dlg.getResult();
            if (objs == null) {
                return null;
            }
            if (objs.length == 0) {
                return Collections.EMPTY_LIST;
            }
            return Arrays.asList(objs);
        }
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(this.shell, (ILabelProvider)lp);
        dlg.setBlockOnOpen(true);
        dlg.setElements(objectsToSelect.toArray());
        dlg.setMultipleSelection(false);
        dlg.setMessage(msg);
        dlg.setTitle(title);
        dlg.setFilter(null);
        if (dlg.open() == 1) {
            return null;
        }
        Object obj = dlg.getFirstResult();
        return Collections.singletonList(obj);
    }

    public int selectOne(int[] actions, String title, String msg, IStatus status) {
        final String[] buttonLabels = new String[actions.length];
        int i = 0;
        while (i < actions.length) {
            buttonLabels[i] = UserInteractionHandler.getActionText(actions[i]);
            ++i;
        }
        Image image = null;
        try {
            this.shell = LibraryUIPlugin.getDefault().getWorkbench().getDisplay().getActiveShell();
            image = this.shell.getImage();
        }
        catch (Exception exception) {}
        if (status == null) {
            MessageDialog msgDlg = new MessageDialog(this.shell, title, image, msg, 3, buttonLabels, 0);
            int id = msgDlg.open();
            return actions[id];
        }
        ErrorDialogNoReason dlg = new ErrorDialogNoReason(this.shell, title, msg, status, 7){

            protected void createButtonsForButtonBar(Composite parent) {
                int i = 0;
                while (i < buttonLabels.length) {
                    String label = buttonLabels[i];
                    this.createButton(parent, i, label, i == 0);
                    ++i;
                }
                if (this.shouldShowDetailsButton()) {
                    this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
                }
            }

            protected void buttonPressed(int id) {
                if (id == 13) {
                    super.buttonPressed(id);
                } else {
                    this.setReturnCode(id);
                    this.close();
                }
            }
        };
        int id = dlg.open();
        return actions[id];
    }

    public static String getActionText(int action) {
        switch (action) {
            case 3: {
                return IDialogConstants.ABORT_LABEL;
            }
            case 1: {
                return IDialogConstants.CANCEL_LABEL;
            }
            case 0: {
                return IDialogConstants.OK_LABEL;
            }
            case 2: {
                return IDialogConstants.RETRY_LABEL;
            }
            case 4: {
                return IDialogConstants.YES_LABEL;
            }
            case 5: {
                return IDialogConstants.NO_LABEL;
            }
        }
        return null;
    }

    public IUserInteractionHandler.IMessenger getMessenger() {
        return this.messenger;
    }

    public boolean requestInput(final String title, final String msg, final List userInputs) {
        if (userInputs == null || userInputs.size() == 0) {
            return false;
        }
        if (Display.getCurrent() == null) {
            final boolean[] retHolder = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    retHolder[0] = UserInteractionHandler.this.doRequestInput(title, msg, userInputs);
                }
            });
            return retHolder[0];
        }
        return this.doRequestInput(title, msg, userInputs);
    }

    private boolean doRequestInput(String title, String msg, List userInputs) {
        MethodElementCreateChildCommand cmd;
        final UserInput userInput = (UserInput)userInputs.get(0);
        if (userInput.getContext() instanceof MethodElementCreateChildCommand && (cmd = (MethodElementCreateChildCommand)userInput.getContext()).getFeature() == UmaPackage.eINSTANCE.getMethodLibrary_PredefinedConfigurations()) {
            NewConfigurationWizard wizard = new NewConfigurationWizard();
            wizard.init(PlatformUI.getWorkbench(), null);
            wizard.setMethodConfiguration((MethodConfiguration)cmd.getChild());
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() == 0) {
                userInput.setInput((Object)wizard.getMethodConfiguration().getName());
                return true;
            }
            return false;
        }
        if (userInputs.size() == 1 && userInput.getType() == 0 && userInput.getLabel() == null) {
            IInputValidator validator = userInput.getValidator() != null ? new IInputValidator(){

                public String isValid(String newText) {
                    return userInput.getValidator().isValid(newText);
                }
            } : null;
            InputDialog dlg = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), title, msg, (String)userInput.getInput(), validator);
            if (dlg.open() == 0) {
                userInput.setInput((Object)dlg.getValue());
                return true;
            }
            return false;
        }
        UserInputsDialog dialog = new UserInputsDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), userInputs, title, msg);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog.getResult();
    }
}

