/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInListCommand;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ContentElementsOrderDialog
extends Dialog {
    private Composite baseComposite;
    private Button ctrl_up;
    private Button ctrl_down;
    private Table ctrl_steps;
    private TableViewer stepsTableViewer;
    private ContentElementOrderList allSteps;
    private IStructuredContentProvider stepsViewerContentProvider;
    private ILabelProvider stepsViewerLabelProvider;
    private ContentElement contentElement;
    private MethodElement sortElement;
    private IActionManager actionManager;
    private ArrayList commands = new ArrayList();
    protected ComboViewer viewer_sort;
    protected IStructuredContentProvider contentProviderSort = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public Object[] getElements(Object object) {
            List sortTypesList = CategorySortHelper.getCategorySortTypes();
            return sortTypesList.toArray();
        }
    };
    protected ILabelProvider labelProviderSort = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            if (object instanceof String) {
                String str = (String)object;
                return CategorySortHelper.getSortTypeDisplayName((String)str);
            }
            return null;
        }
    };
    private EStructuralFeature feature;

    public ContentElementsOrderDialog(Shell parent, ContentElement contentElement, IActionManager actionManager) {
        super(parent);
        this.contentElement = contentElement;
        this.sortElement = TngUtil.isContributor((VariabilityElement)contentElement) ? contentElement.getVariabilityBasedOnElement() : contentElement;
        this.actionManager = actionManager;
        this.allSteps = null;
    }

    protected Control createDialogArea(Composite parent) {
        this.baseComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.baseComposite.setLayout((Layout)gridLayout);
        this.baseComposite.setLayoutData((Object)new GridData());
        this.createLabel(this.baseComposite, " ", 4);
        this.createLabel(this.baseComposite, " ", 1);
        this.createLabel(this.baseComposite, AuthoringUIResources.ContentElementsOrderDialog_ContentElement_text, 3);
        this.createLabel(this.baseComposite, " ", 1);
        this.ctrl_steps = new Table(this.baseComposite, 2050);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        gridData.heightHint = 400;
        this.ctrl_steps.setLayoutData((Object)gridData);
        this.initProviders();
        this.stepsTableViewer = new TableViewer(this.ctrl_steps);
        this.stepsTableViewer.setContentProvider((IContentProvider)this.stepsViewerContentProvider);
        this.stepsTableViewer.setLabelProvider((IBaseLabelProvider)this.stepsViewerLabelProvider);
        Composite orderButtonPane = new Composite(this.baseComposite, 0);
        GridData gridData2 = new GridData(68);
        gridData2.horizontalSpan = 1;
        orderButtonPane.setLayoutData((Object)gridData2);
        orderButtonPane.setLayout((Layout)new GridLayout());
        this.ctrl_up = this.createButton(orderButtonPane, AuthoringUIText.UP_BUTTON_TEXT);
        this.ctrl_up.setLayoutData((Object)new GridData(768));
        this.ctrl_down = this.createButton(orderButtonPane, AuthoringUIText.DOWN_BUTTON_TEXT);
        this.ctrl_down.setLayoutData((Object)new GridData(768));
        this.ctrl_up.setEnabled(false);
        this.ctrl_down.setEnabled(false);
        this.createLabel(orderButtonPane, LibraryEditResources.SortType_Label, 1);
        Combo ctrl_sort = new Combo(orderButtonPane, 0x80000C);
        this.viewer_sort = new ComboViewer(ctrl_sort);
        this.viewer_sort.setContentProvider((IContentProvider)this.contentProviderSort);
        this.viewer_sort.setLabelProvider((IBaseLabelProvider)this.labelProviderSort);
        this.viewer_sort.setInput((Object)this.contentElement);
        String sortType = CategorySortHelper.getCategorySortValue((MethodElement)this.sortElement);
        this.viewer_sort.setSelection((ISelection)new StructuredSelection((Object)sortType), true);
        this.enableButtons();
        this.createLabel(this.baseComposite, " ", 4);
        this.createLine(this.baseComposite, 4);
        super.getShell().setText(AuthoringUIResources.ContentElementsOrderDialog_description_text);
        this.addListeners();
        this.loadData();
        if (TngUtil.isLocked((EObject)this.contentElement) || TngUtil.isContributor((VariabilityElement)this.contentElement)) {
            this.viewer_sort.getCombo().setEnabled(false);
        } else {
            this.viewer_sort.getCombo().setEnabled(true);
        }
        return this.baseComposite;
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private Label createLabel(Composite parent, String text, int nCol) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = nCol;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void initProviders() {
        this.stepsViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (ContentElementsOrderDialog.this.allSteps == null) {
                    ContentElementsOrderDialog.this.allSteps = new ContentElementOrderList((VariabilityElement)ContentElementsOrderDialog.this.contentElement, 2, ContentElementsOrderDialog.this.feature);
                }
                List returnList = CategorySortHelper.sortCategoryElements((MethodElement)ContentElementsOrderDialog.this.sortElement, (Object[])ContentElementsOrderDialog.this.allSteps.toArray());
                return returnList.toArray();
            }
        };
        this.stepsViewerLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public boolean isExternal(Object element) {
                return !((List)((ContentCategory)ContentElementsOrderDialog.this.contentElement).eGet(ContentElementsOrderDialog.this.feature)).contains(element);
            }
        };
    }

    public void addListeners() {
        this.stepsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ContentElementsOrderDialog.this.enableButtons();
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ContentElementsOrderDialog.this.stepsTableViewer.getSelection();
                ArrayList moveUpItems = new ArrayList();
                moveUpItems.addAll(selection.toList());
                EReference feature = UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
                MoveInListCommand cmd = new MoveInListCommand((MethodElement)((ContentCategory)ContentElementsOrderDialog.this.contentElement), moveUpItems, ContentElementsOrderDialog.this.allSteps, (EStructuralFeature)feature, 1);
                ContentElementsOrderDialog.this.actionManager.execute((IResourceAwareCommand)cmd);
                ContentElementsOrderDialog.this.commands.add(cmd);
                ContentElementsOrderDialog.this.refreshViewers();
                ContentElementsOrderDialog.this.enableButtons();
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ContentElementsOrderDialog.this.stepsTableViewer.getSelection();
                ArrayList moveDownItems = new ArrayList();
                moveDownItems.addAll(selection.toList());
                EReference feature = UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
                MoveInListCommand cmd = new MoveInListCommand((MethodElement)((ContentCategory)ContentElementsOrderDialog.this.contentElement), moveDownItems, ContentElementsOrderDialog.this.allSteps, (EStructuralFeature)feature, 0);
                ContentElementsOrderDialog.this.actionManager.execute((IResourceAwareCommand)cmd);
                ContentElementsOrderDialog.this.commands.add(cmd);
                ContentElementsOrderDialog.this.refreshViewers();
                ContentElementsOrderDialog.this.enableButtons();
            }
        });
        this.viewer_sort.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ContentElementsOrderDialog.this.viewer_sort.getSelection();
                String sortType = (String)selection.getFirstElement();
                MethodElementProperty prop = CategorySortHelper.getCategorySortProperty((MethodElement)ContentElementsOrderDialog.this.contentElement);
                if (prop == null) {
                    prop = CategorySortHelper.createNewSortProperty((String)sortType);
                    ContentElementsOrderDialog.this.actionManager.doAction(3, (EObject)ContentElementsOrderDialog.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_MethodElementProperty(), (Object)prop, -1);
                } else {
                    ContentElementsOrderDialog.this.actionManager.doAction(1, (EObject)prop, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElementProperty_Value(), (Object)sortType, -1);
                }
                ContentElementsOrderDialog.this.refreshViewers();
                ContentElementsOrderDialog.this.enableButtons();
            }
        });
    }

    private void refreshViewers() {
        this.stepsTableViewer.refresh();
    }

    private void loadData() {
        this.stepsTableViewer.setInput((Object)this.contentElement);
    }

    protected void okPressed() {
        this.allSteps.apply();
        super.okPressed();
    }

    protected void cancelPressed() {
        if (!this.commands.isEmpty()) {
            int i = this.commands.size() - 1;
            while (i > -1) {
                Object cmd = this.commands.get(i);
                if (cmd instanceof MoveInListCommand) {
                    ((MoveInListCommand)cmd).undo();
                }
                --i;
            }
        }
        super.cancelPressed();
    }

    public void setFeature(EStructuralFeature feature) {
        this.feature = feature;
    }

    private void enableButtons() {
        if (this.isShouldEnableUp()) {
            this.ctrl_up.setEnabled(true);
        } else {
            this.ctrl_up.setEnabled(false);
        }
        if (this.isShouldEnableDown()) {
            this.ctrl_down.setEnabled(true);
        } else {
            this.ctrl_down.setEnabled(false);
        }
    }

    protected boolean isShouldEnableUp() {
        IStructuredSelection selection = (IStructuredSelection)this.stepsTableViewer.getSelection();
        return selection.size() == 1 && this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)this.contentElement) && CategorySortHelper.isManualCategorySort((MethodElement)this.sortElement);
    }

    protected boolean isShouldEnableDown() {
        IStructuredSelection selection = (IStructuredSelection)this.stepsTableViewer.getSelection();
        return selection.size() == 1 && this.stepsTableViewer.getTable().getSelectionIndex() < this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)this.contentElement) && CategorySortHelper.isManualCategorySort((MethodElement)this.sortElement);
    }
}

