/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.editors.EditorOpener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodPlugin;
import org.osgi.framework.Bundle;

public class EditorOpenerFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.authoring.ui";
    public static final String EXTENSION_POINT_NAME = "EditorOpener";
    public static final String CLASS_ATTRIB_NAME = "class";
    public static final String ID_ATTRIB_NAME = "id";
    private static EditorOpenerFactory instance = null;
    private Map<String, EditorOpenerElement> openerElements = new HashMap<String, EditorOpenerElement>();

    public static synchronized EditorOpenerFactory getInstance() {
        if (instance == null) {
            instance = new EditorOpenerFactory();
        }
        return instance;
    }

    private EditorOpenerFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        EditorOpenerElement provider;
                        String className = configElement.getAttribute(CLASS_ATTRIB_NAME);
                        String id = configElement.getAttribute(ID_ATTRIB_NAME);
                        if (className != null && className.trim().length() > 0 && id != null && id.trim().length() > 0 && (provider = this.openerElements.get(id)) == null) {
                            provider = new EditorOpenerElement(bundle, className, id);
                            this.openerElements.put(id, provider);
                        }
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public EditorOpener getOpener(Object obj) {
        if (obj instanceof MethodElement) {
            MethodElement e = (MethodElement)obj;
            while (e != null) {
                List props = e.getMethodElementProperty();
                if (props != null && props.size() > 0) {
                    for (MethodElementProperty prop : props) {
                        String id = prop.getName();
                        EditorOpener opener = this.createExtension(id);
                        if (opener == null) continue;
                        return opener;
                    }
                }
                if (e instanceof MethodPlugin) break;
                e = LibraryUtil.getMethodPlugin((EObject)e);
            }
        }
        return null;
    }

    public boolean hasExtension(String id) {
        return this.openerElements.containsKey(id);
    }

    private EditorOpener createExtension(String id) {
        if (!this.hasExtension(id)) {
            return null;
        }
        EditorOpenerElement provider = this.openerElements.get(id);
        try {
            Class clazz = provider.bundle.loadClass(provider.className);
            return (EditorOpener)clazz.newInstance();
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    private class EditorOpenerElement {
        Bundle bundle;
        String className;
        String id;

        private EditorOpenerElement(Bundle bundle, String className, String id) {
            this.bundle = bundle;
            this.className = className;
            this.id = id;
        }
    }
}

