/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.forms.MethodFormToolkit;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseFormPage
extends FormPage {
    public static final int ADD_BUTTON = 0;
    public static final int REMOVE_BUTTON = 1;
    public static final int UP_BUTTON = 2;
    public static final int DOWN_BUTTON = 3;
    protected static final int ORDER_BUTTON = 4;
    protected static final int SELECT_BUTTON = 5;
    protected static final int CLEAR_BUTTON = 6;
    protected static final int ATTACH_BUTTON = 7;
    protected static final int DETACH_BUTTON = 8;
    protected static final int ATTACH_URL_BUTTON = 9;
    public static final int SMALL_SIZE = 0;
    public static final int MEDIUM_SIZE = 1;
    public static final int LARGE_SIZE = 2;
    public static final int SINGLE_ROW = 3;
    protected boolean debug = AuthoringUIPlugin.getDefault().isDebugging();
    protected ScrolledForm form;
    protected FormToolkit toolkit;
    protected String editorTabName;
    protected String editorName;
    protected MethodUnit methodUnit;
    protected MethodElement methodElement;
    protected ContentElement contentElement = null;
    protected String contentElementPath;
    private int SECTION_ID;
    public static String LABEL_DECORATOR_KEY = "labelControlDecoration";

    public BaseFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        this.methodElement = methodElementInput.getMethodElement();
        MethodElement elementOfPath = this.methodElement instanceof ProcessComponent ? ((ProcessComponent)this.methodElement).getProcess() : this.methodElement;
        this.contentElementPath = ResourceHelper.getFolderAbsolutePath((MethodElement)elementOfPath);
        if (this.methodElement instanceof MethodUnit) {
            this.methodUnit = (MethodUnit)this.methodElement;
        }
        if (this.methodElement instanceof ContentElement) {
            this.contentElement = (ContentElement)this.methodElement;
            ContentDescription contentDescription = this.contentElement.getPresentation();
            this.methodUnit = contentDescription;
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
    }

    protected void toggle(HyperlinkEvent event) {
    }

    protected void toggle(HyperlinkEvent event, int o) {
    }

    public void setEditorName(String editorName) {
        this.editorName = editorName;
    }

    public List<?> retrieveTableViewerContents(TableViewer viewer) {
        Object[] elements = ((IStructuredContentProvider)viewer.getContentProvider()).getElements(viewer.getInput());
        ArrayList<Object> elementList = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            elementList.add(elements[i]);
            ++i;
        }
        return elementList;
    }

    protected Section createSection(FormToolkit toolkit, Composite parent, String title, String description) {
        Section section = toolkit.createSection(parent, 450);
        GridData td = new GridData(4, 4, true, false);
        section.setLayoutData((Object)td);
        section.setText(title);
        section.setDescription(description);
        section.setLayout((Layout)new GridLayout());
        return section;
    }

    protected static Label createLabel(FormToolkit toolkit, Composite parent, String text, int gridDataStyle, int horizontalSpan) {
        Label label = toolkit.createLabel(parent, text, 0x2000040);
        GridData gridData = new GridData(gridDataStyle);
        gridData.horizontalSpan = horizontalSpan;
        gridData.verticalAlignment = 128;
        gridData.widthHint = horizontalSpan == 2 ? 115 : 100;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Label createLabelWithNoWrap(FormToolkit toolkit, Composite parent, String text, int gridDataStyle, int horizontalSpan) {
        Label label = toolkit.createLabel(parent, text, 0x2000000);
        GridData gridData = new GridData(gridDataStyle);
        gridData.horizontalSpan = horizontalSpan;
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected static Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        return BaseFormPage.createLabel(toolkit, parent, text, 1, 1);
    }

    protected static Label createLabel(FormToolkit toolkit, Composite parent, String text, int horizontalSpan) {
        return BaseFormPage.createLabel(toolkit, parent, text, 1, horizontalSpan);
    }

    protected static Label createBlankLabel(FormToolkit toolkit, Composite parent, int horizontalSpan) {
        return BaseFormPage.createLabel(toolkit, parent, "", 768, horizontalSpan);
    }

    protected static Text createTextEdit(FormToolkit toolkit, Composite parent, int style, int gridDataStyle, int height, int width, int horizontalSpan) {
        Text control = toolkit.createText(parent, "", style);
        GridData gridData = new GridData(gridDataStyle);
        gridData.heightHint = height;
        gridData.widthHint = width;
        gridData.horizontalSpan = horizontalSpan;
        control.setLayoutData((Object)gridData);
        return control;
    }

    protected static Text createTextEdit(FormToolkit toolkit, Composite parent) {
        return BaseFormPage.createTextEdit(toolkit, parent, 68, 768, -1, 100, 1);
    }

    protected static Text createTextEditWithLabel(FormToolkit toolkit, Composite parent, int textStyle, int gridDataStyle, int height, int width, int horizontalSpan, String textLabel) {
        BaseFormPage.createLabel(toolkit, parent, textLabel);
        return BaseFormPage.createTextEdit(toolkit, parent, textStyle, gridDataStyle, height, width, horizontalSpan);
    }

    protected static Text createTextEditWithLabel(FormToolkit toolkit, Composite parent, String labelText) {
        BaseFormPage.createLabel(toolkit, parent, labelText, 2);
        return BaseFormPage.createTextEdit(toolkit, parent);
    }

    protected static Text createTextEditWithLabel2(FormToolkit toolkit, Composite parent, String labelText) {
        BaseFormPage.createLabel(toolkit, parent, labelText, 2);
        return BaseFormPage.createTextEdit(toolkit, parent, 578, 768, 40, 300, 1);
    }

    protected static Text createTextEditWithLabel3(FormToolkit toolkit, Composite parent, String labelText, int height, int singleOrMulti) {
        BaseFormPage.createLabel(toolkit, parent, labelText, 2);
        return BaseFormPage.createTextEdit(toolkit, parent, singleOrMulti | 0x40 | 0x200 | 0x10, 768, height, 300, 2);
    }

    protected static Text createTextEditWithLabel4(FormToolkit toolkit, Composite parent, String labelText, int height, int singleOrMulti, String fillText) {
        BaseFormPage.createLabel(toolkit, parent, labelText, 2);
        int horizontalSpan = BaseFormPage.calculateSpan(fillText);
        if (horizontalSpan == 1) {
            Text text = BaseFormPage.createTextEdit(toolkit, parent, singleOrMulti | 0x40 | 0x200 | 0x10, 768, height, 200, 1);
            Text text2 = BaseFormPage.createTextEdit(toolkit, parent, singleOrMulti | 0x40 | 0x200, 768, height, 100, 1);
            text2.setVisible(false);
            BaseFormPage.createLabel(toolkit, parent, "", 1);
            return text;
        }
        return BaseFormPage.createTextEdit(toolkit, parent, singleOrMulti | 0x40 | 0x200 | 0x10, 768, height, 300, 3);
    }

    protected static Text createTextEditWithLabel5(FormToolkit toolkit, Composite parent, String labelText) {
        BaseFormPage.createLabel(toolkit, parent, labelText, 2);
        return BaseFormPage.createTextEdit(toolkit, parent, 578, 768, 40, 300, 2);
    }

    protected static Text createTextEditWithLabel5(FormToolkit toolkit, Composite parent, String labelText, int height, int singleOrMulti) {
        BaseFormPage.createLabel(toolkit, parent, labelText, 2);
        return BaseFormPage.createTextEdit(toolkit, parent, singleOrMulti | 0x40 | 0x200 | 0x10, 768, height, 300, 3);
    }

    protected Combo createComboWithLabel3(FormToolkit toolkit, Composite parent, String labelText) {
        BaseFormPage.createLabel(toolkit, parent, labelText, 2);
        return this.createCombo(parent, 8388636, 768);
    }

    protected static int calculateSpan(String fillText) {
        int length = fillText.length();
        if (length < 60) {
            return 1;
        }
        return 2;
    }

    protected static Text createTextEditWithLabelLarge(FormToolkit toolkit, Composite parent, String labelText) {
        Label label = BaseFormPage.createLabel(toolkit, parent, labelText);
        ((GridData)label.getLayoutData()).widthHint = -1;
        return BaseFormPage.createTextEdit(toolkit, parent, 578, 768, 80, -1, 3);
    }

    protected ImageHyperlink createImageHyperlink(FormToolkit toolkit, Composite parent, String text, Image image) {
        ImageHyperlink link = toolkit.createImageHyperlink(parent, 16512);
        GridData gridData = new GridData(1);
        gridData.verticalAlignment = 128;
        link.setLayoutData((Object)gridData);
        link.setImage(image);
        if (text != null) {
            link.setText(text);
        }
        return link;
    }

    protected ImageHyperlink createHyperLink(FormToolkit toolkit, Composite expandedComposite, int sectionID) {
        this.SECTION_ID = sectionID;
        ImageHyperlink expandLink = toolkit.createImageHyperlink(expandedComposite, 0);
        expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        expandLink.setUnderlined(false);
        expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BaseFormPage.this.toggle(e, BaseFormPage.this.SECTION_ID);
            }
        });
        return expandLink;
    }

    protected IMethodRichText createRichTextEdit(FormToolkit toolkit, Composite parent, int style, int gridDataStyle, int height, int width, int horizontalSpan, Label label) {
        IMethodRichText richText = MethodFormToolkit.createRichText(toolkit, parent, "", style, this.contentElementPath, this.methodElement, label);
        GridData gridData = new GridData(gridDataStyle);
        gridData.heightHint = height;
        gridData.widthHint = width;
        gridData.horizontalSpan = horizontalSpan;
        richText.setLayoutData(gridData);
        return richText;
    }

    protected IMethodRichText createRichTextEdit(FormToolkit toolkit, Composite parent) {
        return this.createRichTextEdit(toolkit, parent, 578, 768, -1, -1, 1, null);
    }

    public static Label createDecoratedLabel(FormToolkit toolkit, Composite parent, String text) {
        int margin;
        Label decoratedLabel = BaseFormPage.createLabel(toolkit, parent, text);
        ((GridData)decoratedLabel.getLayoutData()).horizontalIndent = margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        ControlDecoration labelControlDecoration = new ControlDecoration((Control)decoratedLabel, 17408);
        decoratedLabel.setData(LABEL_DECORATOR_KEY, (Object)labelControlDecoration);
        return decoratedLabel;
    }

    protected IMethodRichText createRichTextEditWithLink(FormToolkit toolkit, Composite parent, String labelText, int height, int width, int horizontalSpan) {
        ImageHyperlink link = this.createImageHyperlink(toolkit, parent, null, AuthoringUIImages.IMG_COLLAPSED);
        link.setToolTipText(AuthoringUIResources.openRTE);
        Label decoratedLabel = BaseFormPage.createDecoratedLabel(toolkit, parent, labelText);
        IMethodRichText control = this.createRichTextEdit(toolkit, parent, 578, 768, height, width, horizontalSpan, decoratedLabel);
        link.setHref((Object)control);
        link.setData("Title", (Object)labelText);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BaseFormPage.this.toggle(e);
            }
        });
        return control;
    }

    protected IMethodRichText createRichTextEditWithLinkForSection(FormToolkit toolkit, Composite parent, String labelText, int height, int width, int sectionID) {
        final int SECTION_ID = sectionID;
        ImageHyperlink link = this.createImageHyperlink(toolkit, parent, null, AuthoringUIImages.IMG_COLLAPSED);
        link.setToolTipText(AuthoringUIResources.openRTE);
        Label decoratedLabel = BaseFormPage.createDecoratedLabel(toolkit, parent, labelText);
        IMethodRichText control = this.createRichTextEdit(toolkit, parent, 578, 768, height, width, 1, decoratedLabel);
        link.setHref((Object)control);
        link.setData("Title", (Object)labelText);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                BaseFormPage.this.toggle(e, SECTION_ID);
            }
        });
        return control;
    }

    protected IMethodRichTextEditor createRichTextEditor(FormToolkit toolkit, Composite parent, int style, int gridDataStyle, int height, int width, int horizontalSpan, Label label) {
        IMethodRichTextEditor editor = MethodFormToolkit.createRichTextEditor(toolkit, parent, "", style, this.contentElementPath, this.methodElement, label, this.getEditor().getEditorSite());
        GridData gridData = new GridData(gridDataStyle);
        gridData.heightHint = height;
        gridData.widthHint = width;
        gridData.horizontalSpan = horizontalSpan;
        editor.setLayoutData(gridData);
        return editor;
    }

    protected Combo createCombo(Composite parent, int style, int gridDataStyle) {
        Combo control = new Combo(parent, style);
        return control;
    }

    protected Combo createCombo(Composite parent) {
        return this.createCombo(parent, 0x80000C, 768);
    }

    protected Combo createCComboWithLabel(FormToolkit toolkit, Composite parent, String textLabel, int style, int gridDataStyle) {
        BaseFormPage.createLabel(toolkit, parent, textLabel);
        return this.createCombo(parent, style, gridDataStyle);
    }

    protected Combo createComboWithLabel(FormToolkit toolkit, Composite parent, String labelText) {
        BaseFormPage.createLabel(toolkit, parent, labelText);
        return this.createCombo(parent, 0x80000C, 768);
    }

    protected Composite createComposite(FormToolkit toolkit, Section section) {
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, false));
        section.setClient((Control)composite);
        return composite;
    }

    protected static Composite createComposite(FormToolkit toolkit, Composite parent, int gridDataStyle, int verticalSpan, int horizontalSpan, int numColumns) {
        Composite composite = toolkit.createComposite(parent, 0);
        GridData gridData = new GridData(gridDataStyle);
        gridData.verticalSpan = verticalSpan;
        gridData.horizontalSpan = horizontalSpan;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        return composite;
    }

    protected static Composite createComposite(FormToolkit toolkit, Composite parent, int verticalSpan) {
        return BaseFormPage.createComposite(toolkit, parent, 1808, verticalSpan, 1, 1);
    }

    protected static Composite createCompositeForButtons(FormToolkit toolkit, Composite parent) {
        return BaseFormPage.createComposite(toolkit, parent, 68, -1, -1, 1);
    }

    protected Composite createExpandedComposite(FormToolkit toolkit, Composite parent) {
        Composite expandedComposite = toolkit.createComposite(parent, 0);
        expandedComposite.setLayoutData((Object)new GridData(768));
        expandedComposite.setLayout((Layout)new GridLayout(2, false));
        expandedComposite.setVisible(false);
        return expandedComposite;
    }

    protected static Table createTable(FormToolkit toolkit, Composite parent, int style, int gridDataStyle, int height, int width, int verticalSpan, int horizontalSpan) {
        Table table = toolkit.createTable(parent, style);
        GridData gridData = new GridData(gridDataStyle);
        gridData.heightHint = height;
        gridData.widthHint = width;
        gridData.verticalSpan = verticalSpan;
        gridData.horizontalSpan = horizontalSpan;
        table.setLayoutData((Object)gridData);
        return table;
    }

    protected static Table createTable(FormToolkit toolkit, Composite parent, int type) {
        switch (type) {
            case 0: {
                return BaseFormPage.createTable(toolkit, parent, 2, 1808, 56, 200, 1, 1);
            }
            case 1: {
                return BaseFormPage.createTable(toolkit, parent, 2, 1808, 112, 200, 1, 1);
            }
            case 2: {
                return BaseFormPage.createTable(toolkit, parent, 2, 1808, 200, 200, 1, 1);
            }
            case 3: {
                return BaseFormPage.createTable(toolkit, parent, 2, 768, 20, 200, 1, 1);
            }
        }
        throw new IllegalArgumentException();
    }

    protected static Button createButton(FormToolkit toolkit, Composite parent, int type) {
        Button button;
        switch (type) {
            case 0: {
                button = toolkit.createButton(parent, AuthoringUIText.ADD_BUTTON_TEXT, 0);
                break;
            }
            case 1: {
                button = toolkit.createButton(parent, AuthoringUIText.REMOVE_BUTTON_TEXT, 0);
                break;
            }
            case 2: {
                button = toolkit.createButton(parent, AuthoringUIText.UP_BUTTON_TEXT, 0);
                break;
            }
            case 3: {
                button = toolkit.createButton(parent, AuthoringUIText.DOWN_BUTTON_TEXT, 0);
                break;
            }
            case 4: {
                button = toolkit.createButton(parent, AuthoringUIText.ORDER_BUTTON_TEXT, 0);
                break;
            }
            case 5: {
                button = toolkit.createButton(parent, AuthoringUIText.SELECT_BUTTON_TEXT, 0);
                break;
            }
            case 6: {
                button = toolkit.createButton(parent, AuthoringUIText.CLEAR_BUTTON_TEXT, 0);
                break;
            }
            case 7: {
                button = toolkit.createButton(parent, AuthoringUIText.ATTACH_BUTTON_TEXT, 0);
                break;
            }
            case 9: {
                button = toolkit.createButton(parent, AuthoringUIText.ATTACH_URL_BUTTON_TEXT, 0);
                break;
            }
            case 8: {
                button = toolkit.createButton(parent, AuthoringUIText.DETACH_BUTTON_TEXT, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        button.setLayoutData((Object)new GridData(768));
        button.setEnabled(false);
        return button;
    }

    public int getRichTextEditorHeight() {
        return this.form.getBounds().height - 96;
    }

    public int getRichTextEditorWidth() {
        return this.form.getBounds().width - 64;
    }

    public MethodElement getMethodElement() {
        return this.methodElement;
    }
}

