/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.common.ui.util.CommonPreferences;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.ui.preferences.BasePreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthoringPreferencePage
extends BasePreferencePage
implements ModifyListener {
    private static int MIN_PREFERENCE_HISTORY_SIZE = 1;
    private static int MAX_PREFERENCE_HISTORY_SIZE = 20;
    private Composite composite;
    private Text defaultLibraryPathText;
    private Button browseButton;
    private Button discardUnresolvedReferencesCheckbox;
    private Button useNewExtendsSemanticsCheckbox;
    private Button enableLibraryValidationCheckbox;
    private Text preferenceHistorySizeText;
    private Button enableUIFieldsCheckbox;

    protected Control createContents(Composite parent) {
        this.composite = AuthoringPreferencePage.createGridLayoutComposite((Composite)parent, (int)1);
        Group libraryGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.methodLibraryGroup_text, (int)3);
        AuthoringPreferencePage.createLabel((Composite)libraryGroup, (String)AuthoringUIResources.defaultPathLabel_text);
        this.defaultLibraryPathText = AuthoringPreferencePage.createEditableText((Composite)libraryGroup);
        this.browseButton = AuthoringPreferencePage.createButton((Composite)libraryGroup, (String)AuthoringUIText.BROWSE_BUTTON_TEXT);
        this.discardUnresolvedReferencesCheckbox = AuthoringPreferencePage.createCheckbox((Composite)libraryGroup, (String)AuthoringUIResources.discardunresolvedref, (int)3);
        Group modelingGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.modelingGroup_text, (int)1);
        this.useNewExtendsSemanticsCheckbox = AuthoringPreferencePage.createCheckbox((Composite)modelingGroup, (String)AuthoringUIResources.extend_semantics_button_text);
        Group userInterfaceGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.userInterfaceGroup_text, (int)2);
        AuthoringPreferencePage.createLabel((Composite)userInterfaceGroup, (String)AuthoringUIResources.default_list_length_label);
        this.preferenceHistorySizeText = AuthoringPreferencePage.createEditableText((Composite)userInterfaceGroup, (String)"", (int)25);
        Group debugGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.debugGroup_text, (int)2);
        this.enableLibraryValidationCheckbox = AuthoringPreferencePage.createCheckbox((Composite)debugGroup, (String)AuthoringUIResources.enableLibraryValidationCheckbox_text);
        Group editorGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.editorGroup_text, (int)2);
        this.enableUIFieldsCheckbox = AuthoringPreferencePage.createCheckbox((Composite)editorGroup, (String)AuthoringUIResources.enableUIFieldsCheckbox_text);
        this.initControls();
        this.addListeners();
        return this.composite;
    }

    protected void initControls() {
        this.defaultLibraryPathText.setText(LibraryUIPreferences.getDefaultLibraryPath());
        this.discardUnresolvedReferencesCheckbox.setSelection(LibraryPreferences.getDiscardUnresolvedReferences());
        this.useNewExtendsSemanticsCheckbox.setSelection(LibraryPreferences.getUseNewExtendsSemantics());
        this.preferenceHistorySizeText.setText("" + CommonPreferences.getPreferenceHistorySize());
        this.enableLibraryValidationCheckbox.setSelection(AuthoringUIPreferences.getEnableLibraryValidation());
        this.enableUIFieldsCheckbox.setSelection(AuthoringUIPreferences.getEnableUIFields());
    }

    protected void addListeners() {
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthoringPreferencePage.this.openDirectoryDialog();
            }
        });
        this.preferenceHistorySizeText.addModifyListener((ModifyListener)this);
        this.enableUIFieldsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(shell.getText(), AuthoringUIResources.enableUIFieldsChange_message)) {
                    EditorChooser.getInstance().closeAllMethodEditorsWithSaving();
                } else {
                    AuthoringPreferencePage.this.enableUIFieldsCheckbox.setSelection(!AuthoringPreferencePage.this.enableUIFieldsCheckbox.getSelection());
                }
            }
        });
    }

    public void modifyText(ModifyEvent e) {
        this.setErrorMessage(null);
        this.setValid(true);
        int value = 0;
        if (e.widget == this.preferenceHistorySizeText && ((value = this.getPreferenceHistorySize()) < MIN_PREFERENCE_HISTORY_SIZE || value > MAX_PREFERENCE_HISTORY_SIZE)) {
            this.setErrorMessage(AuthoringUIResources.bind((String)AuthoringUIResources.invalidPreferenceHistorySizeError_msg, (Object[])new Object[]{new Integer(MIN_PREFERENCE_HISTORY_SIZE), new Integer(MAX_PREFERENCE_HISTORY_SIZE)}));
            this.setValid(false);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        String defaultLibraryPath = LibraryUIPreferences.getInitialDefaultLibraryPath();
        LibraryUIPreferences.setDefaultLibraryPath((String)defaultLibraryPath);
        this.defaultLibraryPathText.setText(defaultLibraryPath);
        boolean discardUnresolvedReferences = LibraryPreferences.getDefaultDiscardUnresolvedReferences();
        LibraryPreferences.setDiscardUnresolvedReferences((boolean)discardUnresolvedReferences);
        this.discardUnresolvedReferencesCheckbox.setSelection(discardUnresolvedReferences);
        boolean useNewExtendsSemantics = LibraryPreferences.getDefaultUseNewExtendsSemantics();
        LibraryPreferences.setUseNewExtendsSemantics((boolean)useNewExtendsSemantics);
        this.useNewExtendsSemanticsCheckbox.setSelection(useNewExtendsSemantics);
        int preferenceHistorySize = CommonPreferences.getDefaultPreferenceHistorySize();
        CommonPreferences.setPreferenceHistorySize((int)preferenceHistorySize);
        this.preferenceHistorySizeText.setText("" + preferenceHistorySize);
        boolean enableLibraryValidation = AuthoringUIPreferences.getDefaultEnableLibraryValidation();
        AuthoringUIPreferences.setEnableLibraryValidation(enableLibraryValidation);
        this.enableLibraryValidationCheckbox.setSelection(enableLibraryValidation);
        boolean enableUIFields = AuthoringUIPreferences.getDefaultEnableUIFields();
        AuthoringUIPreferences.setEnableUIFields(enableUIFields);
        this.enableUIFieldsCheckbox.setSelection(enableUIFields);
    }

    public boolean performOk() {
        LibraryUIPreferences.setDefaultLibraryPath((String)this.getDefaultLibraryPath());
        LibraryPreferences.setDiscardUnresolvedReferences((boolean)this.getDiscardUnresolvedReferences());
        LibraryPreferences.setUseNewExtendsSemantics((boolean)this.getUseNewExtendsSemantics());
        CommonPreferences.setPreferenceHistorySize((int)this.getPreferenceHistorySize());
        AuthoringUIPreferences.setEnableLibraryValidation(this.getEnableLibraryValidation());
        AuthoringUIPreferences.setEnableUIFields(this.getEnableUIFields());
        LibraryUIPlugin.getDefault().updateLayoutSettings();
        return true;
    }

    protected String getDefaultLibraryPath() {
        return this.defaultLibraryPathText.getText().trim();
    }

    protected boolean getDiscardUnresolvedReferences() {
        return this.discardUnresolvedReferencesCheckbox.getSelection();
    }

    protected boolean getUseNewExtendsSemantics() {
        return this.useNewExtendsSemanticsCheckbox.getSelection();
    }

    protected int getPreferenceHistorySize() {
        return StrUtil.getIntValue((String)this.preferenceHistorySizeText.getText().trim(), (int)0);
    }

    protected boolean getEnableLibraryValidation() {
        return this.enableLibraryValidationCheckbox.getSelection();
    }

    protected boolean getEnableUIFields() {
        return this.enableUIFieldsCheckbox.getSelection();
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog dd = new DirectoryDialog(this.composite.getShell(), 0);
            String path = dd.open();
            if (path != null) {
                this.defaultLibraryPathText.setText(path);
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }
}

