/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ConfigurationLabelProvider
extends VariabilityElementLabelProvider
implements IColorProvider {
    MethodConfiguration config = null;

    public ConfigurationLabelProvider(MethodConfiguration config, AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.config = config;
    }

    public Image getImage(Object object) {
        return super.getImage(object);
    }

    public String getText(Object object) {
        IWorkbenchAdapter adapter;
        String name = null;
        Object element = null;
        if (object instanceof MethodElement) {
            element = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)object), (MethodConfiguration)this.config);
        } else if (object instanceof FeatureValueWrapperItemProvider) {
            element = ((FeatureValueWrapperItemProvider)object).getValue();
        }
        if (object instanceof IWrapperItemProvider) {
            element = TngUtil.unwrap((Object)object);
        }
        if (element != null) {
            name = element instanceof BreakdownElement ? ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)element)) : TngUtil.getPresentationName((Object)element);
        }
        if ((adapter = (IWorkbenchAdapter)(object instanceof IWorkbenchAdapter ? object : (object instanceof IAdaptable ? ((IAdaptable)object).getAdapter(IWorkbenchAdapter.class) : null))) != null) {
            return adapter.getLabel(object);
        }
        if (name == null) {
            name = super.getText(object);
        }
        return name;
    }

    public String getColumnText(Object object, int index) {
        return this.getText(object);
    }

    public Image getColumnImage(Object object, int index) {
        return this.getImage(object);
    }

    public void dispose() {
        this.config = null;
        super.dispose();
    }

    public Color getForeground(Object element) {
        if (this.isSuppressed(element)) {
            return Colors.SUPRESSED_ELEMENT_LABEL;
        }
        if (this.isExternal(element)) {
            return Colors.INHERITED_ELEMENT_LABEL;
        }
        return null;
    }

    private boolean isSuppressed(Object element) {
        Object top;
        if (element instanceof BreakdownElement) {
            Process proc = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)element));
            if (proc != null) {
                return Suppression.getSuppression((Process)proc).isSuppressed(element);
            }
        } else if (element instanceof BreakdownElementWrapperItemProvider && (top = ((BreakdownElementWrapperItemProvider)element).getTopItem()) instanceof Process) {
            return Suppression.getSuppression((Process)((Process)top)).isSuppressed(element);
        }
        return false;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public boolean isExternal(Object element) {
        return ProcessUtil.isInherited((Object)element) || ProcessUtil.isContributed((Object)element);
    }

    public Font getFont(Object element) {
        if (ProcessUtil.isInherited((Object)element)) {
            return italicFont;
        }
        if (ProcessUtil.isContributed((Object)element)) {
            return boldItalicFont;
        }
        return regularFont;
    }
}

