/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.common.utils.IMarkerAttributeContributer;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.configuration.closure.IConfigurationError;
import org.eclipse.epf.library.edit.navigator.ConfigurationsItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class ConfigurationMarkerHelper {
    public static final ConfigurationMarkerHelper INSTANCE = new ConfigurationMarkerHelper();
    public static final String ATTR_ERROR_ID = "errorID";
    public static final String ATTR_CONFIG_GUID = "configGuid";
    public static final String ATTR_MESSAGE_ID = "messageId";
    public static final String ATTR_ERROR_ELEMENT_GUID = "elementGuid";
    public static final String ATTR_CAUSE_ELEMENT_GUID = "causeGuid";
    public static final String MARKER_ID = "org.eclipse.epf.authoring.ui.configuration";
    private static ContainerMap containersOfMarkedObjects = new ContainerMap();

    private ConfigurationMarkerHelper() {
    }

    protected String getMarkerID() {
        return MARKER_ID;
    }

    protected IFile getFile(URI uri) {
        if (uri.isFile()) {
            return (IFile)FileManager.getResourceForLocation((String)uri.toFileString());
        }
        String scheme = uri.scheme();
        if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(URI.decode((String)uri.segment(j)));
                ++j;
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
        }
        return null;
    }

    public static boolean isInvalid(Object object) {
        if (object instanceof ConfigurationsItemProvider) {
            Collection children = ((ConfigurationsItemProvider)object).getChildren(object);
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Object obj = TngUtil.unwrap(iter.next());
                if (containersOfMarkedObjects.containsKey(obj)) {
                    return true;
                }
                if (!(obj instanceof MethodConfiguration) || !INSTANCE.hasMarkers((MethodConfiguration)obj)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof MethodConfiguration && INSTANCE.hasMarkers((MethodConfiguration)object)) {
            return true;
        }
        return containersOfMarkedObjects.containsKey(object);
    }

    public void deleteMarker(MethodConfiguration config, IConfigurationError error) {
        try {
            IMarker marker = this.getMarker(config, error);
            if (marker != null) {
                marker.delete();
                ConfigurationMarkerHelper.containersOfMarkedObjects.unmarkContainers((MethodElement)config);
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public IMarker createMarker(MethodConfiguration config, IConfigurationError error) {
        IMarker existingMarker = this.getMarker(config, error);
        if (existingMarker != null) {
            this.adjustMarker(existingMarker, config, error);
            return existingMarker;
        }
        try {
            IResource resource = this.getIResource(config);
            if (resource != null && resource.exists()) {
                IMarker marker = resource.createMarker(this.getMarkerID());
                marker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.epf.authoring.ui.editors.ConfigurationEditor");
                this.adjustMarker(marker, config, error);
                ConfigurationMarkerHelper.containersOfMarkedObjects.markContainers((MethodElement)config);
                return marker;
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    public void adjustMarker(IMarker marker, MethodConfiguration config, IConfigurationError error) {
        if (config == null || error == null) {
            return;
        }
        try {
            IMarkerAttributeContributer attAdder;
            if (marker == null) {
                marker = this.getMarker(config, error);
            }
            if (marker == null) {
                return;
            }
            marker.setAttribute("severity", error.getSeverity());
            String message = this.getMessage(error);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("lineNumber", 0);
            marker.setAttribute(ATTR_CONFIG_GUID, (Object)config.getGuid());
            marker.setAttribute(ATTR_ERROR_ID, (Object)error.getId());
            marker.setAttribute(ATTR_MESSAGE_ID, (Object)error.getMessageId());
            if (error.getErrorMethodElement() != null) {
                marker.setAttribute("location", (Object)TngUtil.getLabelWithPath((Object)error.getErrorMethodElement()));
                marker.setAttribute(ATTR_ERROR_ELEMENT_GUID, (Object)error.getErrorMethodElement().getGuid());
                marker.setAttribute("org.eclipse.ui.views.markers.name", (Object)error.getErrorMethodElement().getName());
            }
            if (error.getCauseMethodElement() != null) {
                marker.setAttribute(ATTR_CAUSE_ELEMENT_GUID, (Object)error.getCauseMethodElement().getGuid());
            }
            if ((attAdder = ExtensionHelper.getMarkerAttributeContributer()) != null) {
                attAdder.addAddtionalAttributes(marker, (Object)error);
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public boolean hasMarker(MethodConfiguration config, IConfigurationError error) {
        return this.getMarker(config, error) != null;
    }

    public boolean hasMarkers(MethodConfiguration config) {
        IResource resource = this.getIResource(config);
        if (resource != null && resource.exists()) {
            try {
                IMarker[] markers = resource.findMarkers(this.getMarkerID(), true, 0);
                return markers.length > 0;
            }
            catch (CoreException e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return false;
    }

    public IMarker getMarker(MethodConfiguration config, IConfigurationError error) {
        if (config == null || error == null) {
            return null;
        }
        try {
            IResource resource = this.getIResource(config);
            if (resource != null) {
                IMarker[] markers = resource.findMarkers(this.getMarkerID(), false, 0);
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    String markerErrorId = (String)marker.getAttribute(ATTR_ERROR_ID);
                    if (error.getId().equals(markerErrorId)) {
                        return marker;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    private String getMessage(IConfigurationError error) {
        return error.getErrorMessage();
    }

    private IResource getIResource(MethodConfiguration config) {
        Resource resource = config.eResource();
        URI uri = resource.getURI();
        uri = resource.getResourceSet().getURIConverter().normalize(uri);
        return this.getFile(uri);
    }

    public MethodConfiguration getConfig(IMarker marker) {
        if (marker == null) {
            return null;
        }
        try {
            String configGuid = (String)marker.getAttribute(ATTR_CONFIG_GUID);
            MethodElement e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(configGuid);
            if (e instanceof MethodConfiguration) {
                return (MethodConfiguration)e;
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    public MethodElement getErrorMethodElement(IMarker marker) {
        if (marker == null) {
            return null;
        }
        try {
            MethodElement e;
            String errorGuid = (String)marker.getAttribute(ATTR_ERROR_ELEMENT_GUID);
            if (errorGuid != null && (e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(errorGuid)) instanceof MethodElement) {
                return e;
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    public MethodElement getCauseMethodElement(IMarker marker) {
        if (marker == null) {
            return null;
        }
        try {
            MethodElement e;
            String causeGuid = (String)marker.getAttribute(ATTR_CAUSE_ELEMENT_GUID);
            if (causeGuid != null && (e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(causeGuid)) instanceof MethodElement) {
                return e;
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerMap
    extends HashMap<Object, Integer> {
        private static final long serialVersionUID = 1L;

        public ContainerMap() {
            this.initMap();
            LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

                public void libraryOpened(MethodLibrary library) {
                    ContainerMap.this.initMap();
                }

                public void libraryClosed(MethodLibrary library) {
                    ContainerMap.this.clear();
                }

                public void libraryReopened(MethodLibrary library) {
                    ContainerMap.this.initMap();
                }
            });
        }

        private void initMap() {
            IProject prj;
            this.clear();
            MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
            if (lib != null && (prj = MethodLibraryProject.findProject((MethodLibrary)lib)) != null) {
                try {
                    IMarker[] markers = prj.findMarkers(INSTANCE.getMarkerID(), false, 2);
                    int i = 0;
                    while (i < markers.length) {
                        IMarker marker = markers[i];
                        String guid = (String)marker.getAttribute(ConfigurationMarkerHelper.ATTR_CONFIG_GUID);
                        MethodElement e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(guid);
                        if (e != null) {
                            this.markContainers(e);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        }

        private void increment(Object object) {
            Integer count = this.containsKey(object) ? (Integer)this.get(object) : new Integer(0);
            count = count + 1;
            this.put(object, count);
        }

        private void decrement(Object object) {
            if (this.containsKey(object)) {
                Integer count = (Integer)this.get(object);
                if (count == 1) {
                    this.remove(object);
                } else {
                    count = count - 1;
                    this.put(object, count);
                }
            }
        }

        private void markContainers(MethodElement e) {
            EObject container = e.eContainer();
            while (container != null) {
                this.increment(container);
                container = container.eContainer();
            }
        }

        private void unmarkContainers(MethodElement e) {
            EObject container = e.eContainer();
            while (container != null) {
                this.decrement(container);
                container = container.eContainer();
            }
        }
    }
}

