/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.actions.ConfigurationViewEditAction;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.IMenuAction;
import org.eclipse.epf.authoring.ui.actions.LibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryViewCopyAction;
import org.eclipse.epf.authoring.ui.actions.LibraryViewFindElementAction;
import org.eclipse.epf.authoring.ui.dnd.LibraryViewerDragAdapter;
import org.eclipse.epf.authoring.ui.providers.ConfigurationLabelProvider;
import org.eclipse.epf.authoring.ui.providers.IContentProviderFactory;
import org.eclipse.epf.authoring.ui.views.AbstractBaseView;
import org.eclipse.epf.authoring.ui.views.ConfigurationViewFilter;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.ui.util.ClipboardUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationView
extends AbstractBaseView
implements ILibraryChangeListener {
    public static final String VIEW_ID = ConfigurationView.class.getName();
    private String configName;
    private TreeViewer treeViewer;
    private IDoubleClickListener doubleClickListener;
    private IFilter configFilter;
    private List<Action> menuActionProviders;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.createActions(site);
        LibraryUIManager.getInstance();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, AuthoringUIHelpContexts.CONFIGURATION_VIEW_CONTEXT);
        this.editingDomain = new AdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)new BasicCommandStack());
        this.adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
        this.setConfiguration(null);
        this.loadMenuActionProviders();
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        int i = 0;
        while (i < this.menuActionProviders.size()) {
            try {
                Action actionProvider = this.menuActionProviders.get(i);
                if (actionProvider instanceof Action) {
                    mgr.add((IAction)actionProvider);
                    if (actionProvider instanceof IMenuAction) {
                        ((IMenuAction)actionProvider).init((IViewPart)this);
                    }
                }
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            ++i;
        }
    }

    private List<Action> loadMenuActionProviders() {
        if (this.menuActionProviders == null) {
            this.menuActionProviders = ExtensionManager.getExtensions((String)AuthoringUIPlugin.getDefault().getId(), (String)"configurationViewMenuProvider", Action.class);
        }
        return this.menuActionProviders;
    }

    @Override
    public void libraryCreated(MethodLibrary library) {
    }

    @Override
    public void libraryOpened(MethodLibrary library) {
    }

    @Override
    public void libraryClosed(MethodLibrary library) {
        this.setInputForViewer(null);
        if (this.adapterFactory instanceof ComposedAdapterFactory) {
            ((ComposedAdapterFactory)this.adapterFactory).dispose();
        }
    }

    @Override
    public void librarySet(MethodLibrary library) {
        ILibraryManager manager;
        MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (config != null && config.eContainer() != library) {
            this.setMethodConfiguration(null);
        }
        if ((manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            manager.addListener((ILibraryChangeListener)this);
        }
    }

    public void libraryChanged(int option, Collection changedItems) {
        switch (option) {
            case 16: {
                if (changedItems == null) break;
                for (Object element : changedItems) {
                    if (!(element instanceof MethodConfiguration) || !((MethodConfiguration)element).getName().equals(this.getCurrentConfig())) continue;
                    this.setMethodConfiguration(null);
                }
                break;
            }
            case 8: {
                if (changedItems == null) break;
                for (Object element : changedItems) {
                    if (!(element instanceof MethodConfiguration) || !((MethodConfiguration)element).equals(LibraryService.getInstance().getCurrentMethodConfiguration())) continue;
                    this.setContentDescription(((MethodConfiguration)element).getName());
                }
                break;
            }
        }
    }

    @Override
    public void configurationSet(MethodConfiguration config) {
        this.setMethodConfiguration(config);
    }

    public String getCurrentConfig() {
        return this.configName;
    }

    @Override
    public void setFocus() {
        this.actionBarContributor.setActiveView((IViewPart)this);
        IStructuredSelection selected = (IStructuredSelection)this.getSelection();
        if (selected.isEmpty()) {
            this.actionBarContributor.disableGlobalEditMenu();
        } else {
            this.actionBarContributor.enableGlobalEditMenu();
        }
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    @Override
    public void createViewer(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(content);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        int dndOperations = 3;
        Transfer[] transfers = new Transfer[]{HTMLTransfer.getInstance(), TextTransfer.getInstance(), LocalTransfer.getInstance()};
        this.treeViewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new LibraryViewerDragAdapter((Viewer)this.treeViewer));
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                UIActionDispatcher.getInstance().handleDoubleClickEvent(event);
            }
        };
        this.treeViewer.addDoubleClickListener(this.doubleClickListener);
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
    }

    public void createActions(IViewSite viewSite) {
        Action editAction = new Action(AuthoringUIResources.actionLabel_edit){

            public void run() {
                UIActionDispatcher.editConfiguration(ConfigurationView.this.configName);
            }
        };
        editAction.setToolTipText(AuthoringUIResources.editConfiguration_tooltip);
    }

    private void reset() {
        IBaseLabelProvider labelProvider;
        this.configName = null;
        if (this.adapterFactory != null) {
            if (this.adapterFactory instanceof IDisposable) {
                ((IDisposable)this.adapterFactory).dispose();
            }
            this.adapterFactory = null;
        }
        this.editingDomain.setAdapterFactory(null);
        IContentProvider contentProvider = this.treeViewer.getContentProvider();
        if (contentProvider != null) {
            contentProvider.dispose();
        }
        if ((labelProvider = this.treeViewer.getLabelProvider()) != null) {
            labelProvider.dispose();
        }
        StructuredSelection emptySelection = new StructuredSelection();
        this.actionDispatcher.setSelection((ISelection)emptySelection);
        UIActionDispatcher.getInstance().setSelection((ISelection)emptySelection);
    }

    private IFilter createFilter(MethodConfiguration config) {
        IContentProviderFactory cpFactory = this.getContentProviderFactory();
        ConfigurationViewFilter filter = null;
        if (cpFactory != null) {
            filter = cpFactory.createFilter(config, (Viewer)this.treeViewer);
        }
        return filter != null ? filter : new ConfigurationViewFilter(config, (Viewer)this.treeViewer);
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (this.treeViewer.getInput() == config) {
            return;
        }
        String title = "";
        if (config != null) {
            this.configName = config.getName();
            this.configFilter = this.createFilter(config);
            this.adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory(this.configFilter);
            this.editingDomain.setAdapterFactory(this.adapterFactory);
            AdapterFactoryContentProvider contentProvider = (AdapterFactoryContentProvider)this.treeViewer.getContentProvider();
            if (contentProvider == null) {
                contentProvider = this.createContentProvider();
            } else {
                contentProvider.setAdapterFactory(this.adapterFactory);
            }
            this.treeViewer.setContentProvider((IContentProvider)contentProvider);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider(config, this.adapterFactory));
            title = config.getName();
        } else {
            IBaseLabelProvider labelProvider;
            this.configName = null;
            if (this.adapterFactory != null) {
                if (this.adapterFactory instanceof IDisposable) {
                    ((IDisposable)this.adapterFactory).dispose();
                }
                this.adapterFactory = null;
            }
            this.editingDomain.setAdapterFactory(null);
            IContentProvider contentProvider = this.treeViewer.getContentProvider();
            if (contentProvider != null) {
                contentProvider.dispose();
            }
            if ((labelProvider = this.treeViewer.getLabelProvider()) != null) {
                labelProvider.dispose();
            }
            StructuredSelection emptySelection = new StructuredSelection();
            this.actionDispatcher.setSelection((ISelection)emptySelection);
            UIActionDispatcher.getInstance().setSelection((ISelection)emptySelection);
        }
        this.treeViewer.setInput((Object)config);
        this.setContentDescription(title);
    }

    public void setConfiguration(String name) {
        MethodConfiguration config;
        this.configName = name;
        if (name == null && (config = LibraryService.getInstance().getCurrentMethodConfiguration()) != null) {
            this.configName = config.getName();
        }
        if (this.configName != null && (config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)this.configName)) != null) {
            this.setMethodConfiguration(config);
            return;
        }
        this.configName = null;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.doubleClickListener != null) {
            this.treeViewer.removeDoubleClickListener(this.doubleClickListener);
        }
    }

    public static ConfigurationView getView() {
        boolean show = ViewHelper.isViewInCurrentPerspective(VIEW_ID);
        return (ConfigurationView)ViewHelper.findView(VIEW_ID, show);
    }

    @Override
    public Viewer getViewer() {
        return this.treeViewer;
    }

    @Override
    public ILibraryActionBarContributor createActionBarContributor() {
        return new ConfigurationViewActionBarContributor((EditingDomain)this.editingDomain);
    }

    @Override
    public void setInputForViewer(Object model) {
        if (model == null || model instanceof MethodConfiguration) {
            this.setMethodConfiguration((MethodConfiguration)model);
        } else {
            this.reset();
        }
    }

    public void refresh() {
        ConfigurationHelper.getDelegate().configViewRefreshNotified();
        if (this.configFilter instanceof ConfigurationViewFilter) {
            ((ConfigurationViewFilter)this.configFilter).refreshViewer();
        } else {
            this.getViewer().refresh();
        }
    }

    @Override
    public String getViewId() {
        return VIEW_ID;
    }

    private class ConfigurationViewActionBarContributor
    extends LibraryActionBarContributor {
        private LibraryViewFindElementAction libraryViewFindElementAction;

        public ConfigurationViewActionBarContributor(EditingDomain editingDomain) {
            super(editingDomain);
            this.validateAction = null;
        }

        public void init(IActionBars actionBars) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.copyAction = this.createCopyAction();
            this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            this.viewActionBars = actionBars;
            this.configViewEditAction = new ConfigurationViewEditAction(AuthoringUIResources.actionLabel_edit);
            actionBars.setGlobalActionHandler("org.eclipse.epf.authoring.ui.actions.openElement", (IAction)this.configViewEditAction);
            this.libraryViewFindElementAction = new LibraryViewFindElementAction(AuthoringUIResources.actionLabel_findElementInLibNav);
            actionBars.setGlobalActionHandler(LibraryViewFindElementAction.ACTION_ID, (IAction)this.libraryViewFindElementAction);
        }

        public void activate() {
            this.activeViewPart.addPropertyListener((IPropertyListener)this);
            ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.configViewEditAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.libraryViewFindElementAction);
            this.copyAction.setEditingDomain((EditingDomain)ConfigurationView.this.editingDomain);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            this.update();
        }

        public void deactivate() {
            this.activeViewPart.removePropertyListener((IPropertyListener)this);
            ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.configViewEditAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.libraryViewFindElementAction);
            this.copyAction.setEditingDomain(null);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        }

        public void update() {
            ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            this.configViewEditAction.selectionChanged((IStructuredSelection)structuredSelection);
            this.libraryViewFindElementAction.selectionChanged((IStructuredSelection)structuredSelection);
            this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
        }

        public void selectionChanged(SelectionChangedEvent event) {
        }

        public void disableGlobalEditMenu() {
            this.configViewEditAction.setEnabled(false);
        }

        public void enableGlobalEditMenu() {
            this.configViewEditAction.setEnabled(true);
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IContributionItem)new Separator("edit"));
            menuManager.add((IContributionItem)new Separator("additions-end"));
            this.addGlobalActions(menuManager);
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.configViewEditAction));
            if (PerspectiveListUtil.isAuthoringPerspective()) {
                menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.libraryViewFindElementAction));
            }
        }

        protected CopyAction createCopyAction() {
            return new LibraryViewCopyAction(){

                public Command createCommand(Collection selection) {
                    return new IdentityCommand(selection);
                }

                public void run() {
                    String links = "";
                    Iterator iter = ((IdentityCommand)this.command).getResult().iterator();
                    while (iter.hasNext()) {
                        Object item = TngUtil.unwrap(iter.next());
                        if (!(item instanceof MethodElement)) continue;
                        MethodElement e = (MethodElement)item;
                        String href = ResourceHelper.getUrl((MethodElement)e, null, (String)"html");
                        if (links.length() > 0) {
                            links = String.valueOf(links) + StrUtil.LINE_FEED;
                        }
                        links = String.valueOf(links) + ResourceHelper.getElementLink((MethodElement)e, (boolean)true, (String)("file://" + href));
                    }
                    if (links.length() > 0) {
                        ClipboardUtil.copyTextHTMLToClipboard((String)links);
                    }
                }
            };
        }

        protected void refreshViewer(Viewer viewer) {
            ConfigurationView.this.refresh();
        }
    }
}

