/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewLibraryMainPage
extends BaseWizardPage {
    public static final String PAGE_NAME = NewLibraryMainPage.class.getName();
    private Shell shell;
    private Combo libraryPathCombo;
    private Button browseButton;
    private Text briefDescText;
    private String libraryType;

    public NewLibraryMainPage() {
        super(PAGE_NAME);
        this.setTitle(AuthoringUIResources.newLibraryWizardMainPage_title);
        this.setDescription(AuthoringUIResources.newLibraryWizardMainPage_description);
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
    }

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        Composite composite = NewLibraryMainPage.createGridLayoutComposite((Composite)parent, (int)3);
        NewLibraryMainPage.createLabel((Composite)composite, (String)AuthoringUIResources.libraryPathLabel_text);
        this.libraryPathCombo = NewLibraryMainPage.createCombobox((Composite)composite);
        this.browseButton = NewLibraryMainPage.createButton((Composite)composite, (String)AuthoringUIText.BROWSE_BUTTON_TEXT);
        NewLibraryMainPage.createVerticallyAlignedLabel((Composite)composite, (String)AuthoringUIText.DESCRIPTION_TEXT);
        this.briefDescText = NewLibraryMainPage.createEditableText((Composite)composite, (int)400, (int)80, (int)1);
        Map types = LibraryManagerFactory.getInstance().getLibraryTypes();
        Iterator it = types.keySet().iterator();
        if (it.hasNext()) {
            this.libraryType = (String)it.next();
        }
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite);
    }

    protected void initControls() {
        File newLibraryDir;
        String defaultLibraryPath = LibraryUIPreferences.getDefaultLibraryPath();
        File defaultLibraryDir = new File(defaultLibraryPath);
        String newLibraryPath = null;
        int i = 1;
        while (true) {
            if (!(newLibraryDir = new File(defaultLibraryDir, "Library" + i)).exists()) break;
            ++i;
        }
        newLibraryPath = newLibraryDir.getAbsolutePath();
        List newLibraryPathsList = LibraryUIPreferences.getNewLibraryPathsList();
        if (newLibraryPath != null && newLibraryPath.length() > 0) {
            newLibraryPathsList.add(0, newLibraryPath);
        }
        if (newLibraryPathsList.size() > 0) {
            String[] newLibraryPaths = new String[newLibraryPathsList.size()];
            newLibraryPathsList.toArray(newLibraryPaths);
            this.libraryPathCombo.setItems(newLibraryPaths);
            this.libraryPathCombo.setText(newLibraryPaths[0]);
        }
    }

    protected void addListeners() {
        this.libraryPathCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLibraryMainPage.this.setPageComplete(NewLibraryMainPage.this.isPageComplete());
                NewLibraryMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.libraryPathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewLibraryMainPage.this.setPageComplete(NewLibraryMainPage.this.isPageComplete());
                NewLibraryMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(NewLibraryMainPage.this.shell, 0);
                dialog.setFilterPath(NewLibraryMainPage.this.getLibraryPath());
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    NewLibraryMainPage.this.libraryPathCombo.add(selectedDir, 0);
                    NewLibraryMainPage.this.libraryPathCombo.setText(selectedDir);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return this.getLibraryName().length() > 0;
    }

    public String getLibraryName() {
        String libName;
        String libPath = this.getLibraryPath();
        if (!libPath.equals(libName = new File(libPath).getName())) {
            return libName;
        }
        return "";
    }

    public String getLibraryPath() {
        return this.libraryPathCombo.getText().trim();
    }

    public String getLibraryDescription() {
        return this.briefDescText.getText().trim();
    }

    public String getLibraryType() {
        return this.libraryType;
    }
}

