/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.service;

import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.providers.SharedResourceDiagramDocumentProvider;
import org.eclipse.epf.diagram.ui.DiagramUIPlugin;
import org.eclipse.epf.diagram.ui.service.DiagramEditorHelper;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class DiagramEditorStatePreserver {
    private IEditorReference diagramEditorRef;
    private boolean dirty;

    public DiagramEditorStatePreserver(Object activityOrWrapper, Suppression suppression, int diagramType) {
        DiagramEditorInputProxy input = new DiagramEditorInputProxy(new DiagramEditorInput(activityOrWrapper, suppression, diagramType), DiagramEditorHelper.getDiagramPreferencesHint(diagramType));
        try {
            IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            String editorId = DiagramEditorUtil.getEditorId((int)diagramType);
            int i = 0;
            while (i < editorRefs.length) {
                IEditorPart editor;
                IEditorReference editorRef = editorRefs[i];
                if (input.equals(editorRef.getEditorInput()) && editorRef.equals(editorId) && (editor = editorRef.getEditor(false)) instanceof AbstractDiagramEditor) {
                    this.diagramEditorRef = editorRef;
                    break;
                }
                ++i;
            }
            if (this.diagramEditorRef != null) {
                this.dirty = this.diagramEditorRef.getEditor(false).isDirty();
            }
        }
        catch (Exception exception) {}
    }

    public void restore() {
        try {
            IDocumentProvider docProvider;
            AbstractDiagramEditor editor;
            if (this.diagramEditorRef != null && !this.dirty && (editor = (AbstractDiagramEditor)this.diagramEditorRef.getEditor(false)) != null && editor.isDirty() && (docProvider = editor.getDocumentProvider()) instanceof SharedResourceDiagramDocumentProvider) {
                ((SharedResourceDiagramDocumentProvider)docProvider).markDocumentAsSaved((IFileEditorInput)this.diagramEditorRef.getEditorInput());
            }
        }
        catch (Exception e) {
            DiagramUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }
}

