/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.ad.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.DiagramOptions;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.migration.diagram.DiagramMigrationPlugin;
import org.eclipse.epf.migration.diagram.MigrationExportException;
import org.eclipse.epf.migration.diagram.ad.map.IMapConstants;
import org.eclipse.epf.migration.diagram.ad.map.MapFactory;
import org.eclipse.epf.migration.diagram.ad.map.MapNode;
import org.eclipse.epf.migration.diagram.ad.map.MapUtil;
import org.eclipse.epf.migration.diagram.addwpd.map.ConnectionFactory;
import org.eclipse.epf.migration.diagram.util.MigrationUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class WorkflowExportService {
    public static final String DEFAULT_XMI_EXTENSION = ".xmi";
    protected boolean debug;
    public static WorkflowExportService singleton = null;

    public static WorkflowExportService getInstance() {
        if (singleton == null) {
            singleton = new WorkflowExportService();
        }
        return singleton;
    }

    public boolean export(Process proc, org.eclipse.epf.uma.Activity activity, String fileName, File targetDir) throws MigrationExportException {
        this.debug = DiagramMigrationPlugin.getDefault().isDebugging();
        Path exportPath = new Path(targetDir.getAbsolutePath());
        boolean endWithXmiExt = fileName.toLowerCase().endsWith(DEFAULT_XMI_EXTENSION);
        String exportXMIPath = exportPath.append(endWithXmiExt ? fileName : String.valueOf(fileName) + DEFAULT_XMI_EXTENSION).toOSString();
        URI.createFileURI((String)exportXMIPath);
        DiagramManager mgr = DiagramManager.getInstance((Process)proc, (Object)this);
        try {
            try {
                InternalTransaction tx = mgr.getEditingDomain().startTransaction(false, Collections.EMPTY_MAP);
                Resource xmires = mgr.getResource();
                tx.commit();
                IMapConstants.graphUMLNodeMap.clear();
                if (proc == activity) {
                    Map activities = MigrationUtil.getActivities(proc, true);
                    for (org.eclipse.epf.uma.Activity act : activities.values()) {
                        this.addAD(xmires, proc, act, mgr);
                        this.addADD(xmires, proc, act, mgr);
                        this.addWPD(xmires, proc, act, mgr);
                    }
                } else {
                    this.addAD(xmires, proc, activity, mgr);
                    this.addADD(xmires, proc, activity, mgr);
                    this.addWPD(xmires, proc, activity, mgr);
                }
                EList contents = xmires.getContents();
                if (contents != null && !contents.isEmpty()) {
                    xmires.save(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MigrationExportException(e);
            }
        }
        finally {
            if (mgr != null) {
                mgr.removeConsumer((Object)this);
            }
        }
        return true;
    }

    private void addDataToResource_WPD(Resource xmiResource, Process proc, org.eclipse.epf.uma.Activity umaActivity) {
        org.eclipse.epf.uma.Diagram d = GraphicalDataManager.getInstance().getUMADiagram(umaActivity, 1, false);
        if (d != null) {
            if (this.debug) {
                System.out.println("WPDD->" + proc.getName() + "::" + umaActivity.getName());
            }
            WorkProductDependencyDiagram wpdDiagram = ModelFactory.eINSTANCE.createWorkProductDependencyDiagram();
            this.addDataToResource_ADDorWPD(proc, umaActivity, xmiResource, (org.eclipse.epf.diagram.model.Diagram)wpdDiagram);
        }
    }

    private void addDataToResource_ADD(Resource xmiResource, Process proc, org.eclipse.epf.uma.Activity umaActivity) {
        org.eclipse.epf.uma.Diagram d = GraphicalDataManager.getInstance().getUMADiagram(umaActivity, 2, false);
        if (d != null) {
            if (this.debug) {
                System.out.println("ADD->" + proc.getName() + ":" + umaActivity.getName());
            }
            ActivityDetailDiagram addDiagram = ModelFactory.eINSTANCE.createActivityDetailDiagram();
            this.addDataToResource_ADDorWPD(proc, umaActivity, xmiResource, (org.eclipse.epf.diagram.model.Diagram)addDiagram);
        }
    }

    private void addDataToResource_ADDorWPD(Process proc, org.eclipse.epf.uma.Activity umaActivity, Resource xmiResource, org.eclipse.epf.diagram.model.Diagram addOrWpdDiagram) {
        Suppression sup = new Suppression(proc);
        addOrWpdDiagram.setSuppression(sup);
        String kind = null;
        PreferencesHint prefHint = null;
        if (addOrWpdDiagram instanceof ActivityDetailDiagram) {
            addOrWpdDiagram.setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            kind = "ADD";
            prefHint = ActivityDetailDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        } else if (addOrWpdDiagram instanceof WorkProductDependencyDiagram) {
            kind = "WPDD";
            prefHint = WPDDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        } else {
            throw new UnsupportedOperationException();
        }
        addOrWpdDiagram.setObject((Object)umaActivity);
        addOrWpdDiagram.setLinkedElement((MethodElement)umaActivity);
        org.eclipse.epf.uma.Diagram umaDiagram = addOrWpdDiagram.getUMADiagram();
        if (umaDiagram != null && umaDiagram.getSuppressed().booleanValue()) {
            if (addOrWpdDiagram instanceof ActivityDetailDiagram) {
                DiagramOptions.setPublishADD((org.eclipse.epf.uma.Activity)umaActivity, (boolean)false);
            } else if (addOrWpdDiagram instanceof WorkProductDependencyDiagram) {
                DiagramOptions.setPublishWPDD((org.eclipse.epf.uma.Activity)umaActivity, (boolean)false);
            }
        }
        if (addOrWpdDiagram instanceof ActivityDetailDiagram) {
            boolean value = GraphicalDataHelper.isAutoLayout((ActivityDetailDiagram)((ActivityDetailDiagram)addOrWpdDiagram));
            ((ActivityDetailDiagram)addOrWpdDiagram).setAutoLayout(value);
        }
        Diagram diagram = ViewService.createDiagram((EObject)addOrWpdDiagram, (String)kind, (PreferencesHint)prefHint);
        diagram.setElement((EObject)addOrWpdDiagram);
        diagram.setName(umaActivity.getName());
        xmiResource.getContents().add((Object)addOrWpdDiagram);
        xmiResource.getContents().add((Object)diagram);
        ArrayList<org.eclipse.epf.diagram.model.Node> nodes = new ArrayList<org.eclipse.epf.diagram.model.Node>();
        HashMap<org.eclipse.epf.diagram.model.Node, Node> map = new HashMap<org.eclipse.epf.diagram.model.Node, Node>();
        EList diagramNodes = addOrWpdDiagram.getNodes();
        for (Object obj : diagramNodes) {
            if (!(obj instanceof org.eclipse.epf.diagram.model.Node)) continue;
            org.eclipse.epf.diagram.model.Node node = (org.eclipse.epf.diagram.model.Node)obj;
            if (obj instanceof TypedNode && ((TypedNode)obj).getType() == 6) {
                Node text = MapUtil.createText(diagram, (org.eclipse.epf.diagram.model.Node)obj);
                diagram.insertChild((View)text);
                continue;
            }
            Node notationNode = MapUtil.createNotationNode_ADDorWPD(diagram, node);
            if (notationNode == null) continue;
            diagram.insertChild((View)notationNode);
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            bounds.setHeight(node.getHeight());
            bounds.setWidth(node.getWidth());
            bounds.setX(node.getLocation().x);
            bounds.setY(node.getLocation().y);
            notationNode.setLayoutConstraint((LayoutConstraint)bounds);
            notationNode.setElement((EObject)node);
            nodes.add(node);
            map.put(node, notationNode);
        }
        ConnectionFactory factory = new ConnectionFactory(diagram, map, kind);
        for (Object e : nodes) {
            if (!(e instanceof org.eclipse.epf.diagram.model.Node)) continue;
            factory.outgoingConnections((org.eclipse.epf.diagram.model.Node)e);
        }
        for (Object e : nodes) {
            if (!(e instanceof org.eclipse.epf.diagram.model.Node)) continue;
            factory.incomingConnections((org.eclipse.epf.diagram.model.Node)e);
        }
    }

    private void addDataToResource_AD(Resource xmiResource, Process proc, org.eclipse.epf.uma.Activity umaActivity) {
        EList diagramNodes;
        EObject activity;
        org.eclipse.epf.uma.Diagram d = GraphicalDataManager.getInstance().getUMADiagram(umaActivity, 0, false);
        if (d == null) {
            return;
        }
        if (this.debug) {
            System.out.println("AD->" + proc.getName() + ":" + umaActivity.getName());
        }
        if ((activity = UMLFactory.eINSTANCE.create(UMLPackage.eINSTANCE.getActivity())) instanceof Activity) {
            ((Activity)activity).setName(umaActivity.getName());
        }
        if (activity instanceof EModelElement) {
            BridgeHelper.associate((EModelElement)((EModelElement)activity), (MethodElement)umaActivity);
        }
        Diagram diagram = ViewService.createDiagram((EObject)activity, (String)"AD", (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        diagram.setElement(activity);
        if (activity instanceof Activity) {
            diagram.setName(umaActivity.getName());
        }
        Suppression suppression = new Suppression(proc);
        ActivityDiagram ad = ModelFactory.eINSTANCE.createActivityDiagram();
        ad.setSuppression(suppression);
        ad.setObject((Object)umaActivity);
        if (ad.isNew()) {
            return;
        }
        org.eclipse.epf.uma.Diagram umaDiagram = ad.getUMADiagram();
        if (umaDiagram != null && umaDiagram.getSuppressed().booleanValue()) {
            DiagramOptions.setPublishAD((org.eclipse.epf.uma.Activity)umaActivity, (boolean)false);
        }
        if ((diagramNodes = ad.getNodes()) == null) {
            return;
        }
        xmiResource.getContents().add((Object)activity);
        xmiResource.getContents().add((Object)diagram);
        ArrayList<MapNode> mapNodes = new ArrayList<MapNode>();
        HashMap<MapNode, org.eclipse.epf.diagram.model.Node> mapNodesMap = new HashMap<MapNode, org.eclipse.epf.diagram.model.Node>();
        for (Object e : diagramNodes) {
            if (!(e instanceof org.eclipse.epf.diagram.model.Node)) continue;
            if (e instanceof TypedNode && ((TypedNode)e).getType() == 6) {
                MapUtil.createText(diagram, (org.eclipse.epf.diagram.model.Node)e);
                continue;
            }
            MapNode mapNode = MapFactory.getInstance().create((org.eclipse.epf.diagram.model.Node)e);
            mapNode.setActivity((Activity)activity);
            mapNode.setDiagram(diagram);
            mapNode.updateResource();
            mapNodes.add(mapNode);
            mapNodesMap.put(mapNode, (org.eclipse.epf.diagram.model.Node)e);
        }
        for (Object e : mapNodes) {
            if (!(e instanceof MapNode)) continue;
            ((MapNode)e).outgoingConnections((org.eclipse.epf.diagram.model.Node)mapNodesMap.get((MapNode)e));
        }
        for (Object e : mapNodes) {
            if (!(e instanceof MapNode)) continue;
            ((MapNode)e).incomingConnections((org.eclipse.epf.diagram.model.Node)mapNodesMap.get((MapNode)e));
        }
    }

    private List getActivityDiagramData(Suppression sup, org.eclipse.epf.uma.Activity activity) {
        ActivityDiagram ad = ModelFactory.eINSTANCE.createActivityDiagram();
        ad.setSuppression(sup);
        ad.setObject((Object)activity);
        if (ad.isNew()) {
            return null;
        }
        return ad.getNodes();
    }

    private void addAD(Resource resource, Process proc, org.eclipse.epf.uma.Activity umaActivity, DiagramManager mgr) {
        this.addToResource(resource, proc, umaActivity, mgr, 0);
    }

    private void addADD(Resource resource, Process proc, org.eclipse.epf.uma.Activity umaActivity, DiagramManager mgr) {
        this.addToResource(resource, proc, umaActivity, mgr, 1);
    }

    private void addWPD(Resource resource, Process proc, org.eclipse.epf.uma.Activity umaActivity, DiagramManager mgr) {
        this.addToResource(resource, proc, umaActivity, mgr, 2);
    }

    private void addToResource(final Resource resource, final Process proc, final org.eclipse.epf.uma.Activity umaActivity, final DiagramManager mgr, final int type) {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                try {
                    InternalTransaction tx = mgr.getEditingDomain().startTransaction(false, Collections.EMPTY_MAP);
                    if (type == 0) {
                        WorkflowExportService.this.addDataToResource_AD(resource, proc, umaActivity);
                    } else if (type == 1) {
                        WorkflowExportService.this.addDataToResource_ADD(resource, proc, umaActivity);
                    } else if (type == 2) {
                        WorkflowExportService.this.addDataToResource_WPD(resource, proc, umaActivity);
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    tx.commit();
                }
                catch (Exception exception) {}
            }
        });
    }
}

