/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.addwpd.map;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.migration.diagram.ad.map.MapUtil;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class ConnectionFactory {
    private HashMap map = null;
    private Diagram diagram = null;
    private String kind;
    private static final int IMAGE_HEIGHT = 32;

    public ConnectionFactory(Diagram diagram, HashMap map, String kind) {
        this.map = map;
        this.diagram = diagram;
        this.kind = kind;
    }

    public void outgoingConnections(org.eclipse.epf.diagram.model.Node node) {
        EList connections = node.getOutgoingConnections();
        if (connections != null && connections.size() > 0) {
            for (Link link : connections) {
                Edge edge = this.createConnection(link);
                Node sourceNotationNode = (Node)this.map.get(node);
                sourceNotationNode.getSourceEdges().add((Object)edge);
                sourceNotationNode.getDiagram().insertEdge(edge);
            }
        }
    }

    public void incomingConnections(org.eclipse.epf.diagram.model.Node node) {
        EList connections = node.getIncomingConnections();
        if (connections != null && connections.size() > 0) {
            for (Link link : connections) {
                Edge edge = this.createConnection(link);
                Node sourceNotationNode = (Node)this.map.get(node);
                sourceNotationNode.getTargetEdges().add((Object)edge);
                sourceNotationNode.getDiagram().insertEdge(edge);
            }
        }
    }

    private Edge createConnection(Link link) {
        Node targetNotationNode;
        org.eclipse.epf.diagram.model.Node sourceObj = link.getSource();
        org.eclipse.epf.diagram.model.Node targetObj = link.getTarget();
        Node sourceNotationNode = (Node)this.map.get(sourceObj);
        Edge edge = this.findEdge(sourceNotationNode, targetNotationNode = (Node)this.map.get(targetObj));
        if (edge == null && targetNotationNode != null) {
            if (this.kind == "ADD") {
                edge = MapUtil.createEdge_WPD(sourceNotationNode, targetNotationNode, (EObject)link);
            } else if (this.kind == "WPDD") {
                edge = MapUtil.createEdge_WPD(sourceNotationNode, targetNotationNode, (EObject)link);
            }
            if (edge == null) {
                return null;
            }
            edge.setElement((EObject)link);
            this.loadSourceAndTargetEndPoint(edge, link);
            this.loadBendPoints(edge, link);
        }
        return edge;
    }

    private void loadSourceAndTargetEndPoint(Edge edge, Link flow) {
        IdentityAnchor anchor;
        Bounds bounds;
        Point srcPoint = flow.getSourceEndPoint();
        Point targetPoint = flow.getTargetEndPoint();
        View srcView = edge.getSource();
        View targetView = edge.getTarget();
        if (srcPoint != null && srcView instanceof Node) {
            bounds = (Bounds)((Node)srcView).getLayoutConstraint();
            if (bounds.getHeight() == -1) {
                bounds.setHeight(40);
            }
            if ((anchor = this.createIdentityAnchor(srcPoint, bounds)) != null) {
                edge.setSourceAnchor((Anchor)anchor);
            }
        }
        if (targetPoint != null && targetView instanceof Node) {
            bounds = (Bounds)((Node)targetView).getLayoutConstraint();
            if (bounds.getHeight() == -1) {
                bounds.setHeight(40);
            }
            if ((anchor = this.createIdentityAnchor(targetPoint, bounds)) != null) {
                edge.setTargetAnchor((Anchor)anchor);
            }
        }
    }

    private IdentityAnchor createIdentityAnchor(Point point, Bounds bounds) {
        PrecisionPoint prePoint = MapUtil.getAnchorRelativeLocation(point, bounds);
        String id = MapUtil.composeTerminalString(prePoint);
        IdentityAnchor value = NotationFactory.eINSTANCE.createIdentityAnchor();
        value.setId(id);
        return value;
    }

    private void loadBendPoints(Edge edge, Link flow) {
        EList list = flow.getBendpoints();
        ArrayList<RelativeBendpoint> relativePoints = new ArrayList<RelativeBendpoint>();
        RelativeBendpoint rbp = new RelativeBendpoint(0, 0, 0, 0);
        relativePoints.add(rbp);
        if (list != null && list.size() > 0) {
            for (AbsoluteBendpoint abp : list) {
                Node srcNode = (Node)edge.getSource();
                Node targetNode = (Node)edge.getTarget();
                Bounds sourceBounds = (Bounds)srcNode.getLayoutConstraint();
                Bounds targetBounds = (Bounds)targetNode.getLayoutConstraint();
                int srcLine = MapUtil.getNoOfLines(srcNode);
                int targetLine = MapUtil.getNoOfLines(targetNode);
                int srcHeight = MapUtil.getTextHeight(srcNode);
                int targetHeight = MapUtil.getTextHeight(targetNode);
                int srcX = sourceBounds.getX() + sourceBounds.getWidth() / 2;
                int srcY = sourceBounds.getY() + (32 + srcLine * srcHeight) / 2;
                int tarX = targetBounds.getX() + targetBounds.getWidth() / 2;
                int tarY = targetBounds.getY() + (32 + targetLine * targetHeight) / 2;
                int rel1 = abp.x - srcX;
                int rel2 = abp.y - srcY;
                int rel3 = abp.x - tarX;
                int rel4 = abp.y - tarY;
                RelativeBendpoint rbp1 = new RelativeBendpoint(rel1, rel2, rel3, rel4);
                relativePoints.add(rbp1);
            }
        }
        relativePoints.add(rbp);
        if (relativePoints.size() > 0) {
            RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
            bendpoints.setPoints(relativePoints);
            edge.setBendpoints((Bendpoints)bendpoints);
        }
    }

    private Edge findEdge(Node sourceNode, Node targetNode) {
        EList list = this.diagram.getEdges();
        if (list != null && list.size() > 0) {
            for (Edge edge : list) {
                if (edge.getTarget() == null || !targetNode.equals(edge.getTarget()) || edge.getSource() == null || !sourceNode.equals(edge.getSource())) continue;
                return edge;
            }
        }
        return null;
    }
}

