/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.add.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.DiagramPaletteFactory;
import org.eclipse.epf.ui.editors.IMethodEditor;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class ActivityDetailDiagramEditor
extends DiagramDocumentEditor
implements IGotoMarker,
IMethodEditor {
    public static final String ID = "org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorID";

    public ActivityDetailDiagramEditor() {
        super(true);
    }

    protected PaletteRoot createPaletteRoot(PaletteRoot existingPaletteRoot) {
        PaletteRoot root = super.createPaletteRoot(existingPaletteRoot);
        new DiagramPaletteFactory().fillPalette(root);
        return root;
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput || input instanceof URIEditorInput) {
            this.setDocumentProvider((IDocumentProvider)ActivityDetailDiagramEditorPlugin.getInstance().getDocumentProvider());
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block19: {
            IFile original;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            if (provider.isDeleted((Object)input) && original != null) {
                String message = NLS.bind((String)"The original file ''{0}'' has been deleted.", (Object)original.getName());
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            IEditorMatchingStrategy matchingStrategy = this.getEditorDescriptor().getEditorMatchingStrategy();
            IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                if (matchingStrategy.matches(editorRefs[i], (IEditorInput)newInput)) {
                    MessageDialog.openWarning((Shell)shell, (String)"Problem During Save As...", (String)"Save could not be completed. Target file is already open in another editor.");
                    return;
                }
                ++i;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    this.getDocumentProvider((IEditorInput)newInput).saveDocument(progressMonitor, (Object)newInput, this.getDocumentProvider().getDocument((Object)this.getEditorInput()), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        ErrorDialog.openError((Shell)shell, (String)"Save Problems", (String)"Could not save file.", (IStatus)x.getStatus());
                    }
                    provider.changed((Object)newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected PreferencesHint getPreferencesHint() {
        return new PreferencesHint("org.eclipse.epf.diagram.add");
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return null;
        }
        return super.getAdapter(type);
    }

    protected IDocumentProvider getDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput || input instanceof URIEditorInput) {
            return ActivityDetailDiagramEditorPlugin.getInstance().getDocumentProvider();
        }
        return super.getDocumentProvider(input);
    }

    public TransactionalEditingDomain getEditingDomain() {
        IDocument document;
        IDocument iDocument = document = this.getEditorInput() != null ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()) : null;
        if (document instanceof IDiagramDocument) {
            return ((IDiagramDocument)document).getEditingDomain();
        }
        return super.getEditingDomain();
    }
}

