/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi.internal.migration;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.epf.common.html.HTMLFormatter;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.library.xmi.XMILibraryResourceManager;
import org.eclipse.epf.uma.MethodElement;

public class MigrationUtil {
    public static Set<String> cdataFeatureNames = new HashSet<String>();
    private static boolean localDebug = false;

    static {
        cdataFeatureNames.add("alternatives");
        cdataFeatureNames.add("mainDescription");
        cdataFeatureNames.add("howToStaff");
        cdataFeatureNames.add("keyConsiderations");
        cdataFeatureNames.add("purpose");
        cdataFeatureNames.add("scope");
        cdataFeatureNames.add("usageNotes");
        cdataFeatureNames.add("skills");
        cdataFeatureNames.add("assignmentApproaches");
        cdataFeatureNames.add("synonyms");
        cdataFeatureNames.add("sectionDescription");
        cdataFeatureNames.add("impactOfNotHaving");
        cdataFeatureNames.add("reasonsForNotNeeding");
        cdataFeatureNames.add("briefOutline");
        cdataFeatureNames.add("representationOptions");
        cdataFeatureNames.add("usageGuidance");
        cdataFeatureNames.add("refinedDescription");
        cdataFeatureNames.add("activityEntryState");
        cdataFeatureNames.add("activityExitState");
        cdataFeatureNames.add("externalDescription");
        cdataFeatureNames.add("packagingGuidance");
        cdataFeatureNames.add("additionalInfo");
        cdataFeatureNames.add("problem");
        cdataFeatureNames.add("background");
        cdataFeatureNames.add("goals");
        cdataFeatureNames.add("application");
        cdataFeatureNames.add("levelsOfAdoption");
        cdataFeatureNames.add("scale");
        cdataFeatureNames.add("projectCharacteristics");
        cdataFeatureNames.add("riskLevel");
        cdataFeatureNames.add("estimatingTechnique");
        cdataFeatureNames.add("projectMemberExpertise");
        cdataFeatureNames.add("typeOfContract");
    }

    private static boolean isHtmlFeature(EStructuralFeature f) {
        return cdataFeatureNames.contains(f.getName());
    }

    public static void formatValue(MethodElement element) throws Exception {
        List properties = element.getInstanceProperties();
        if (properties != null) {
            HTMLFormatter formater = new HTMLFormatter();
            if (ResourceHelper.getDefaultResourceMgr() == null) {
                ResourceHelper.setDefaultResourceMgr((ILibraryResourceManager)new XMILibraryResourceManager());
            }
            boolean seen = false;
            int i = 0;
            while (i < properties.size()) {
                block10: {
                    EProperty property = (EProperty)properties.get(i);
                    if (property != null) {
                        Object value;
                        EStructuralFeature feature = property.getEStructuralFeature();
                        Object newValue = value = element.eGet(feature);
                        if (MigrationUtil.isHtmlFeature(feature) && value instanceof String) {
                            block9: {
                                if (!seen && localDebug) {
                                    System.out.println("LD> element: " + element.eClass().getName());
                                    seen = true;
                                }
                                try {
                                    String str0 = MigrationUtil.validateGuidAttribute((String)value);
                                    String str1 = ResourceHelper.validateContent((MethodElement)element, (String)str0);
                                    newValue = formater.formatHTML(str1);
                                    if (!localDebug) break block9;
                                    System.out.println("LD> feature: " + feature.getName());
                                    System.out.println("LD> str0: " + value);
                                    if (!str1.equals(str0)) {
                                        System.out.println("LD> str1: " + str1);
                                    }
                                    if (newValue.equals(str1)) break block9;
                                    System.out.println("LD> newValue: " + newValue);
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    break block10;
                                }
                            }
                            element.eSet(feature, newValue);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static String validateGuidAttribute(String source) {
        String str = MigrationUtil.validateGuidAttribute(source, ResourceHelper.p_link_ref);
        str = MigrationUtil.validateGuidAttribute(str, ResourceHelper.p_area_ref);
        return str;
    }

    private static String validateGuidAttribute(String source, Pattern pattern) {
        StringBuffer sb = new StringBuffer();
        Matcher m = pattern.matcher(source);
        while (m.find()) {
            String text;
            String replacement = text = m.group();
            Map attributeMap = ResourceHelper.getAttributesFromLink((Pattern)pattern, (String)text);
            if (localDebug) {
                System.out.println("LD> text:      " + text);
                System.out.println("LD> attributeMap: " + attributeMap);
            }
            String guid = attributeMap == null ? null : (String)attributeMap.get("guid");
            String href = attributeMap == null ? null : (String)attributeMap.get("href");
            int ix0 = -1;
            int ix1 = -1;
            if (guid == null && href != null) {
                ix0 = href.lastIndexOf(",");
                ix1 = href.lastIndexOf(".html");
            }
            if (ix0 >= 0 && ix1 > ix0) {
                guid = href.substring(ix0 + 1, ix1);
                String replaced = String.valueOf(href) + "\"";
                String replacing = String.valueOf(href) + "\" guid=\"" + guid + "\"";
                replacement = text.replace(replaced, replacing);
                if (localDebug) {
                    System.out.println("LD>  replaced: " + replaced);
                    System.out.println("LD> replacing: " + replacing);
                    System.out.println("");
                }
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

