/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.export.wizards.ExportPluginWizard;
import org.eclipse.epf.export.wizards.PluginInfoPage;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectPluginPage
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener,
Listener {
    public static final String PAGE_NAME = SelectPluginPage.class.getName();
    private Table table;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_author;
    private Text ctrl_version;
    private Text ctrl_briefDesc;
    private int checkedCount = 0;
    private Collection<MethodPlugin> checkedPluginList = new ArrayList<MethodPlugin>();
    private PluginExportData data;
    private Button selectAllButton;
    private Button deselectAllButton;

    public SelectPluginPage(PluginExportData data) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.selectPluginsPage_title);
        this.setDescription(ExportResources.selectPluginsPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/exp_meth_plugin_wizban.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        ArrayList<MethodPlugin> plugins;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Composite container1 = new Composite(container, 0);
        container1.setLayout((Layout)new GridLayout(3, false));
        SelectPluginPage.createLabel((Composite)container1, (String)ExportResources.selectPluginsPage_pluginsLabel_text);
        this.selectAllButton = SelectPluginPage.createButton((Composite)container1, (String)AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_SelectAllButtonLabel);
        this.deselectAllButton = SelectPluginPage.createButton((Composite)container1, (String)AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_DeselectAllButtonLabel);
        this.ctrl_chkboxTableViewer = SelectPluginPage.createCheckboxTableViewer((Composite)container, (int)1);
        this.table = this.ctrl_chkboxTableViewer.getTable();
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        ArrayList<Object> arrayList = plugins = library == null ? new ArrayList<MethodPlugin>() : new ArrayList(library.getMethodPlugins());
        if (plugins.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getComparator();
            Collections.sort(plugins, comparator);
        }
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodPlugin) {
                    return ((MethodPlugin)element).getName();
                }
                return element.toString();
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (plugins != null) {
            this.ctrl_chkboxTableViewer.setInput((Object)plugins.toArray());
        }
        SelectPluginPage.createLabel((Composite)container, (String)AuthoringUIText.AUTHORS_TEXT);
        this.ctrl_author = SelectPluginPage.createMultiLineText((Composite)container, (String)"", (int)360, (int)40, (int)3);
        SelectPluginPage.createLabel((Composite)container, (String)AuthoringUIText.VERSION_TEXT);
        this.ctrl_version = SelectPluginPage.createText((Composite)container, (String)"", (int)360, (int)3);
        SelectPluginPage.createLabel((Composite)container, (String)AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_briefDesc = SelectPluginPage.createMultiLineText((Composite)container, (String)"", (int)360, (int)80, (int)3);
        if (plugins != null && !plugins.isEmpty()) {
            this.table.select(0);
            this.setDisplayAttributes((MethodPlugin)plugins.get(0));
        }
        this.addListeners(plugins);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void addListeners(final List<MethodPlugin> plugins) {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
        final MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectPluginPage.this.ctrl_chkboxTableViewer.setAllChecked(true);
                if (lib != null) {
                    SelectPluginPage.this.checkedPluginList.clear();
                    SelectPluginPage.this.checkedPluginList.addAll(plugins);
                    SelectPluginPage.this.checkedCount = SelectPluginPage.this.checkedPluginList.size();
                }
                SelectPluginPage.this.setPageComplete(SelectPluginPage.this.isPageComplete());
                SelectPluginPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectPluginPage.this.ctrl_chkboxTableViewer.setAllChecked(false);
                if (lib != null) {
                    SelectPluginPage.this.checkedPluginList.clear();
                    SelectPluginPage.this.checkedCount = 0;
                }
                SelectPluginPage.this.setPageComplete(SelectPluginPage.this.isPageComplete());
                SelectPluginPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object obj = event.getElement();
        if (obj instanceof MethodPlugin) {
            if (event.getChecked()) {
                ++this.checkedCount;
                this.checkedPluginList.add((MethodPlugin)obj);
            } else {
                --this.checkedCount;
                this.checkedPluginList.remove(obj);
            }
            this.setPageComplete(this.isPageComplete());
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] plugin = selection.toArray();
            this.setDisplayAttributes((MethodPlugin)plugin[0]);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(MethodPlugin plugin) {
        this.ctrl_author.setText(plugin.getAuthors());
        this.ctrl_version.setText(plugin.getVersion());
        this.ctrl_briefDesc.setText(plugin.getBriefDescription());
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.checkedCount > 0;
    }

    protected void saveDataToModel() {
        this.data.setSelectedPlugins(this.checkedPluginList);
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        PluginInfoPage page = ((ExportPluginWizard)this.getWizard()).page2;
        page.onEnterPage(null);
        return page;
    }
}

