/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;

public class WorkBreakdownElementNodeAdapter
extends NodeAdapter {
    public WorkBreakdownElementNodeAdapter(MethodElement e) {
        super(e);
    }

    public void handleSuppressed(boolean b) {
        if (b) {
            EList incomings = this.getNode().getIncomings();
            int i = 0;
            while (i < incomings.size()) {
                Object obj = incomings.get(i);
                ActivityEdge link = null;
                if (obj != null) {
                    link = (ActivityEdge)obj;
                }
                if (link != null && link.getSource() != null) {
                    NodeAdapter sourceNodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getSource());
                    boolean oldNotify1 = sourceNodeAdapter != null ? sourceNodeAdapter.notificationEnabled : false;
                    try {
                        if (sourceNodeAdapter != null) {
                            sourceNodeAdapter.notificationEnabled = false;
                        }
                        link.setTarget(null);
                        this.getNode().getIncomings().remove((Object)link);
                    }
                    finally {
                        if (sourceNodeAdapter != null) {
                            sourceNodeAdapter.notificationEnabled = oldNotify1;
                        }
                    }
                }
                ++i;
            }
            EList outGoings = this.getNode().getOutgoings();
            int i2 = 0;
            while (i2 < outGoings.size()) {
                Object obj = outGoings.get(i2);
                ActivityEdge link = null;
                if (obj != null) {
                    link = (ActivityEdge)obj;
                }
                if (link != null && link.getTarget() != null) {
                    NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getTarget());
                    boolean oldNotify1 = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
                    try {
                        if (nodeAdapter != null) {
                            nodeAdapter.notificationEnabled = false;
                        }
                        link.setSource(null);
                        this.getNode().getIncomings().remove((Object)link);
                    }
                    finally {
                        if (nodeAdapter != null) {
                            nodeAdapter.notificationEnabled = oldNotify1;
                        }
                    }
                }
                ++i2;
            }
        } else {
            EList nodes = this.getDiagram().getNodes();
            for (ActivityNode element : nodes) {
                MethodElement me;
                if (element == this.getNode() || !(this.target instanceof MethodElement) || (me = BridgeHelper.getMethodElement((EModelElement)element)) == null) continue;
                this.addIncomingConnection(me);
                this.addOutgoingConnection(me);
            }
        }
    }

    protected NodeAdapter.MethodElementAdapter createMethodElementAdapter() {
        return new WorkBreakdownElementAdapter();
    }

    protected boolean addToUMA(ActivityEdge link) {
        if (!super.addToUMA(link)) {
            return false;
        }
        MethodElement e = BridgeHelper.getMethodElement((EModelElement)link.getSource());
        if (e instanceof WorkBreakdownElement) {
            WorkBreakdownElement pred;
            WorkOrder order = null;
            WorkBreakdownElement succ = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)link.getTarget());
            if (UmaUtil.findWorkOrder((WorkBreakdownElement)succ, (Object)(pred = (WorkBreakdownElement)e)) == null) {
                NodeAdapter sourceNodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getSource());
                boolean sourceNotify = sourceNodeAdapter != null ? sourceNodeAdapter.notificationEnabled : false;
                try {
                    if (sourceNodeAdapter != null) {
                        sourceNodeAdapter.notificationEnabled = false;
                    }
                    order = this.addDefaultWorkOrder(link.getTarget(), pred);
                }
                finally {
                    if (sourceNodeAdapter != null) {
                        sourceNodeAdapter.notificationEnabled = sourceNotify;
                    }
                }
            }
            BridgeHelper.setSemanticModel(link, order);
        } else if (BridgeHelper.isSynchBar(link.getSource())) {
            ArrayList actNodes = new ArrayList();
            BridgeHelper.getSyncBarSourceNodes(link.getSource(), actNodes);
            WorkBreakdownElement succ = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)link.getTarget());
            for (ActivityNode node : actNodes) {
                WorkBreakdownElement pred = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)node);
                if (UmaUtil.findWorkOrder((WorkBreakdownElement)succ, (Object)pred) != null) continue;
                NodeAdapter sourceNode = BridgeHelper.getNodeAdapter((EObject)node);
                boolean sourceNotify = sourceNode.notificationEnabled;
                try {
                    sourceNode.notificationEnabled = false;
                    this.addDefaultWorkOrder(link.getTarget(), pred);
                }
                finally {
                    sourceNode.notificationEnabled = sourceNotify;
                }
            }
        }
        return true;
    }

    protected ActivityEdge addIncomingConnection(MethodElement source) {
        ActivityEdge link = super.addIncomingConnection(source);
        if (link == null) {
            return link;
        }
        WorkOrder workOrder = UmaUtil.findWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)this.getElement()), (Object)source);
        BridgeHelper.setSemanticModel(link, workOrder);
        return link;
    }

    protected ActivityEdge addOutgoingConnection(MethodElement target) {
        ActivityEdge link = super.addOutgoingConnection(target);
        WorkOrder workOrder = UmaUtil.findWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)target), (Object)this.getElement());
        BridgeHelper.setSemanticModel(link, workOrder);
        return link;
    }

    protected boolean removeIncomingConnection(MethodElement source) {
        for (ActivityEdge link : this.getNode().getIncomings()) {
            if (link.getSource() == null || BridgeHelper.getMethodElement((EModelElement)link.getSource()) != source) continue;
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getSource());
            boolean oldNotify = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
            try {
                if (nodeAdapter != null) {
                    nodeAdapter.notificationEnabled = false;
                }
                link.setSource(null);
            }
            finally {
                if (nodeAdapter != null) {
                    nodeAdapter.notificationEnabled = oldNotify;
                }
            }
            link.setTarget(null);
            BridgeHelper.setSemanticModel(link, null);
            this.getDiagram().getEdges().remove((Object)link);
            return true;
        }
        return false;
    }

    private class WorkBreakdownElementAdapter
    extends NodeAdapter.MethodElementAdapter {
        private WorkBreakdownElementAdapter() {
        }

        protected Collection handleNotification(Notification msg) {
            block0 : switch (msg.getFeatureID(WorkBreakdownElement.class)) {
                case 34: {
                    switch (msg.getEventType()) {
                        case 3: {
                            WorkOrder obj = (WorkOrder)msg.getNewValue();
                            WorkBreakdownElementNodeAdapter.this.addIncomingConnection((MethodElement)obj.getPred());
                            break;
                        }
                        case 4: {
                            WorkOrder obj = (WorkOrder)msg.getOldValue();
                            WorkBreakdownElementNodeAdapter.this.removeIncomingConnection((MethodElement)obj.getPred());
                            break;
                        }
                        case 5: {
                            Collection collection = (Collection)msg.getNewValue();
                            for (WorkOrder obj : collection) {
                                WorkBreakdownElementNodeAdapter.this.addIncomingConnection((MethodElement)obj.getPred());
                            }
                            break block0;
                        }
                        case 6: {
                            Collection collection = (Collection)msg.getOldValue();
                            for (WorkOrder obj : collection) {
                                WorkBreakdownElementNodeAdapter.this.removeIncomingConnection((MethodElement)obj.getPred());
                            }
                        }
                    }
                    break;
                }
                case 7: {
                    switch (msg.getEventType()) {
                        default: 
                    }
                    break;
                }
                default: {
                    return super.handleNotification(msg);
                }
            }
            return Collections.EMPTY_LIST;
        }
    }
}

