/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.providers.IDiagramIconProvider;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class DiagramIconProviderManager {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.diagram.core";
    public static final String EXTENSION_POINT_NAME = "diagramIconProviders";
    public static final String CLASS_ATTRIB_NAME = "class";
    private static DiagramIconProviderManager myself;
    private ArrayList<IDiagramIconProvider> providers;

    private DiagramIconProviderManager() {
    }

    public static DiagramIconProviderManager getInstance() {
        if (myself == null) {
            myself = new DiagramIconProviderManager();
        }
        return myself;
    }

    public Image getIcon(EObject element, boolean smallIcon) {
        Image image;
        block5: {
            block6: {
                block4: {
                    image = null;
                    if (this.providers == null) {
                        this.loadProviders();
                    }
                    if (!(element instanceof ObjectNode)) break block4;
                    EAnnotation eAnnotation = ((ObjectNode)element).getEAnnotation("uma_element");
                    String modelUri = (String)eAnnotation.getDetails().get((Object)"uri");
                    String guid = modelUri.substring(modelUri.indexOf(35) + 1);
                    MethodElement me = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(guid);
                    int index = 0;
                    while (index < this.providers.size() && image == null) {
                        IDiagramIconProvider iProvider = this.providers.get(index);
                        image = iProvider.getImageForElement(me, smallIcon);
                        ++index;
                    }
                    break block5;
                }
                if (!(element instanceof StructuredActivityNode)) break block6;
                StructuredActivityNode san = (StructuredActivityNode)element;
                EAnnotation eAnnotation = san.getEAnnotation("uma_element");
                String modelUri = (String)eAnnotation.getDetails().get((Object)"uri");
                String guid = modelUri.substring(modelUri.indexOf(35) + 1);
                MethodElement me = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(guid);
                int index = 0;
                while (index < this.providers.size() && image == null) {
                    IDiagramIconProvider iProvider = this.providers.get(index);
                    image = iProvider.getImageForElement(me, smallIcon);
                    ++index;
                }
                break block5;
            }
            if (!(element instanceof NamedNodeImpl)) break block5;
            NamedNode wpn = (NamedNode)element;
            MethodElement me = wpn.getLinkedElement();
            int index = 0;
            while (index < this.providers.size() && image == null) {
                IDiagramIconProvider iProvider = this.providers.get(index);
                image = iProvider.getImageForElement(me, smallIcon);
                ++index;
            }
        }
        return image;
    }

    private void loadProviders() {
        this.providers = new ArrayList();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        this.providers.add((IDiagramIconProvider)configElement.createExecutableExtension(CLASS_ATTRIB_NAME));
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

