/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.providers.AccessibleDiagramModificationListener;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.FileSynchronizer;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.internal.IFailSafeSavable;
import org.eclipse.epf.library.persistence.util.ExtendedResourceSet;
import org.eclipse.epf.library.persistence.util.FileSynchronizer;
import org.eclipse.epf.persistence.FailSafePersistenceHelper;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil;
import org.eclipse.gmf.runtime.emf.core.resources.GMFHelper;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramManager {
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();
    private static final String DIAGRAM_FILENAME_WITHOUT_EXTENSION = "diagram";
    private static final String DIAGRAM_FILENAME = "diagram.xmi";
    private static final Map<Process, DiagramManager> processToDiagramManagerMap = new HashMap<Process, DiagramManager>();
    private static ILibraryServiceListener libSvcListener;
    private static final FileSynchronizer fileSynchronizer;
    public static final String ADD_kind = "ADD";
    public static final String AD_kind = "AD";
    public static final String WPD_kind = "WPDD";
    private Process process;
    private Resource resource;
    private InternalTransactionalEditingDomain editingDomain;
    private IProgressMonitor monitor;
    private boolean resourceIsNew;
    private List<IResourceChangeListener> resourceChangeListeners = new UniqueEList();
    private ExtendedResourceSet resourceSet;
    private HashMap<org.eclipse.epf.uma.Activity, Map<String, Diagram>> activityToSavedDiagramMap;
    protected UniqueEList<Object> consumers = new UniqueEList();

    static {
        fileSynchronizer = new FileSynchronizer(){

            protected Collection<IFile> handleChangedFiles(Collection<IFile> changedFiles) {
                try {
                    Collection<DiagramManager> mgrs = DiagramManager.getDiagramManagers();
                    if (!mgrs.isEmpty()) {
                        ArrayList<IFile> handledFiles = new ArrayList<IFile>();
                        for (DiagramManager mgr : mgrs) {
                            IFile file;
                            Resource resource = mgr.getResource(false);
                            if (resource == null || !resource.isLoaded() || !changedFiles.contains(file = WorkspaceSynchronizer.getFile((Resource)mgr.getResource()))) continue;
                            try {
                                mgr.reload();
                                handledFiles.add(file);
                            }
                            catch (IOException e) {
                                CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                                if (!DEBUG) continue;
                                e.printStackTrace();
                            }
                        }
                        return handledFiles;
                    }
                }
                catch (CoreException e) {
                    this.handleCoreException(e, e.getMessage());
                }
                return Collections.emptyList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Collection<IFile> handleMovedFiles(Map<IFile, IPath> movedFileToNewPathMap) {
                for (Map.Entry<IFile, IPath> entry : movedFileToNewPathMap.entrySet()) {
                    IFile iFile = entry.getKey();
                    if (!DiagramManager.DIAGRAM_FILENAME.equals(iFile.getName())) continue;
                    Map map = processToDiagramManagerMap;
                    synchronized (map) {
                        DiagramManager mgr = DiagramManager.getDiagramManager(iFile);
                        if (mgr != null) {
                            mgr.updateResourceURI();
                        }
                    }
                }
                return movedFileToNewPathMap.keySet();
            }

            protected Collection<IFile> handleDeletedFiles(Collection<IFile> deletedFiles) {
                return super.handleDeletedFiles(deletedFiles);
            }
        };
    }

    private static DiagramManager getDiagramManager(IFile iFile) {
        for (DiagramManager mgr : processToDiagramManagerMap.values()) {
            if (mgr.resource == null || !iFile.equals((Object)WorkspaceSynchronizer.getFile((Resource)mgr.resource))) continue;
            return mgr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeDiagramManagers(MethodLibrary library) {
        Map<Process, DiagramManager> map = processToDiagramManagerMap;
        synchronized (map) {
            Iterator<Map.Entry<Process, DiagramManager>> iterator = processToDiagramManagerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Process, DiagramManager> entry = iterator.next();
                if (UmaUtil.getMethodLibrary((EObject)((EObject)entry.getKey())) != library) continue;
                entry.getValue().doDispose();
                iterator.remove();
            }
        }
    }

    private static synchronized void setupLibraryServiceListener() {
        if (libSvcListener == null) {
            libSvcListener = new LibraryServiceListener(){

                public void libraryClosed(MethodLibrary library) {
                    DiagramManager.disposeDiagramManagers(library);
                }

                public void libraryReopened(MethodLibrary library) {
                    DiagramManager.disposeDiagramManagers(library);
                }
            };
            LibraryService.getInstance().addListener(libSvcListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DiagramManager getInstance(Process process, Object consumer) {
        if (DEBUG && process.eIsProxy()) {
            System.err.println("Process is a proxy: " + process);
        }
        assert (process != null && consumer != null && !process.eIsProxy());
        DiagramManager.setupLibraryServiceListener();
        DiagramManager mgr = processToDiagramManagerMap.get(process);
        if (mgr != null && mgr.isDisposed()) {
            processToDiagramManagerMap.remove(process);
            mgr = null;
        }
        if (mgr == null) {
            Map<Process, DiagramManager> map = processToDiagramManagerMap;
            synchronized (map) {
                mgr = processToDiagramManagerMap.get(process);
                if (mgr == null) {
                    mgr = new DiagramManager(process);
                    processToDiagramManagerMap.put(process, mgr);
                    if (!fileSynchronizer.isInstalled()) {
                        fileSynchronizer.install();
                    }
                }
            }
        }
        mgr.addConsumer(consumer);
        return mgr;
    }

    public static final boolean hasDiagramManager(Process process) {
        return processToDiagramManagerMap.containsKey(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean disposeDiagramManager(Process process) {
        Map<Process, DiagramManager> map = processToDiagramManagerMap;
        synchronized (map) {
            block4: {
                DiagramManager mgr = processToDiagramManagerMap.get(process);
                if (mgr == null) break block4;
                mgr.doDispose();
                processToDiagramManagerMap.remove(process);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<DiagramManager> getDiagramManagers() {
        ArrayList<DiagramManager> mgrs;
        Map<Process, DiagramManager> map = processToDiagramManagerMap;
        synchronized (map) {
            mgrs = new ArrayList<DiagramManager>(processToDiagramManagerMap.values());
        }
        return mgrs.isEmpty() ? Collections.EMPTY_LIST : mgrs;
    }

    private DiagramManager(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        if (!this.resourceChangeListeners.contains(listener)) {
            this.resourceChangeListeners.add(listener);
        }
    }

    public void removeResourceChangeListener(IResourceChangeListener listener) {
        this.resourceChangeListeners.remove(listener);
    }

    public synchronized boolean addConsumer(Object consumer) {
        return this.consumers.add(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeConsumer(Object consumer) {
        boolean ret = this.consumers.remove(consumer);
        if (ret && this.consumers.isEmpty()) {
            Map<Process, DiagramManager> map = processToDiagramManagerMap;
            synchronized (map) {
                processToDiagramManagerMap.remove(this.process);
                if (processToDiagramManagerMap.isEmpty()) {
                    fileSynchronizer.uninstall();
                }
            }
            this.doDispose();
        }
        return ret;
    }

    public boolean isNewResource() {
        return this.resourceIsNew;
    }

    public void setResourceIsNew(boolean resourceIsNew) {
        this.resourceIsNew = resourceIsNew;
    }

    public InternalTransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null && !this.isDisposed()) {
            this.editingDomain = this.createEditingDomain();
            this.resourceSet = (ExtendedResourceSet)this.editingDomain.getResourceSet();
        }
        return this.editingDomain;
    }

    private InternalTransactionalEditingDomain createEditingDomain() {
        GMFExtendedResourceSet resourceSet = new GMFExtendedResourceSet();
        resourceSet.add(this.process.eResource().getResourceSet());
        return (InternalTransactionalEditingDomain)DiagramEditingDomainFactory.getInstance().createEditingDomain((ResourceSet)resourceSet);
    }

    private void doDispose() {
        if (this.resource != null) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)this.resource);
            if (file != null) {
                fileSynchronizer.unmonitor(file);
            }
            this.resource = null;
        }
        this.resourceChangeListeners.clear();
        if (this.editingDomain != null) {
            this.resourceSet.dispose();
            this.resourceSet = null;
            this.editingDomain.dispose();
            this.editingDomain = null;
        }
        this.consumers.clear();
        if (this.activityToSavedDiagramMap != null) {
            this.activityToSavedDiagramMap.clear();
        }
        this.process = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<Process, DiagramManager> map = processToDiagramManagerMap;
        synchronized (map) {
            processToDiagramManagerMap.remove(this.process);
        }
        this.doDispose();
    }

    public boolean isDisposed() {
        return this.process == null;
    }

    public List<Diagram> getDiagrams(org.eclipse.epf.uma.Activity act, int type) throws CoreException {
        this.checkActivity(act);
        Resource resource = this.getResource(false);
        if (resource != null) {
            ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
            for (EObject o : resource.getContents()) {
                if (!(o instanceof Diagram)) continue;
                Diagram diagram = (Diagram)o;
                String typeStr = DiagramManager.getDiagramTypeString(type);
                if (!typeStr.equals(diagram.getType()) || !DiagramManager.isDiagramOf(diagram, act)) continue;
                EObject model = diagram.getElement();
                if (model instanceof DiagramImpl) {
                    ((DiagramImpl)model).setGraphicalDataRequired(false);
                }
                diagrams.add(diagram);
            }
            if (!diagrams.isEmpty()) {
                return diagrams;
            }
        }
        return Collections.emptyList();
    }

    private static void markInherited(Diagram diagram) {
        EList children = diagram.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            View view = (View)children.get(i);
            BridgeHelper.markInherited((EModelElement)view);
            ++i;
        }
        for (Object edge : diagram.getEdges()) {
            BridgeHelper.markInherited((EModelElement)((View)edge));
        }
    }

    private static String getDiagramTypeString(int diagramType) {
        switch (diagramType) {
            case 2: {
                return ADD_kind;
            }
            case 0: {
                return AD_kind;
            }
            case 1: {
                return WPD_kind;
            }
        }
        return null;
    }

    public static int getDiagramType(String typeStr) {
        if (AD_kind.equals(typeStr)) {
            return 0;
        }
        if (ADD_kind.equals(typeStr)) {
            return 2;
        }
        if (WPD_kind.equals(typeStr)) {
            return 1;
        }
        return -1;
    }

    public void associate(Diagram newDiagram, int type, org.eclipse.epf.uma.Activity activity) throws CoreException {
        switch (type) {
            case 0: {
                this.associateAD(newDiagram, activity);
                return;
            }
            case 2: {
                this.associateADD(newDiagram, activity);
                return;
            }
            case 1: {
                this.associateWPD(newDiagram, activity);
            }
        }
    }

    private void associateWPD(Diagram copy, org.eclipse.epf.uma.Activity activity) throws CoreException {
        if (copy.getElement() instanceof WorkProductDependencyDiagram) {
            ((WorkProductDependencyDiagram)copy.getElement()).setLinkedElement((MethodElement)activity);
            ((DiagramImpl)copy.getElement()).setGraphicalDataRequired(false);
        }
        this.getResource().getContents().add((Object)copy.getElement());
        this.getResource().getContents().add((Object)copy);
    }

    private void associateAD(Diagram copy, org.eclipse.epf.uma.Activity act) throws CoreException {
        if (copy.getElement() instanceof EModelElement) {
            BridgeHelper.associate((EModelElement)copy.getElement(), (MethodElement)act);
        }
        this.getResource().getContents().add((Object)copy.getElement());
        this.getResource().getContents().add((Object)copy);
    }

    private void associateADD(Diagram copy, org.eclipse.epf.uma.Activity activity) throws CoreException {
        if (copy.getElement() instanceof ActivityDetailDiagram) {
            ((ActivityDetailDiagram)copy.getElement()).setLinkedElement((MethodElement)activity);
            ((DiagramImpl)copy.getElement()).setGraphicalDataRequired(false);
        }
        this.getResource().getContents().add((Object)copy.getElement());
        this.getResource().getContents().add((Object)copy);
    }

    private Diagram copyDiagram(Diagram diagram, org.eclipse.epf.uma.Activity targetActivity) {
        Diagram copy = DiagramHelper.copyDiagram((EditingDomain)this.getEditingDomain(), diagram);
        DiagramHelper.reassociate(targetActivity, copy);
        return copy;
    }

    public Diagram createDiagram(final org.eclipse.epf.uma.Activity act, final int type, final PreferencesHint hint) throws CoreException {
        Diagram[] resultHolder;
        block11: {
            this.checkActivity(act);
            if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)act)) {
                org.eclipse.epf.uma.Activity baseAct = (org.eclipse.epf.uma.Activity)act.getVariabilityBasedOnElement();
                DiagramManager mgr = DiagramManager.getInstance(TngUtil.getOwningProcess((BreakdownElement)baseAct), this);
                try {
                    Diagram baseDiagram;
                    List<Diagram> baseDiagrams = mgr.getDiagrams(baseAct, type);
                    if (!baseDiagrams.isEmpty() && (baseDiagram = baseDiagrams.get(0)) != null) {
                        final Diagram copy = this.copyDiagram(baseDiagram, act);
                        TxUtil.runInTransaction((TransactionalEditingDomain)this.getEditingDomain(), (Runnable)new Runnable(){

                            public void run() {
                                DiagramManager.markInherited(copy);
                                try {
                                    DiagramManager.this.associate(copy, type, act);
                                }
                                catch (CoreException e) {
                                    throw new WrappedException((Exception)((Object)e));
                                }
                            }
                        });
                        Diagram diagram = copy;
                        return diagram;
                    }
                }
                catch (Exception e) {
                    CommonPlugin.getDefault().getLogger().logError("Error in retrieving base diagram: ", (Throwable)e);
                }
                finally {
                    if (mgr != null) {
                        mgr.removeConsumer(this);
                    }
                }
            }
            resultHolder = new Diagram[1];
            try {
                TxUtil.runInTransaction((TransactionalEditingDomain)this.getEditingDomain(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            resultHolder[0] = DiagramManager.this.doCreateDiagram(act, type, hint);
                        }
                        catch (CoreException e) {
                            throw new WrappedException((Exception)((Object)e));
                        }
                    }
                });
            }
            catch (Exception e) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                if (!DEBUG) break block11;
                e.printStackTrace();
            }
        }
        return resultHolder[0];
    }

    private Diagram doCreateDiagram(org.eclipse.epf.uma.Activity act, int type, PreferencesHint hint) throws CoreException {
        switch (type) {
            case 0: {
                return this.createAD(act, hint);
            }
            case 2: {
                return this.createADD(act, hint);
            }
            case 1: {
                return this.createWPDD(act, hint);
            }
        }
        return null;
    }

    private Diagram createWPDD(org.eclipse.epf.uma.Activity act, PreferencesHint hint) throws CoreException {
        WorkProductDependencyDiagram model = ModelFactory.eINSTANCE.createWorkProductDependencyDiagram();
        if (model instanceof DiagramImpl) {
            ((DiagramImpl)model).setGraphicalDataRequired(false);
        }
        model.setNew(true);
        Diagram diagram = ViewService.createDiagram((EObject)model, (String)DiagramManager.getDiagramTypeString(1), (PreferencesHint)hint);
        if (diagram != null) {
            diagram.setName(act.getName());
            model.setLinkedElement((MethodElement)act);
            this.getResource().getContents().add((Object)model);
            this.getResource().getContents().add((Object)diagram);
        }
        return diagram;
    }

    private Diagram createADD(org.eclipse.epf.uma.Activity act, PreferencesHint hint) throws CoreException {
        ActivityDetailDiagram model = ModelFactory.eINSTANCE.createActivityDetailDiagram();
        if (model instanceof DiagramImpl) {
            ((DiagramImpl)model).setGraphicalDataRequired(false);
        }
        model.setNew(true);
        Diagram diagram = ViewService.createDiagram((EObject)model, (String)DiagramManager.getDiagramTypeString(2), (PreferencesHint)hint);
        if (diagram != null) {
            model.setLinkedElement((MethodElement)act);
            diagram.setName(act.getName());
            this.getResource().getContents().add((Object)model);
            this.getResource().getContents().add((Object)diagram);
        }
        return diagram;
    }

    private Diagram createAD(org.eclipse.epf.uma.Activity act, PreferencesHint hint) throws CoreException {
        Activity model = UMLFactory.eINSTANCE.createActivity();
        Diagram diagram = ViewService.createDiagram((EObject)model, (String)DiagramManager.getDiagramTypeString(0), (PreferencesHint)hint);
        if (diagram != null) {
            BridgeHelper.associate((EModelElement)model, (MethodElement)act);
            diagram.setName(act.getName());
            model.setName(act.getName());
            this.getResource().getContents().add((Object)model);
            this.getResource().getContents().add((Object)diagram);
        }
        return diagram;
    }

    private IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public static String getDiagramFilePath(Process process) {
        ProcessComponent procComp;
        block4: {
            try {
                procComp = (ProcessComponent)process.eContainer();
                if (procComp != null) break block4;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (UmaUtil.hasDirectResource((EObject)procComp)) {
            return new File(new File(FileManager.toFileString((URI)process.eResource().getURI())).getParentFile(), DIAGRAM_FILENAME).getCanonicalPath();
        }
        URI uri = MultiFileSaveUtil.createURI((MethodElement)procComp, (ResourceSet)procComp.eResource().getResourceSet());
        return new File(new File(uri.toFileString()).getParentFile(), DIAGRAM_FILENAME).getCanonicalPath();
    }

    public void reload() throws IOException {
        if (this.resource == null) {
            return;
        }
        this.resource.unload();
        this.resource.load(Collections.EMPTY_MAP);
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.resource);
        fileSynchronizer.updateModificationStamp(file);
        this.notifyReloaded();
    }

    public Resource getResource() throws CoreException {
        if (this.resource == null) {
            this.resource = this.getResource(true);
        }
        return this.resource;
    }

    private static URI createDiagramResourceURI(String path) {
        IFile diagramFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
        return URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString());
    }

    private static Resource loadDiagramResource(IFile fFile, EditingDomain domain, Map loadOptions, IProgressMonitor monitor) throws CoreException, IOException {
        fFile.refreshLocal(0, monitor);
        URI uri = URI.createPlatformResourceURI((String)fFile.getFullPath().toString(), (boolean)true);
        Resource resource = domain.getResourceSet().getResource(uri, false);
        if (resource == null) {
            resource = domain.getResourceSet().createResource(uri);
        }
        if (!resource.isLoaded()) {
            HashMap loadingOptions = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
            for (Object key : loadOptions.keySet()) {
                loadingOptions.put(key, loadOptions.get(key));
            }
            try {
                resource.load(loadingOptions);
            }
            catch (IOException e) {
                resource.unload();
                throw e;
            }
        }
        return resource;
    }

    private Resource getResource(boolean create) throws CoreException {
        block17: {
            if (this.resource == null) {
                String path = DiagramManager.getDiagramFilePath(this.process);
                if (path != null) {
                    IResource wsRes = FileManager.getResourceForLocation((String)path);
                    if (wsRes instanceof IFile) {
                        IFile file = (IFile)wsRes;
                        try {
                            Diagram diagram = DiagramIOUtil.load((TransactionalEditingDomain)this.getEditingDomain(), (IFile)file, (boolean)true, (IProgressMonitor)this.getMonitor());
                            this.resource = diagram.eResource();
                        }
                        catch (CoreException e) {
                            if (org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages.Diagram_NO_DIAGRAM_IN_RESOURCE.equals(e.getMessage())) {
                                try {
                                    this.resource = DiagramManager.loadDiagramResource(file, (EditingDomain)this.getEditingDomain(), Collections.EMPTY_MAP, this.getMonitor());
                                }
                                catch (IOException e1) {
                                    if (DEBUG) {
                                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                                    }
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.core", e1.getMessage(), (Throwable)e1));
                                }
                            }
                            throw e;
                        }
                        fileSynchronizer.monitor(file);
                    } else if (create) {
                        this.resource = this.getEditingDomain().getResourceSet().createResource(DiagramManager.createDiagramResourceURI(path));
                        this.resourceIsNew = true;
                        try {
                            TxUtil.runInTransaction((TransactionalEditingDomain)this.getEditingDomain(), (Runnable)new Runnable(){

                                public void run() {
                                    DiagramManager.this.resource.getContents().clear();
                                }
                            });
                        }
                        catch (Exception e) {
                            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                    }
                }
            } else if (!this.resource.isLoaded()) {
                try {
                    this.resource.load(Collections.EMPTY_MAP);
                    this.notifyReloaded();
                }
                catch (IOException e) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                    if (!DEBUG) break block17;
                    e.printStackTrace();
                }
            }
        }
        return this.resource;
    }

    private void notifyReloaded() {
        for (IResourceChangeListener listener : this.resourceChangeListeners) {
            try {
                listener.resourceChanged((IResourceChangeEvent)new ResourceChangeEvent((Object)this, 1, 0, null));
            }
            catch (Exception e) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                if (!DEBUG) continue;
                e.printStackTrace();
            }
        }
    }

    private void checkActivity(org.eclipse.epf.uma.Activity act) {
        Process proc = TngUtil.getOwningProcess((BreakdownElement)act);
        if (proc != this.process) {
            throw new IllegalArgumentException("The specified activity does not belong to the process of this diagram manager.");
        }
    }

    private static boolean isDiagramOf(Diagram diagram, org.eclipse.epf.uma.Activity act) {
        if (AD_kind.equals(diagram.getType())) {
            return BridgeHelper.getMethodElementFromAnnotation((EModelElement)diagram.getElement(), act.eResource().getResourceSet()) == act;
        }
        if (ADD_kind.equals(diagram.getType())) {
            EObject model = diagram.getElement();
            return model instanceof ActivityDetailDiagram && ((ActivityDetailDiagram)model).getLinkedElement() == act;
        }
        if (WPD_kind.equals(diagram.getType())) {
            EObject model = diagram.getElement();
            return model instanceof WorkProductDependencyDiagram && ((WorkProductDependencyDiagram)model).getLinkedElement() == act;
        }
        return false;
    }

    public static void checkSynchronizationState(Resource resource) throws CoreException {
        if (!DiagramManager.isSynchronized(resource)) {
            Status status = new Status(4, "org.eclipse.ui", 274, EditorMessages.FileDocumentProvider_error_out_of_sync, null);
            throw new CoreException((IStatus)status);
        }
    }

    public static boolean isSynchronized(Resource resource) {
        FileSynchronizer.FileInfo info;
        if (resource == null) {
            return false;
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null && (info = fileSynchronizer.getFileInfo(file)) != null) {
            return info.fModificationStamp == FileSynchronizer.computeModificationStamp((IResource)file);
        }
        return true;
    }

    private Map<org.eclipse.epf.uma.Activity, Map<String, Diagram>> getActivityToSavedDiagramsMap() {
        if (this.activityToSavedDiagramMap == null) {
            this.activityToSavedDiagramMap = new HashMap();
        }
        return this.activityToSavedDiagramMap;
    }

    private Diagram getDiagramBackup(org.eclipse.epf.uma.Activity act, String type) {
        Map<String, Diagram> typeToDiagamMap;
        if (this.activityToSavedDiagramMap != null && (typeToDiagamMap = this.activityToSavedDiagramMap.get(act)) != null) {
            return typeToDiagamMap.get(type);
        }
        return null;
    }

    public void replaceTemporarily(final org.eclipse.epf.uma.Activity act, final Diagram diagram) {
        try {
            new AbstractEMFOperation((TransactionalEditingDomain)this.getEditingDomain(), ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    try {
                        List<Diagram> diagrams = DiagramManager.this.getDiagrams(act, DiagramManager.getDiagramType(diagram.getType()));
                        if (!diagrams.isEmpty()) {
                            Diagram savedDiagram = diagrams.get(0);
                            HashMap<String, Diagram> typeToDiagamMap = (HashMap<String, Diagram>)DiagramManager.this.getActivityToSavedDiagramsMap().get(act);
                            if (typeToDiagamMap == null) {
                                typeToDiagamMap = new HashMap<String, Diagram>();
                                DiagramManager.this.getActivityToSavedDiagramsMap().put(act, typeToDiagamMap);
                            }
                            if (typeToDiagamMap.get(diagram.getType()) == null) {
                                typeToDiagamMap.put(diagram.getType(), savedDiagram);
                            }
                            ((InternalEObject)diagram).eSetProxyURI(null);
                            TreeIterator iter = diagram.eAllContents();
                            while (iter.hasNext()) {
                                ((InternalEObject)iter.next()).eSetProxyURI(null);
                            }
                            ((InternalEObject)diagram.getElement()).eSetProxyURI(null);
                            iter = diagram.getElement().eAllContents();
                            while (iter.hasNext()) {
                                ((InternalEObject)iter.next()).eSetProxyURI(null);
                            }
                            DiagramManager.this.resource.getContents().set(DiagramManager.this.resource.getContents().indexOf((Object)savedDiagram), (Object)diagram);
                            DiagramManager.this.resource.getContents().set(DiagramManager.this.resource.getContents().indexOf((Object)savedDiagram.getElement()), (Object)diagram.getElement());
                        } else {
                            DiagramManager.this.resource.getContents().add((Object)diagram.getElement());
                            DiagramManager.this.resource.getContents().add((Object)diagram);
                        }
                    }
                    catch (CoreException e) {
                        CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e1) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)e1);
        }
    }

    private Diagram getSavedDiagram(org.eclipse.epf.uma.Activity act, Diagram diagram) {
        Diagram savedDiagram = this.getDiagramBackup(act, diagram.getType());
        return savedDiagram;
    }

    public synchronized boolean reverseToSaved(final org.eclipse.epf.uma.Activity act, final Diagram diagram, PreferencesHint hint) {
        final Diagram savedDiagram = this.getSavedDiagram(act, diagram);
        try {
            new AbstractEMFOperation((TransactionalEditingDomain)this.getEditingDomain(), ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (savedDiagram != null) {
                        DiagramManager.this.resource.getContents().set(DiagramManager.this.resource.getContents().indexOf((Object)diagram), (Object)savedDiagram);
                        DiagramManager.this.resource.getContents().set(DiagramManager.this.resource.getContents().indexOf((Object)diagram.getElement()), (Object)savedDiagram.getElement());
                        DiagramManager.this.removeDiagramBackup(act, diagram.getType());
                    } else {
                        DiagramManager.this.resource.getContents().remove((Object)diagram.getElement());
                        DiagramManager.this.resource.getContents().remove((Object)diagram);
                    }
                    ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getPersisterFor((Resource)act.eResource()).getFailSafePersister();
                    try {
                        persister.save(DiagramManager.this.resource);
                        persister.commit();
                    }
                    catch (Exception e) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                        try {
                            persister.rollback();
                        }
                        catch (Exception exception) {}
                        throw new ExecutionException(e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.execute((IProgressMonitor)new NullProgressMonitor(), null);
            return true;
        }
        catch (ExecutionException e1) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)e1);
            return false;
        }
    }

    public void updateResourceURI() {
        String path;
        File procFolder;
        if (this.resource == null) {
            return;
        }
        File folder = new File(FileManager.toFileString((URI)this.resource.getURI())).getParentFile();
        if (!folder.equals(procFolder = new File(this.process.eResource().getURI().toFileString()).getParentFile()) && (path = DiagramManager.getDiagramFilePath(this.process)) != null && new File(path).exists()) {
            this.resource.setURI(DiagramManager.createDiagramResourceURI(path));
        }
    }

    public void backupDiagram(org.eclipse.epf.uma.Activity activity, Diagram diagram) {
        Map<String, Diagram> typeToDiagamMap = this.getActivityToSavedDiagramsMap().get(activity);
        if (typeToDiagamMap == null) {
            typeToDiagamMap = new HashMap<String, Diagram>();
            this.getActivityToSavedDiagramsMap().put(activity, typeToDiagamMap);
        }
        typeToDiagamMap.put(diagram.getType(), DiagramHelper.copyDiagram((EditingDomain)this.getEditingDomain(), diagram));
    }

    public Diagram removeDiagramBackup(org.eclipse.epf.uma.Activity act, String type) {
        Map<String, Diagram> typeToDiagamMap;
        if (this.activityToSavedDiagramMap != null && (typeToDiagamMap = this.activityToSavedDiagramMap.get(act)) != null) {
            return typeToDiagamMap.remove(type);
        }
        return null;
    }

    private class GMFExtendedResourceSet
    extends ExtendedResourceSet {
        private GMFExtendedResourceSet() {
        }

        protected int getURIType(URI uri) {
            if ("uma".equals(uri.scheme())) {
                return 2;
            }
            if (DiagramManager.DIAGRAM_FILENAME.equals(uri.lastSegment())) {
                return 1;
            }
            return 2;
        }

        public Resource createResource(URI uri) {
            GMFResourceEx resource = new GMFResourceEx(uri);
            resource.getDefaultLoadOptions().putAll(GMFResourceFactory.getDefaultLoadOptions());
            resource.getDefaultSaveOptions().putAll(GMFResourceFactory.getDefaultSaveOptions());
            if (!resource.getEncoding().equals("UTF-8")) {
                resource.setEncoding("UTF-8");
            }
            this.getResources().add((Object)resource);
            return resource;
        }
    }

    private class GMFResourceEx
    extends GMFResource
    implements IFailSafeSavable {
        private FailSafePersistenceHelper failSafePersistenceHelper;

        public GMFResourceEx(URI uri) {
            super(uri);
        }

        protected XMLHelper createXMLHelper() {
            return new GMFHelper((XMLResource)this){

                protected URI getHREF(Resource otherResource, EObject obj) {
                    if (otherResource instanceof ILibraryResource) {
                        return ((ILibraryResource)otherResource).getProxyURI(obj);
                    }
                    return super.getHREF(otherResource, obj);
                }
            };
        }

        public void updateInfo() {
            IFile file = WorkspaceSynchronizer.getFile((Resource)this);
            if (DiagramManager.this.resourceIsNew) {
                DiagramManager.this.resourceIsNew = false;
                fileSynchronizer.monitor(file);
            }
            fileSynchronizer.updateModificationStamp(file);
            try {
                file.refreshLocal(0, null);
            }
            catch (CoreException e) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }

        public void save(Map options) throws IOException {
            super.save(options);
            if (!this.hasTempURI()) {
                this.updateInfo();
            }
        }

        private Adapter superCreateModificationAdapter() {
            return super.createModificationTrackingAdapter();
        }

        protected Adapter createModificationTrackingAdapter() {
            return new AdapterImpl(){
                private Adapter delegate;
                {
                    this.delegate = GMFResourceEx.this.superCreateModificationAdapter();
                }

                public void notifyChanged(Notification msg) {
                    this.delegate.notifyChanged(msg);
                    GMFResourceEx.this.notifyDiagramChangeListeners(msg);
                }
            };
        }

        public void eNotify(Notification notification) {
            if (this.isLoaded() && notification.getNotifier() instanceof Resource && notification.getFeatureID(Resource.class) == 3 && notification.getEventType() == 1) {
                int size;
                if (this.eAdapters != null && this.eDeliver() && (size = this.eAdapters.size()) > 0) {
                    Adapter[] adapters = (Adapter[])this.eAdapters.data();
                    int i = 0;
                    while (i < size) {
                        Adapter adapter = adapters[i];
                        if (!(adapter instanceof AccessibleDiagramModificationListener)) {
                            adapter.notifyChanged(notification);
                        }
                        ++i;
                    }
                }
            } else {
                super.eNotify(notification);
            }
        }

        protected void notifyDiagramChangeListeners(Notification msg) {
            int size;
            BasicEList eAdapters = this.eBasicAdapters();
            if (eAdapters != null && this.eDeliver() && (size = eAdapters.size()) > 0) {
                Adapter[] adapters = (Adapter[])eAdapters.data();
                int i = 0;
                while (i < size) {
                    Adapter adapter = adapters[i];
                    if (adapter instanceof AccessibleDiagramModificationListener) {
                        adapter.notifyChanged(msg);
                    }
                    ++i;
                }
            }
        }

        private FailSafePersistenceHelper getFailSafePersistenceHelper() {
            if (this.failSafePersistenceHelper == null) {
                String id = String.valueOf(DiagramManager.this.process.getGuid()) + DiagramManager.DIAGRAM_FILENAME_WITHOUT_EXTENSION;
                this.failSafePersistenceHelper = new FailSafePersistenceHelper((Resource)this, id);
                this.failSafePersistenceHelper.setCommitEmptyResource(true);
            }
            return this.failSafePersistenceHelper;
        }

        public void commit() {
            this.getFailSafePersistenceHelper().commit();
        }

        public void deleteBackup() {
            this.getFailSafePersistenceHelper().deleteBackup();
        }

        public boolean hasTempURI() {
            return this.getFailSafePersistenceHelper().hasTempURI();
        }

        public boolean restore() {
            return this.getFailSafePersistenceHelper().restore();
        }

        public void setTxID(String txID) {
            this.getFailSafePersistenceHelper().setTempURI(txID);
        }

        public void txFinished(boolean successful) {
            this.getFailSafePersistenceHelper().txFinished(successful);
            if (successful) {
                this.updateInfo();
            }
        }

        protected void doUnload() {
            super.doUnload();
            TreeIterator allContents = this.getAllProperContents(this.unloadingContents);
            ArrayList<EObject> list = new ArrayList<EObject>();
            while (allContents.hasNext()) {
                list.add((EObject)allContents.next());
            }
            for (EObject object : list) {
                EcoreUtil.remove((EObject)object);
            }
        }
    }
}

