/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.persistence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSynchronizer
implements IResourceChangeListener {
    protected boolean fIsInstalled = false;
    private Map<Object, FileInfo> fFileInfoMap = new HashMap<Object, FileInfo>();

    public FileSynchronizer() {
        this.install();
    }

    public boolean accept(IFile file) {
        return false;
    }

    public boolean isInstalled() {
        return this.fIsInstalled;
    }

    public void updateModificationStamp(IFile file) {
        FileInfo info = this.getFileInfo(file);
        if (info != null) {
            info.fModificationStamp = FileSynchronizer.computeModificationStamp((IResource)file);
        }
    }

    public FileInfo getFileInfo(Object element) {
        return this.fFileInfoMap.get(element);
    }

    public void install() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.fIsInstalled = true;
    }

    public void uninstall() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.fIsInstalled = false;
    }

    public void resourceChanged(IResourceChangeEvent e) {
        IResourceDelta delta = e.getDelta();
        try {
            if (delta != null && this.fIsInstalled) {
                ResourceDeltaVisistor visitor = new ResourceDeltaVisistor();
                delta.accept((IResourceDeltaVisitor)visitor);
                Runnable runnable = visitor.getRunnable();
                if (runnable != null) {
                    this.update(runnable);
                }
            }
        }
        catch (CoreException x) {
            this.handleCoreException(x, "Error handling resource change event.");
        }
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)PersistencePlugin.getDefault().getId());
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, PersistencePlugin.getDefault().getId(), 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
    }

    public static long computeModificationStamp(IResource resource) {
        if (resource == null) {
            System.err.println("FATAL ERROR: resource is null.");
            return 0L;
        }
        long modificationStamp = resource.getModificationStamp();
        IPath path = resource.getLocation();
        if (path == null) {
            return modificationStamp;
        }
        modificationStamp = path.toFile().lastModified();
        return modificationStamp;
    }

    protected void update(Runnable runnable) {
        runnable.run();
    }

    public void monitor(IFile file) {
        FileInfo info = this.fFileInfoMap.get(file);
        if (info == null) {
            info = new FileInfo(file);
            info.fModificationStamp = FileSynchronizer.computeModificationStamp((IResource)file);
            this.fFileInfoMap.put(file, info);
        }
    }

    public void unmonitor(IFile file) {
        this.fFileInfoMap.remove(file);
    }

    public void unmonitorAll() {
        this.fFileInfoMap.clear();
    }

    protected void handleChanged(ResourceDeltaVisistor visitor) {
        if (!visitor.changedFiles.isEmpty()) {
            this.handleChangedFiles(visitor.changedFiles);
        }
        if (!visitor.movedFileToNewPathMap.isEmpty()) {
            this.handleMovedFiles(visitor.movedFileToNewPathMap);
        }
        if (!visitor.deletedFiles.isEmpty()) {
            this.handleDeletedFiles(visitor.deletedFiles);
        }
        if (!visitor.addedFiles.isEmpty()) {
            this.handleAddedFiles(visitor.addedFiles);
        }
    }

    protected Collection<IFile> handleDeletedFiles(Collection<IFile> deletedFiles) {
        return Collections.emptyList();
    }

    protected Collection<IFile> handleMovedFiles(Map<IFile, IPath> movedFileToNewPathMap) {
        return Collections.emptyList();
    }

    protected Collection<IFile> handleChangedFiles(Collection<IFile> changedFiles) {
        return Collections.emptyList();
    }

    protected Collection<IFile> handleAddedFiles(Collection<IFile> addedFiles) {
        return Collections.emptyList();
    }

    public static class FileInfo {
        public long fModificationStamp = -1L;
        public boolean fCanBeSaved;
        public IFile fFile;

        public FileInfo(IFile file) {
            this.fFile = file;
        }
    }

    private class ResourceDeltaVisistor
    implements IResourceDeltaVisitor {
        private Collection<IFile> changedFiles = new ArrayList<IFile>();
        private Map<IFile, IPath> movedFileToNewPathMap = new HashMap<IFile, IPath>();
        private Collection<IFile> deletedFiles = new ArrayList<IFile>();
        private Collection<IFile> addedFiles = new ArrayList<IFile>();

        private ResourceDeltaVisistor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null) {
                return false;
            }
            if ((delta.getFlags() & 0x20000) != 131072 && delta.getResource().getType() == 1) {
                switch (delta.getKind()) {
                    case 4: {
                        boolean isSynchronized;
                        FileInfo info = FileSynchronizer.this.getFileInfo(delta.getResource());
                        if (info == null || info.fCanBeSaved) break;
                        IFile file = (IFile)delta.getResource();
                        boolean bl = isSynchronized = FileSynchronizer.computeModificationStamp((IResource)file) == info.fModificationStamp;
                        if (((0x100000 & delta.getFlags()) == 0 || !isSynchronized) && ((0x100 & delta.getFlags()) == 0 || isSynchronized)) break;
                        this.changedFiles.add(file);
                        break;
                    }
                    case 2: {
                        if ((0x2000 & delta.getFlags()) != 0) {
                            FileInfo info = FileSynchronizer.this.getFileInfo(delta.getResource());
                            if (info == null) break;
                            IPath path = delta.getMovedToPath();
                            this.movedFileToNewPathMap.put((IFile)delta.getResource(), path);
                            break;
                        }
                        FileInfo info = FileSynchronizer.this.getFileInfo(delta.getResource());
                        if (info == null || info.fCanBeSaved) break;
                        this.deletedFiles.add((IFile)delta.getResource());
                        break;
                    }
                    case 1: {
                        IFile file = (IFile)delta.getResource();
                        if (!FileSynchronizer.this.accept(file)) break;
                        this.addedFiles.add(file);
                    }
                }
            }
            return true;
        }

        public Runnable getRunnable() {
            if (!this.addedFiles.isEmpty() && !this.movedFileToNewPathMap.isEmpty()) {
                Iterator<IFile> iter = this.addedFiles.iterator();
                while (iter.hasNext()) {
                    IFile file = iter.next();
                    if (!this.movedFileToNewPathMap.containsValue(file)) continue;
                    iter.remove();
                }
            }
            if (this.changedFiles.isEmpty() && this.movedFileToNewPathMap.isEmpty() && this.deletedFiles.isEmpty() && this.addedFiles.isEmpty()) {
                return null;
            }
            return new Runnable(){

                public void run() {
                    FileSynchronizer.this.handleChanged(ResourceDeltaVisistor.this);
                }
            };
        }
    }
}

