/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.epf.persistence.migration.MigrationResourceHandler;

public class UMA2UMAResourceHandler
extends MigrationResourceHandler {
    private static final boolean DEBUG = true;
    private List moveInfos = new ArrayList();

    protected static EAttribute getEAttribute(EClass eClass, String name) {
        for (EAttribute attrib : eClass.getEAllAttributes()) {
            if (!attrib.getName().equals(name)) continue;
            return attrib;
        }
        return null;
    }

    protected EStructuralFeature getNewFeature(EObject owner, String featureName) {
        return null;
    }

    protected EObject getNewOwner(EObject oldOwner, String featureName) {
        return null;
    }

    protected Object getNewValue(EObject oldOwner, String featureName, AnyType value) {
        return null;
    }

    public void moveData() {
        for (MoveInfo info : this.moveInfos) {
            EObject newOwner = this.getNewOwner(info.oldOwner, info.oldFeatureName);
            if (newOwner == null) continue;
            UMA2UMAResourceHandler.setValue(newOwner, info.newFeature, info.value);
        }
    }

    public static void setValue(EObject eObject, EStructuralFeature feature, Object value) {
        if (!feature.isMany()) {
            eObject.eSet(feature, value);
        } else {
            Collection values = (Collection)eObject.eGet(feature);
            if (value instanceof Collection) {
                values.addAll((Collection)value);
            } else {
                values.add(value);
            }
        }
    }

    public static Object getSingleValue(FeatureMap featureMap, String featureName) {
        for (FeatureMap.Entry entry : featureMap) {
            if (!entry.getEStructuralFeature().getName().equals(featureName)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected static Collection getValue(FeatureMap featureMap, String featureName) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (FeatureMap.Entry entry : featureMap) {
            if (!entry.getEStructuralFeature().getName().equals(featureName)) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public void clearMoveInfos() {
        this.moveInfos.clear();
    }

    protected boolean handleUnknownFeature(EObject owner, EStructuralFeature feature, Object value) {
        String featureName = feature.getName();
        EStructuralFeature newFeature = this.getNewFeature(owner, featureName);
        if (newFeature != null) {
            MoveInfo moveInfo = new MoveInfo();
            moveInfo.oldOwner = owner;
            moveInfo.oldFeatureName = featureName;
            moveInfo.newFeature = newFeature;
            moveInfo.value = value instanceof AnyType ? this.getNewValue(owner, featureName, (AnyType)value) : value;
            this.moveInfos.add(moveInfo);
            System.out.println(moveInfo);
            System.out.println();
            return true;
        }
        return false;
    }

    private static class MoveInfo {
        EObject oldOwner;
        String oldFeatureName;
        EStructuralFeature newFeature;
        Object value;

        private MoveInfo() {
        }

        public String toString() {
            return new StringBuffer().append(this.getClass().getName()).append("(\n").append("  oldFeatureName: ").append(this.oldFeatureName).append('\n').append("  newFeature: ").append(this.newFeature).append('\n').append("  value: ").append(this.value).append('\n').append(")").toString();
        }
    }
}

