/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.refresh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshJob
extends WorkspaceJob
implements IResourceChangeListener {
    private static final long UPDATE_DELAY = 200L;
    private static final boolean DEBUG = PersistencePlugin.getDefault().isDebugging();
    private static final String DEBUG_PREFIX = "EPF Auto-refresh:";
    private ResourceSet resourceSet;
    private Collection<Resource> addedResources = new UniqueEList();
    private Collection<Resource> changedResources = new UniqueEList();
    private Collection<Resource> removedResources = new UniqueEList();
    private Collection<Resource> movedResources = new UniqueEList();
    private UniqueEList<Resource> savedResources = new UniqueEList();
    private Collection<Resource> loadedBeforeRefreshResources = new ArrayList<Resource>();
    private IRefreshHandler refreshHandler;
    private boolean enabled = true;
    private Collection<IResource> addedWorkspaceResources = new UniqueEList();
    private static RefreshJob instance = new RefreshJob();

    private RefreshJob() {
        super(PersistenceResources.resourceAutoRefreshJob_name);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setRefreshHandler(IRefreshHandler handler) {
        this.refreshHandler = handler;
    }

    public Collection<Resource> getAddedResources() {
        RefreshJob.removeResources(this.addedResources, this.savedResources);
        return this.addedResources;
    }

    public Collection<IResource> getAddedWorkspaceResources() {
        return this.addedWorkspaceResources;
    }

    public Collection<Resource> getChangedResources() {
        RefreshJob.removeResources(this.changedResources, this.savedResources);
        RefreshJob.removeResources(this.changedResources, this.loadedBeforeRefreshResources);
        return this.changedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeResources(Collection<Resource> resources, Collection<Resource> resourcesToRemove) {
        Collection<Resource> collection = resourcesToRemove;
        synchronized (collection) {
            if (!resourcesToRemove.isEmpty()) {
                Iterator<Resource> iter = resourcesToRemove.iterator();
                while (iter.hasNext()) {
                    Resource resource = iter.next();
                    boolean canRemove = true;
                    if (resource instanceof MultiFileXMIResourceImpl) {
                        MultiFileXMIResourceImpl mfResource = (MultiFileXMIResourceImpl)resource;
                        canRemove = mfResource.isSynchronized();
                    }
                    if (!canRemove || !resources.remove(resource)) continue;
                    iter.remove();
                }
            }
        }
    }

    public Collection<Resource> getRemovedResources() {
        return this.removedResources;
    }

    public Collection<Resource> getMovedResources() {
        return this.movedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceSaved(Resource resource) {
        if (resource.getResourceSet() == this.resourceSet) {
            UniqueEList<Resource> uniqueEList = this.savedResources;
            synchronized (uniqueEList) {
                this.savedResources.add((Object)resource);
            }
        }
    }

    public Collection<Resource> getReloadedBeforeRefreshResources() {
        return this.loadedBeforeRefreshResources;
    }

    public void reset() {
        this.changedResources.clear();
        this.removedResources.clear();
        this.movedResources.clear();
        this.savedResources.clear();
        this.loadedBeforeRefreshResources.clear();
        this.addedResources.clear();
        this.addedWorkspaceResources.clear();
    }

    private MethodLibrary getMethodLibrary() {
        if (this.resourceSet instanceof MultiFileResourceSetImpl) {
            return ((MultiFileResourceSetImpl)this.resourceSet).getMethodLibrary();
        }
        return null;
    }

    private void scheduleRefresh() {
        MethodLibrary lib;
        if (this.getState() == 0 && (lib = this.getMethodLibrary()) != null) {
            this.setRule(new LibrarySchedulingRule(lib));
            this.schedule(200L);
        }
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        if (this.refreshHandler == null) {
            return Status.OK_STATUS;
        }
        long start = System.currentTimeMillis();
        Throwable error = null;
        try {
            if (DEBUG) {
                System.out.println("EPF Auto-refresh: starting refresh job");
            }
            monitor.beginTask("", -1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                this.refreshHandler.refresh(monitor);
            }
            catch (Throwable e) {
                error = e;
            }
        }
        finally {
            monitor.done();
            if (DEBUG) {
                System.out.println("EPF Auto-refresh: finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        if (error != null) {
            return new Status(4, FileManager.PLUGIN_ID, 0, "Refresh error", error);
        }
        return Status.OK_STATUS;
    }

    public synchronized boolean shouldRun() {
        return this.shouldRefresh();
    }

    private boolean shouldRefresh() {
        return !this.removedResources.isEmpty() || !this.changedResources.isEmpty() || !this.addedResources.isEmpty() || !this.movedResources.isEmpty() || !this.loadedBeforeRefreshResources.isEmpty() || !this.addedWorkspaceResources.isEmpty();
    }

    public void start() {
        if (DEBUG) {
            System.out.println("RefreshJob.start()");
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void stop() {
        if (DEBUG) {
            System.out.println("RefreshJob.stop()");
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.cancel();
    }

    public Resource getResource(IResource wsRes) {
        if (this.resourceSet instanceof MultiFileResourceSetImpl) {
            return ((MultiFileResourceSetImpl)this.resourceSet).getResource(wsRes);
        }
        IPath path = wsRes.getLocation();
        return path != null ? PersistenceUtil.getResource(path, this.resourceSet) : null;
    }

    private boolean accept(IResource resource) {
        if (this.resourceSet instanceof MultiFileResourceSetImpl) {
            return ((MultiFileResourceSetImpl)this.resourceSet).isNewResourceToLoad(resource);
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.isEnabled() || this.resourceSet == null) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            class ResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                private Collection<Resource> changedResources = new ArrayList<Resource>();
                private Collection<Resource> removedResources = new ArrayList<Resource>();
                private Collection<Resource> movedResources = new ArrayList<Resource>();
                private Collection<Resource> addedResources = new ArrayList<Resource>();
                private ArrayList<IResource> addedWorkspaceResources = new ArrayList();

                ResourceDeltaVisitor() {
                }

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if ((delta.getFlags() & 0x20000) != 131072 && delta.getResource().getType() == 1) {
                        switch (delta.getKind()) {
                            case 1: {
                                Resource resource = RefreshJob.this.getResource(delta.getResource());
                                if (resource != null) {
                                    MethodElement me;
                                    if (!resource.isLoaded() && !((me = PersistenceUtil.getMethodElement(resource)) instanceof ContentDescription)) {
                                        this.addedResources.add(resource);
                                    }
                                } else if (RefreshJob.this.accept(delta.getResource())) {
                                    this.addedWorkspaceResources.add(delta.getResource());
                                }
                                if ((0x1000 & delta.getFlags()) == 0 || !DEBUG) break;
                                IPath movedFromPath = delta.getResource().getLocation();
                                IPath movedToPath = delta.getMovedToPath();
                                System.out.println("Resource moved from '" + movedFromPath + "' to '" + movedToPath + "'");
                                break;
                            }
                            case 2: {
                                Resource resource = RefreshJob.this.getResource(delta.getResource());
                                if (resource == null) break;
                                this.removedResources.add(resource);
                                break;
                            }
                            case 4: {
                                Resource resource;
                                boolean contentChanged;
                                boolean encodingChanged = (0x100000 & delta.getFlags()) != 0;
                                boolean bl = contentChanged = (0x100 & delta.getFlags()) != 0;
                                if (!encodingChanged && !contentChanged || (resource = RefreshJob.this.getResource(delta.getResource())) == null || MultiFileSaveUtil.checkSynchronized(resource) == 1) break;
                                this.changedResources.add(resource);
                            }
                        }
                    }
                    return true;
                }
            }
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            delta.accept((IResourceDeltaVisitor)visitor);
            this.removedResources.addAll(visitor.removedResources);
            this.movedResources.addAll(visitor.movedResources);
            this.changedResources.addAll(visitor.changedResources);
            this.addedResources.addAll(visitor.addedResources);
            this.addedWorkspaceResources.addAll(visitor.addedWorkspaceResources);
            if (this.shouldRefresh()) {
                this.scheduleRefresh();
            }
        }
        catch (CoreException e) {
            CommonPlugin.INSTANCE.log((Object)e);
        }
    }

    public EObject resolve(EObject proxy) {
        return PersistenceUtil.resolve(proxy, this.resourceSet);
    }

    public static RefreshJob getInstance() {
        return instance;
    }
}

