/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.ui.EPFUIResources;
import org.eclipse.epf.ui.dialogs.RenameFileConflictDialog;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LibraryUIUtil {
    public static void updateShellTitle() {
        Shell shell;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (shell = window.getShell()) != null) {
            String libPath = "";
            if (LibraryService.getInstance().getCurrentMethodLibrary() != null && (libPath = LibraryServiceUtil.getCurrentMethodLibraryPath()) == null) {
                libPath = LibraryService.getInstance().getCurrentMethodLibrary().getName();
            }
            String appName = Platform.getProduct().getName();
            String appTitle = NLS.bind((String)LibraryUIResources.application_title, (Object[])new Object[]{appName, libPath});
            shell.setText(appTitle);
        }
    }

    public static int displaySaveDirtyEditorsDialog() {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && manager.isMethodLibraryModified()) {
            int ret = MsgBox.prompt((String)LibraryUIResources.saveLibraryDialog_title, (String)LibraryUIResources.saveLibraryDialog_text, (int)448);
            switch (ret) {
                case 64: {
                    try {
                        LibraryService.getInstance().saveCurrentMethodLibrary();
                    }
                    catch (Exception e) {
                        MsgDialog dialog = LibraryUIPlugin.getDefault().getMsgDialog();
                        dialog.displayError(LibraryUIResources.saveLibraryDialog_title, LibraryUIResources.saveLibraryError_msg, LibraryUIResources.error_reason, (Throwable)e);
                    }
                    return 64;
                }
                case 128: {
                    manager.discardMethodLibraryChanges();
                    return 128;
                }
                case 256: {
                    return 256;
                }
            }
        }
        return 256;
    }

    public static String getURLForAttachment(Shell shell, File attachment, MethodElement element, boolean copyFile) throws IOException {
        FileUtil.appendSeparator((String)new File(UmaUtil.getMethodPlugin((EObject)element).eResource().getURI().toFileString()).getParent());
        File formatFile = null;
        String resourceLoc = ResourceHelper.getAbsoluteElementResourcePath((MethodElement)element);
        formatFile = new File(String.valueOf(resourceLoc) + File.separator + attachment.getName());
        if (copyFile) {
            File newFile = LibraryUIUtil.copyResourceToLib(shell, attachment, element);
            if (newFile == null) {
                return null;
            }
            formatFile = new File(String.valueOf(resourceLoc) + File.separator + newFile.getName());
            IResource wsResource = FileManager.getResourceForLocation((String)formatFile.getAbsolutePath());
            if (wsResource != null) {
                try {
                    FileManager.refresh((IResource)wsResource);
                }
                catch (Exception e) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
        return ResourceHelper.getRelativePathToFileFromElement((MethodElement)element, (File)formatFile);
    }

    public static File copyResourceToLib(Shell shell, File resource, MethodElement methodElement) {
        String resourceLoc = ResourceHelper.getAbsoluteElementResourcePath((MethodElement)methodElement);
        File libFile = new File(resourceLoc, resource.getName());
        if (resource.equals(libFile)) {
            return libFile;
        }
        if (libFile.exists() && shell != null) {
            RenameFileConflictDialog dialog = new RenameFileConflictDialog(shell);
            dialog.setMessageStr(MessageFormat.format(EPFUIResources.Dialog_fileNameConflict_msg, resource.getName(), resourceLoc));
            dialog.setDestination(resourceLoc);
            dialog.setFilePath(resource.getName());
            dialog.open();
            if (dialog.getReturnCode() == 1) {
                return null;
            }
            libFile = new File(resourceLoc, dialog.getFilePath());
        }
        FileUtil.copyFile((File)resource, (File)libFile);
        IResource wsResource = FileManager.getResourceForLocation((String)libFile.getAbsolutePath());
        if (wsResource != null) {
            try {
                FileManager.refresh((IResource)wsResource);
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return libFile;
    }
}

