/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.ui.util.TypeConverter;
import org.eclipse.epf.library.util.ConvertActivityType;
import org.eclipse.epf.uma.Activity;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ConvertActivityDialog {
    public static Activity queryUserAndConvert(Activity oldActivity, Shell shell, DeleteMethodElementCommand command) {
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        ListDialog dlg = new ListDialog(shell);
        dlg.setHeightInChars(5);
        dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                switch ((Integer)element) {
                    case 53: {
                        return LibraryUIText.TEXT_ACTIVITY;
                    }
                    case 68: {
                        return LibraryUIText.TEXT_ITERATION;
                    }
                    case 69: {
                        return LibraryUIText.TEXT_PHASE;
                    }
                }
                return LibraryResources.unknownGuidance_text;
            }
        });
        List newActivityTypeList = ConvertActivityDialog.getValidNewActivityTypes(oldActivity);
        if (newActivityTypeList == null) {
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertActivityError_title, LibraryUIResources.unsupportedActivityType_msg, LibraryUIResources.bind(LibraryUIResources.unsupportedActivityType_reason, StrUtil.toLower((String)TngUtil.getTypeText((EObject)oldActivity))));
            return null;
        }
        dlg.setInput((Object)newActivityTypeList);
        dlg.setTitle(LibraryUIResources.convertActivityDialog_title);
        dlg.setMessage(LibraryUIResources.convertActivityDialog_text);
        if (dlg.open() == 1) {
            return null;
        }
        Object[] selectionResult = dlg.getResult();
        if (selectionResult == null) {
            return null;
        }
        int chosenActivity = (Integer)selectionResult[0];
        return TypeConverter.convertActivity(oldActivity, TypeConverter.getActivityType(chosenActivity));
    }

    public static List getValidNewActivityTypes(Activity oldActivity) {
        if (oldActivity == null) {
            return null;
        }
        Integer oldActivityClassID = new Integer(oldActivity.eClass().getClassifierID());
        if (!ConvertActivityType.compatibleActivitiesList.contains(oldActivityClassID)) {
            return null;
        }
        ArrayList<Integer> activityList = new ArrayList<Integer>();
        for (Integer compatibleActivityTypeClassID : ConvertActivityType.compatibleActivitiesList) {
            if (oldActivityClassID.equals(compatibleActivityTypeClassID) || compatibleActivityTypeClassID == 76 || compatibleActivityTypeClassID == 74) continue;
            activityList.add(compatibleActivityTypeClassID);
        }
        return activityList;
    }
}

