/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.util.TypeConverter;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ConvertGuidanceType {
    static IValidator validator;
    private static int[] compatibleGuidances;
    private static List compatibleGuidancesList;

    static {
        compatibleGuidances = new int[]{19, 21, 15};
        compatibleGuidancesList = new ArrayList();
        int i = 0;
        while (i < compatibleGuidances.length) {
            compatibleGuidancesList.add(new Integer(compatibleGuidances[i]));
            ++i;
        }
    }

    public static Guidance convertGuidance(Guidance oldGuidance, Shell shell, DeleteMethodElementCommand command) {
        return ConvertGuidanceType.convertGuidance(oldGuidance, shell, command, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Guidance convertGuidance(Guidance oldGuidance, Shell shell, DeleteMethodElementCommand command, EClass newType) {
        Guidance guidance;
        if (newType == null) {
            if (shell == null) {
                shell = Display.getCurrent().getActiveShell();
            }
            ListDialog dlg = new ListDialog(shell);
            dlg.setHeightInChars(5);
            dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    switch ((Integer)element) {
                        case 19: {
                            return LibraryResources.concept_text;
                        }
                        case 20: {
                            return LibraryResources.checklist_text;
                        }
                        case 22: {
                            return LibraryResources.example_text;
                        }
                        case 21: {
                            return LibraryResources.guideline_text;
                        }
                        case 32: {
                            return LibraryResources.estimationConsiderations_text;
                        }
                        case 29: {
                            return LibraryResources.report_text;
                        }
                        case 30: {
                            return LibraryResources.template_text;
                        }
                        case 15: {
                            return LibraryResources.supportingMaterial_text;
                        }
                        case 31: {
                            return LibraryResources.toolMentor_text;
                        }
                        case 37: {
                            return LibraryResources.whitepaper_text;
                        }
                        case 24: {
                            return LibraryResources.termDefinition_text;
                        }
                        case 80: {
                            return LibraryResources.practice_text;
                        }
                        case 23: {
                            return LibraryResources.reusableAsset_text;
                        }
                    }
                    return LibraryResources.unknownGuidance_text;
                }
            });
            List newGuidanceTypeList = ConvertGuidanceType.getValidNewGuidanceTypes(oldGuidance);
            if (newGuidanceTypeList == null) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertGuidanceError_title, LibraryResources.unsupportedGuidanceTypeError_msg, NLS.bind((String)LibraryResources.unsupportedGuidanceTypeError_reason, (Object)StrUtil.toLower((String)TngUtil.getTypeText((EObject)oldGuidance))));
                return null;
            }
            dlg.setInput((Object)newGuidanceTypeList);
            dlg.setTitle(LibraryResources.convertGuidanceDialog_title);
            dlg.setMessage(LibraryResources.convertGuidanceDialog_text);
            if (dlg.open() == 1) {
                return null;
            }
            Object[] selectionResult = dlg.getResult();
            if (selectionResult == null) {
                return null;
            }
            int chosenGuidance = (Integer)selectionResult[0];
            newType = ConvertGuidanceType.getGuidanceType(chosenGuidance);
        }
        if (newType == null) {
            return null;
        }
        TypeConverter.TypeConversionCommand cmd = TypeConverter.createTypeConversionCommand((EObject)oldGuidance, newType, null, null, true, true);
        try {
            block28: {
                block27: {
                    IStatus status;
                    block26: {
                        if (cmd.getIllegalReferencers().isEmpty()) break block26;
                        MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
                        for (MethodElement e : cmd.getIllegalReferencers()) {
                            if (TngUtil.isPredefined((MethodElement)e)) continue;
                            String msg = NLS.bind((String)LibraryEditResources.elementType_text, (Object)e.eClass().getName(), (Object)TngUtil.getLabelWithPath((Object)e));
                            Status status2 = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, null);
                            multiStatus.add((IStatus)status2);
                        }
                        if (multiStatus.getChildren().length > 0 && LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryResources.convertGuidanceDialog_title, LibraryEditResources.confirm_remove_references_text, (IStatus)multiStatus) == 1) break block27;
                    }
                    if ((status = UserInteractionHelper.checkModify(cmd.getModifiedResources(), (Object)shell)).isOK()) break block28;
                    LibraryUIPlugin.getDefault().getMsgDialog().display(LibraryResources.convertGuidanceDialog_title, status);
                }
                if (cmd == null) return null;
                try {
                    cmd.dispose();
                    return null;
                }
                catch (Exception exception) {}
                return null;
            }
            cmd.execute();
            Guidance newGuidance = (Guidance)cmd.getResult().iterator().next();
            ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            try {
                Iterator<Resource> iter = cmd.getModifiedResources().iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        persister.commit();
                        if (ContentDescriptionFactory.hasPresentation((MethodElement)newGuidance)) {
                            persister.adjustLocation(newGuidance.getPresentation().eResource());
                        }
                        cmd.copyResources();
                        break;
                    }
                    Resource resource = iter.next();
                    persister.save(resource);
                }
            }
            catch (Exception e) {
                persister.rollback();
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertGuidanceError_title, NLS.bind((String)LibraryResources.saveConvertedGuidanceError_msg, (Object)newGuidance.getName()), LibraryResources.error_reason, (Throwable)e);
            }
            guidance = newGuidance;
            if (cmd == null) return guidance;
        }
        catch (Throwable throwable) {
            if (cmd == null) throw throwable;
            try {
                cmd.dispose();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            cmd.dispose();
            return guidance;
        }
        catch (Exception exception) {}
        return guidance;
    }

    private static String checkName(Guidance oldGuidance, Guidance newGuidance) {
        validator = new ContentElementNameValidator(oldGuidance.eContainer(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentPackage_ContentElements(), (ContentElement)newGuidance, (IFilter)new ValidatorFactory.TypeFilter((EObject)newGuidance));
        String msg = validator.isValid(newGuidance.getName());
        if (msg != null) {
            String featureTxt = TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            String title = LibraryEditResources.resolveNameConflictDialog_title;
            String dlgMsg = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)featureTxt), (Object)newGuidance.getName());
            String currentValue = (String)newGuidance.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            IInputValidator inputValidator = new IInputValidator(){

                public String isValid(String newText) {
                    return validator.isValid(newText);
                }
            };
            InputDialog inputDlg = new InputDialog(MsgBox.getDefaultShell(), title, dlgMsg, currentValue, inputValidator);
            if (inputDlg.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDlg.getValue();
        }
        return null;
    }

    private static EClass getGuidanceType(int newGuidanceType) {
        switch (newGuidanceType) {
            case 19: {
                return UmaPackage.Literals.CONCEPT;
            }
            case 20: {
                return UmaPackage.Literals.CHECKLIST;
            }
            case 22: {
                return UmaPackage.Literals.EXAMPLE;
            }
            case 21: {
                return UmaPackage.Literals.GUIDELINE;
            }
            case 32: {
                return UmaPackage.Literals.ESTIMATION_CONSIDERATIONS;
            }
            case 29: {
                return UmaPackage.Literals.REPORT;
            }
            case 30: {
                return UmaPackage.Literals.TEMPLATE;
            }
            case 15: {
                return UmaPackage.Literals.SUPPORTING_MATERIAL;
            }
            case 31: {
                return UmaPackage.Literals.TOOL_MENTOR;
            }
            case 37: {
                return UmaPackage.Literals.WHITEPAPER;
            }
            case 24: {
                return UmaPackage.Literals.TERM_DEFINITION;
            }
            case 80: {
                return UmaPackage.Literals.PRACTICE;
            }
            case 23: {
                return UmaPackage.Literals.REUSABLE_ASSET;
            }
        }
        return null;
    }

    private static Guidance createNewGuidance(int newGuidanceType) {
        switch (newGuidanceType) {
            case 19: {
                return UmaFactory.eINSTANCE.createConcept();
            }
            case 20: {
                return UmaFactory.eINSTANCE.createChecklist();
            }
            case 22: {
                return UmaFactory.eINSTANCE.createExample();
            }
            case 21: {
                return UmaFactory.eINSTANCE.createGuideline();
            }
            case 32: {
                return UmaFactory.eINSTANCE.createEstimationConsiderations();
            }
            case 29: {
                return UmaFactory.eINSTANCE.createReport();
            }
            case 30: {
                return UmaFactory.eINSTANCE.createTemplate();
            }
            case 15: {
                return UmaFactory.eINSTANCE.createSupportingMaterial();
            }
            case 31: {
                return UmaFactory.eINSTANCE.createToolMentor();
            }
            case 37: {
                return UmaFactory.eINSTANCE.createWhitepaper();
            }
            case 24: {
                return UmaFactory.eINSTANCE.createTermDefinition();
            }
            case 80: {
                return UmaFactory.eINSTANCE.createPractice();
            }
            case 23: {
                return UmaFactory.eINSTANCE.createReusableAsset();
            }
        }
        return null;
    }

    public static List getValidNewGuidanceTypes(Guidance oldGuidance) {
        if (oldGuidance == null) {
            return null;
        }
        Integer oldGuidanceClassID = new Integer(oldGuidance.eClass().getClassifierID());
        if (!compatibleGuidancesList.contains(oldGuidanceClassID)) {
            return null;
        }
        ArrayList<Integer> guidanceList = new ArrayList<Integer>();
        int i = 0;
        while (i < compatibleGuidances.length) {
            Integer compatibleGuidanceTypeClassID = new Integer(compatibleGuidances[i]);
            if (!oldGuidanceClassID.equals(compatibleGuidanceTypeClassID)) {
                guidanceList.add(compatibleGuidanceTypeClassID);
            }
            ++i;
        }
        return guidanceList;
    }
}

