/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.service.utils.CommandLineRunUtil;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.OpenLibraryMainPage;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class OpenLibraryWizard
extends BaseWizard
implements INewWizard {
    public static final String WIZARD_ID = OpenLibraryWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.library.ui.openLibraryWizard";
    protected OpenLibraryMainPage mainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(LibraryUIResources.openLibraryWizard_title);
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.mainPage = this.createMainPage();
            super.addPage((IWizardPage)this.mainPage);
        } else {
            ArrayList<Object> wizardPages = new ArrayList<Object>();
            IWizardPage page = this.wizardExtender.getReplaceWizardPage(OpenLibraryMainPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.mainPage = this.createMainPage();
                wizardPages.add((Object)this.mainPage);
            }
            super.getNewWizardPages(wizardPages);
            for (IWizardPage iWizardPage : wizardPages) {
                super.addPage(iWizardPage);
            }
            this.wizardExtender.initWizardPages(wizardPages);
        }
    }

    protected OpenLibraryMainPage createMainPage() {
        return new OpenLibraryMainPage();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(LibraryUIPlugin.getDefault().getSharedImage("full/obj16/MethodLibrary.gif"));
    }

    public boolean performFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.doFinish();
        }
        return this.openMethodLibrary(this.mainPage.getLibraryPath(), "xmi");
    }

    public boolean openMethodLibrary(String path, String type) {
        block12: {
            File libraryPath;
            block13: {
                block10: {
                    block11: {
                        try {
                            HashMap<String, String> options = new HashMap<String, String>();
                            libraryPath = new File(path);
                            options.put("library.path", libraryPath.getAbsolutePath());
                            if (XMILibraryUtil.isValidLibrary((String)path, (boolean)true) != Status.OK_STATUS) break block10;
                            if (OpenLibraryWizard.handleToolVersion(path, null)) break block11;
                            return false;
                        }
                        catch (Exception e) {
                            String reason = e.getMessage();
                            if (reason == null) {
                                reason = LibraryUIResources.openLibraryInternlError_reason;
                            }
                            reason = String.valueOf(reason) + "\n\n" + LibraryUIResources.openLibraryError_advice;
                            if (e.getMessage() != null) {
                                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.openLibraryError_msg, reason);
                            } else {
                                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.openLibraryError_msg, reason, (Throwable)e);
                            }
                            return false;
                        }
                    }
                    if (LibraryUIManager.getInstance().openLibrary(path)) {
                        LibraryUIPreferences.addOpenLibraryPath(libraryPath.getAbsolutePath());
                        return true;
                    }
                    break block12;
                }
                if (XMILibraryUtil.containsPluginOrConfigSpecExportFile((String)path)) {
                    throw new Exception(LibraryUIResources.openLibraryError_reason4);
                }
                MsgDialog msgDialog = LibraryUIPlugin.getDefault().getMsgDialog();
                boolean rc = msgDialog.displayConfirmation(LibraryUIResources.openLibraryWizard_title, NLS.bind((String)LibraryUIResources.openLibraryDialog_newLibrary_text, (Object[])new Object[]{path}));
                if (rc) break block13;
                return false;
            }
            if (!LibraryUIManager.getInstance().createLibrary(path)) break block12;
            LibraryUIPreferences.addOpenLibraryPath(libraryPath.getAbsolutePath());
            return true;
        }
        return true;
    }

    public static boolean handleToolVersion(String path, UpgradeCallerInfo callerInfo) {
        VersionUtil.VersionCheckInfo info;
        String libXmi = "library.xmi";
        if (callerInfo != null && callerInfo.getIsExportedPluginLib()) {
            libXmi = "export.xmi";
        }
        if ((info = VersionUtil.checkLibraryVersion((File)new File(path, libXmi))) != null && info.result > 0) {
            String message = "";
            message = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)LibraryUIResources.versionMismatchDialog_text, (Object[])new Object[]{Platform.getProduct().getName(), info.toolVersion}) : NLS.bind((String)LibraryUIResources.versionMismatchDialog_text_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
            if (!OpenLibraryWizard.isUpgradeLibrary(callerInfo)) {
                callerInfo.setErrorMsg(message);
                return false;
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, message);
            return false;
        }
        if (XMILibraryUtil.isMethodLibraryUpgradeRequired((String)path, (String)libXmi, (VersionUtil.VersionCheckInfo)info)) {
            if (!CommandLineRunUtil.getInstance().isNeedToRun() && OpenLibraryWizard.isUpgradeLibrary(callerInfo) && !LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.upgradeLibraryDialog_text)) {
                return false;
            }
            if (!OpenLibraryWizard.isUpgradeLibrary(callerInfo)) {
                callerInfo.copyLibrary();
                if (callerInfo.getCopiedLibFile() != null) {
                    path = callerInfo.getCopiedLibFile().getParentFile().getAbsolutePath();
                }
            }
            if (!LibraryUIManager.upgradeLibrary(path, callerInfo)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isUpgradeLibrary(UpgradeCallerInfo callerInfo) {
        return UpgradeCallerInfo.isUpgradeLibrary((UpgradeCallerInfo)callerInfo);
    }
}

