/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.views.ProcessTreeViewer;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SelectProcessPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectProcessPage.class.getName();
    private ProcessTreeViewer processTreeViewer;
    private Text briefDescText;
    private Process process;

    public SelectProcessPage() {
        super(PAGE_NAME);
        this.setTitle(LibraryUIResources.selectProcessWizardPage_title);
        this.setDescription(LibraryUIResources.selectProcessWizardPage_text);
        this.setImageDescriptor(LibraryUIPlugin.getDefault().getImageDescriptor("full/wizban/ExportProcess.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = SelectProcessPage.createGridLayoutComposite((Composite)parent, (int)1);
        SelectProcessPage.createLabel((Composite)composite, (String)LibraryUIResources.processesLabel_text);
        this.processTreeViewer = new ProcessTreeViewer(composite);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 250;
        this.processTreeViewer.getTree().setLayoutData((Object)gridData);
        SelectProcessPage.createLabel((Composite)composite, (String)LibraryUIResources.briefDescriptionLabel_text);
        this.briefDescText = SelectProcessPage.createMultiLineText((Composite)composite, (String)"", (int)100, (int)70, (int)1);
        this.initControls();
        this.setControl((Control)composite);
    }

    protected void initControls() {
        this.processTreeViewer.setInput(LibraryService.getInstance().getCurrentMethodLibrary());
        this.processTreeViewer.expandAll();
        this.addListeners();
    }

    protected void addListeners() {
        this.processTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof TreeSelection) {
                    Object element = ((TreeSelection)selection).getFirstElement();
                    if (element instanceof Process) {
                        SelectProcessPage.this.process = (Process)element;
                        SelectProcessPage.this.briefDescText.setText(SelectProcessPage.this.process.getBriefDescription());
                    } else {
                        SelectProcessPage.this.process = null;
                        SelectProcessPage.this.briefDescText.setText("");
                    }
                }
                SelectProcessPage.this.setPageComplete(SelectProcessPage.this.isPageComplete());
                SelectProcessPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.getProcess() != null;
    }

    public Object getNextPageData() {
        return this.getProcess();
    }

    public Process getProcess() {
        return this.process;
    }
}

