/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.IActivator;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.services.ConfigurationExportService;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportService;
import org.eclipse.epf.importing.services.DirCopy;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImportingService {
    private UpgradeCallerInfo upGradeInfo;
    private static boolean newMergeScheme = true;
    private static boolean localDebug = false;
    private PluginImportData data;
    private Object validateHookData;
    LibraryDocument importingLibDoc;
    LibraryDocument targetLibDoc;
    IStatus fileCheckedOutStatus = null;
    private boolean checkBasePlugins = true;
    private File defaultConfigFolder;
    private Map<String, File> targetFileMap;

    public PluginImportingService(PluginImportData data) {
        this.data = data;
    }

    public void validate(IProgressMonitor monitor) {
        try {
            if (monitor != null) {
                monitor.setTaskName(ImportResources.PluginImportingService_MSG0);
            }
            if (this.data == null) {
                return;
            }
            this.data.clear();
            File importingLibPath = new File(String.valueOf(this.data.llData.getParentFolder()) + File.separator + "export.xmi");
            if (!importingLibPath.exists()) {
                this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.PluginImportingService_MSG1, (Object)importingLibPath.toString()));
                return;
            }
            boolean handleVersion = true;
            if (handleVersion) {
                this.upGradeInfo = new ConfigurationImportService.UpgradeInfo(UpgradeCallerInfo.upgradeImportPlugin, importingLibPath);
                if (!ConfigurationImportService.handleToolVersion(importingLibPath, this.upGradeInfo)) {
                    this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.importPluginsWizard_ERR_Import_plugin, (Object)importingLibPath.toString()));
                    return;
                }
                if (this.upGradeInfo.getCopiedLibFile() != null) {
                    importingLibPath = this.upGradeInfo.getCopiedLibFile();
                }
            } else {
                String versionError = ConfigurationImportService.versionCheck(importingLibPath.getAbsolutePath(), ImportResources.importPluginsWizard_title);
                if (versionError != null) {
                    this.data.getErrorInfo().addError(versionError);
                    return;
                }
            }
            this.validateHook(monitor, importingLibPath, this.validateHookData);
            this.importingLibDoc = new LibraryDocument(importingLibPath);
            File libFile = new File(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString());
            this.targetLibDoc = new LibraryDocument(libFile);
            this.scanLibraryFile(this.importingLibDoc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void validateHook(IProgressMonitor monitor, File importingLibPath, Object object) {
    }

    public void performImport(IProgressMonitor monitor) throws Exception {
        boolean refresh = RefreshJob.getInstance().isEnabled();
        try {
            if (refresh) {
                RefreshJob.getInstance().setEnabled(false);
            }
            this.__doImport(monitor);
        }
        finally {
            if (refresh) {
                RefreshJob.getInstance().setEnabled(true);
            }
            if (this.upGradeInfo != null) {
                this.upGradeInfo.removeCopiedLibrary();
                this.upGradeInfo = null;
            }
            this.defaultConfigFolder = null;
            this.targetFileMap = null;
        }
    }

    private void __doImport(IProgressMonitor monitor) {
        try {
            if (monitor != null) {
                monitor.setTaskName(ImportResources.PluginImportingService_MSG3);
            }
            List unlockedPlugins = this.unlockPlugins();
            if (this.fileCheckedOutStatus != null && !this.fileCheckedOutStatus.isOK()) {
                this.displayCheckOutError();
                return;
            }
            File libFile = this.targetLibDoc.getFile();
            this.defaultConfigFolder = null;
            this.targetFileMap = new HashMap<String, File>();
            if (newMergeScheme) {
                if (!this.merge(this.targetLibDoc)) {
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            String title = ImportResources.importPluginsWizard_title;
                            String msg = ImportResources.importPluginsWizard_ERR_Import_plugin;
                            new MsgDialog((IActivator)ImportPlugin.getDefault()).displayError(title, msg);
                        }
                    });
                    return;
                }
                if (unlockedPlugins.size() > 0) {
                    this.lockUnlockedPlugins(unlockedPlugins);
                    LibraryService.getInstance().saveCurrentMethodLibrary();
                    LibraryService.getInstance().reopenCurrentMethodLibrary();
                }
                MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
                ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
                return;
            }
            if (this.importEntries(this.targetLibDoc)) {
                this.targetLibDoc.save();
                this.fixLibraryGuid(libFile.getParentFile(), this.importingLibDoc.getLibraryGuid(), this.targetLibDoc.getLibraryGuid());
                LibraryService.getInstance().reopenCurrentMethodLibrary();
                if (unlockedPlugins.size() > 0) {
                    this.lockUnlockedPlugins(unlockedPlugins);
                    LibraryService.getInstance().saveCurrentMethodLibrary();
                }
            }
            LibraryService.getInstance().reopenCurrentMethodLibrary();
            MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
            ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private List unlockPlugins() {
        ArrayList<String> pluginIds = new ArrayList<String>();
        HashMap<String, MethodPlugin> map = new HashMap<String, MethodPlugin>();
        List basePlugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        int i = 0;
        while (i < basePlugins.size()) {
            MethodPlugin plugin = (MethodPlugin)basePlugins.get(i);
            map.put(plugin.getName(), plugin);
            ++i;
        }
        ArrayList<MethodPlugin> possibleExtraUnlockPlugins = new ArrayList<MethodPlugin>();
        for (PluginImportData.PluginInfo info : this.data.getPlugins()) {
            MethodPlugin basePlugin;
            if (info.existingPlugin != null && info.selected && !info.existingPlugin.getUserChangeable().booleanValue()) {
                info.existingPlugin.setUserChangeable(new Boolean(true));
                pluginIds.add(info.existingPlugin.getGuid());
            }
            if (!info.selected || (basePlugin = (MethodPlugin)map.get(info.name)) == null || basePlugin.getGuid().equals(info.guid) || basePlugin.getUserChangeable().booleanValue()) continue;
            possibleExtraUnlockPlugins.add(basePlugin);
        }
        this.handleExtraUnlockPlugins(pluginIds, possibleExtraUnlockPlugins);
        return pluginIds;
    }

    private void handleExtraUnlockPlugins(List pluginIds, List<MethodPlugin> possibleExtraUnlockPlugins) {
        if (possibleExtraUnlockPlugins == null || possibleExtraUnlockPlugins.isEmpty()) {
            return;
        }
        ArrayList<String> fileNameToCheck = new ArrayList<String>();
        int i = 0;
        while (i < possibleExtraUnlockPlugins.size()) {
            MethodPlugin plugin = possibleExtraUnlockPlugins.get(i);
            String guid = plugin.getGuid();
            if (!pluginIds.contains(guid)) {
                plugin.setUserChangeable(new Boolean(true));
                pluginIds.add(guid);
                Resource res = plugin.eResource();
                if (res != null && res.getURI() != null) {
                    String fileName = res.getURI().toFileString();
                    fileNameToCheck.add(fileName);
                }
            }
            ++i;
        }
        if (fileNameToCheck.size() > 0) {
            final ArrayList<String> modifiedFiles = fileNameToCheck;
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    PluginImportingService.this.fileCheckedOutStatus = FileModifyChecker.checkModify(modifiedFiles);
                }
            });
        }
    }

    private void lockUnlockedPlugins(List unlockedPlugins) {
        List plugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        for (MethodPlugin plugin : plugins) {
            if (!unlockedPlugins.contains(plugin.getGuid())) continue;
            plugin.setUserChangeable(new Boolean(false));
        }
    }

    private boolean importEntries(LibraryDocument targetLibDoc) {
        ArrayList<String> importList = new ArrayList<String>();
        ArrayList<String> newList = new ArrayList<String>();
        for (PluginImportData.PluginInfo info : this.data.getPlugins()) {
            if (!info.selected) continue;
            if (info.existingPlugin == null) {
                newList.add(info.guid);
            }
            importList.add(info.guid);
        }
        for (PluginImportData.ConfiguarationInfo cinfo : this.data.getConfigs()) {
            if (!cinfo.selected) continue;
            if (cinfo.existingConfig == null) {
                newList.add(cinfo.guid);
            }
            importList.add(cinfo.guid);
        }
        if (!newMergeScheme) {
            this.importLibEntries(targetLibDoc, newList);
        } else {
            MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
            this.ensureUniqueNames(lib.getMethodPlugins());
            this.ensureUniqueNames(lib.getPredefinedConfigurations());
        }
        return this.copyFiles(targetLibDoc, importList, newList);
    }

    private void importLibEntries(LibraryDocument targetLibDoc, List newList) {
        String guid;
        Element node;
        if (newList == null || newList.size() == 0) {
            return;
        }
        NodeList nodes = this.importingLibDoc.getPlugins();
        int i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getGuid((Element)node);
            if (newList.contains(guid)) {
                targetLibDoc.addPlugin(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getConfigurations();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getGuid((Element)node);
            if (newList.contains(guid)) {
                targetLibDoc.addConfiguration(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getResourceDescriptors();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = node.getAttribute("id");
            if (newList.contains(guid)) {
                targetLibDoc.addResource(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getResourceSubManagers();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getSubManagerBaseGuid((String)node.getAttribute("href"));
            if (newList.contains(guid)) {
                targetLibDoc.addResource(node);
            }
            ++i;
        }
    }

    private boolean copyFiles(LibraryDocument targetLibDoc, List importList, List newList) {
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        for (String guid : importList) {
            String src_uri = this.importingLibDoc.getResourceUri(guid);
            if (src_uri == null || src_uri.length() == 0) continue;
            final File src_file = this.importingLibDoc.getFileFromUri(src_uri);
            if (!src_file.exists()) continue;
            final File target_file = this.getTargetFile(lib, guid);
            if (target_file == null) {
                return false;
            }
            this.targetFileMap.put(guid, target_file);
            if (this.data.getPluginInfo(guid) != null) {
                if (target_file.exists()) {
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            DirCopy copy = new DirCopy(src_file.getParentFile(), target_file.getParentFile());
                            PluginImportingService.this.fileCheckedOutStatus = copy.execute();
                        }
                    });
                } else {
                    PluginImportingService.copyDir(src_file.getParentFile(), target_file.getParentFile());
                }
            } else if (this.data.getConfigInfo(guid) != null && DirCopy.needCopy(src_file, target_file)) {
                final ArrayList<String> files = new ArrayList<String>();
                if (target_file.exists()) {
                    files.add(target_file.getAbsolutePath());
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            PluginImportingService.this.fileCheckedOutStatus = FileModifyChecker.checkModify(files);
                        }
                    });
                }
                if (this.fileCheckedOutStatus == null || this.fileCheckedOutStatus.isOK()) {
                    FileUtil.copyFile((File)src_file, (File)target_file);
                }
            }
            if (this.fileCheckedOutStatus == null || this.fileCheckedOutStatus.isOK()) continue;
            this.displayCheckOutError();
            return false;
        }
        return true;
    }

    private void displayCheckOutError() {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String title = ImportResources.importPluginsWizard_title;
                String msg = ImportResources.importPluginsWizard_ERR_Import_plugin;
                new MsgDialog((IActivator)ImportPlugin.getDefault()).displayError(title, msg, PluginImportingService.this.fileCheckedOutStatus);
            }
        });
    }

    public static void copyDir(File fromDir, File toDir) {
        Copy cp = new Copy();
        cp.setOverwrite(true);
        FileSet set = new FileSet();
        set.setExcludes(ConfigurationExportService.excludes);
        set.setDir(fromDir);
        cp.addFileset(set);
        cp.setTodir(toDir);
        cp.setProject(new Project());
        cp.execute();
    }

    public String validateSelection() {
        if (!this.isCheckBasePlugins()) {
            return null;
        }
        this.data.getErrorInfo().clear();
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        List plugins = library == null ? new ArrayList() : library.getMethodPlugins();
        HashMap<String, MethodPlugin> pluginids = new HashMap<String, MethodPlugin>();
        for (MethodPlugin plugin : plugins) {
            pluginids.put(plugin.getGuid(), plugin);
        }
        HashSet basePlugins = new HashSet();
        HashSet<String> newPlugins = new HashSet<String>();
        for (PluginImportData.PluginInfo info : this.data.getPlugins()) {
            if (!info.selected) continue;
            newPlugins.add(info.guid);
            for (Object base : info.usedPlugins) {
                if (basePlugins.contains(base)) continue;
                basePlugins.add(base);
            }
        }
        if (newPlugins.size() > 0) {
            for (String guid : basePlugins) {
                String message;
                String uri = (String)this.data.basePluginUrlMap.get(guid);
                if (newPlugins.contains(guid) || pluginids.containsKey(guid)) continue;
                if (uri != null && uri.length() > 0) {
                    message = NLS.bind((String)ImportResources.PluginImportingService_MSG5, (Object)uri);
                } else {
                    Map guidToPlugNameMap = this.importingLibDoc.getGuidToPlugNameMap();
                    String pluginName = guidToPlugNameMap == null ? null : (String)guidToPlugNameMap.get(guid);
                    message = pluginName == null || pluginName.length() == 0 ? NLS.bind((String)ImportResources.PluginImportingService_MSG5, (Object)guid) : NLS.bind((String)ImportResources.PluginImportingService_MSG5, (Object)(String.valueOf(pluginName) + ", " + guid));
                }
                this.data.getErrorInfo().addError(message);
                if (uri == null || uri.length() == 0) break;
            }
        }
        return this.data.getErrorInfo().getError();
    }

    private void scanLibraryFile(LibraryDocument document) {
        this.visitLibTag(document);
        this.visitResourceTag(document);
        this.data.validatePlugins();
        for (PluginImportData.PluginInfo info : this.data.getPlugins()) {
            if (info.existingPlugin != null) continue;
            for (String guid : info.usedPlugins) {
                if (this.data.basePluginUrlMap.containsKey(guid)) continue;
                this.data.basePluginUrlMap.put(guid, "");
            }
        }
        if (this.data.getPlugins().size() > 1) {
            Comparator<PluginImportData.PluginInfo> comparator = new Comparator<PluginImportData.PluginInfo>(){

                @Override
                public int compare(PluginImportData.PluginInfo o1, PluginImportData.PluginInfo o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    Collator collator = Collator.getInstance();
                    return collator.compare(o1.name, o2.name);
                }
            };
            Collections.sort(this.data.getPlugins(), comparator);
        }
    }

    private void visitLibTag(LibraryDocument document) {
        NodeList nodes = document.getPlugins();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            PluginImportData.PluginInfo pi = this.data.new PluginImportData.PluginInfo();
            pi.guid = LibraryDocument.getGuid((Element)node);
            this.data.getPlugins().add(pi);
            this.loadExistingPluginInfo(pi);
            ++i;
        }
        this.buildConfigInfoFromFiles();
    }

    private void visitResourceTag(LibraryDocument document) {
        NodeList nodes = document.getResourceDescriptors();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            String guid = node.getAttribute("id");
            String uri = node.getAttribute("uri");
            File file = document.getFileFromUri(uri);
            PluginImportData.PluginInfo pi = this.data.getPluginInfo(guid);
            if (pi != null) {
                if (file.exists()) {
                    this.loadPluginInfo(file, pi);
                } else {
                    this.data.removePluginInfo(guid);
                }
            } else {
                PluginImportData.ConfiguarationInfo ci = this.data.getConfigInfo(guid);
                if (ci != null && file.exists()) {
                    this.loadConfigInfo(file, ci);
                }
            }
            ++i;
        }
    }

    protected void loadConfigInfo(File source, PluginImportData.ConfiguarationInfo info) {
        try {
            Document document = XMLUtil.loadXml((File)source);
            Element root = document.getDocumentElement();
            Element configTag = null;
            if (root.getTagName().equals("org.eclipse.epf.uma:MethodConfiguration")) {
                configTag = root;
            } else {
                NodeList nodes = root.getElementsByTagName("org.eclipse.epf.uma:MethodConfiguration");
                if (nodes.getLength() > 0) {
                    configTag = (Element)nodes.item(0);
                }
            }
            if (configTag != null) {
                info.name = configTag.getAttribute("name");
            }
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    protected void loadPluginInfo(File source, PluginImportData.PluginInfo info) {
        try {
            NodeList nodes;
            Document document = XMLUtil.loadXml((File)source);
            Element root = document.getDocumentElement();
            Element pluginTag = null;
            if (root.getTagName().equals("org.eclipse.epf.uma:MethodPlugin")) {
                pluginTag = root;
            } else {
                nodes = root.getElementsByTagName("org.eclipse.epf.uma:MethodPlugin");
                if (nodes.getLength() > 0) {
                    pluginTag = (Element)nodes.item(0);
                }
            }
            if (pluginTag != null) {
                info.name = pluginTag.getAttribute("name");
                info.version = LibraryDocument.getChildValue((Element)pluginTag, (String)"version");
                info.brief_desc = LibraryDocument.getChildValue((Element)pluginTag, (String)"briefDescription");
                info.authors = LibraryDocument.getChildValue((Element)pluginTag, (String)"authors");
                info.changeDate = LibraryDocument.getChildValue((Element)pluginTag, (String)"changeDate");
                info.url = source.toString();
                nodes = pluginTag.getElementsByTagName("bases");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element node = (Element)nodes.item(i);
                    String guid = node.getAttribute("href");
                    int indx = guid.indexOf("#");
                    if (indx > 0) {
                        guid = guid.substring(indx + 1);
                    } else {
                        indx = guid.indexOf("uma://");
                        if (indx >= 0) {
                            guid = guid.substring(indx + 6);
                        }
                    }
                    info.usedPlugins.add(guid);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private void loadExistingPluginInfo(PluginImportData.PluginInfo info) {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        List plugins = library == null ? new ArrayList() : library.getMethodPlugins();
        for (MethodPlugin plugin : plugins) {
            if (!plugin.getGuid().equals(info.guid)) continue;
            info.existingPlugin = plugin;
        }
    }

    private void loadExistingConfigInfo(PluginImportData.ConfiguarationInfo info) {
        MethodConfiguration[] configs = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        if (configs == null || configs.length == 0) {
            return;
        }
        int i = 0;
        while (i < configs.length) {
            MethodConfiguration config = configs[i];
            if (config.getGuid().equals(info.guid)) {
                info.existingConfig = config;
            }
            ++i;
        }
    }

    private void fixLibraryGuid(File path, String oldGuid, String newGuid) {
        if (!path.isDirectory()) {
            return;
        }
        File[] files = path.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.equals("library.xmi") || name.equals("plugin.xmi") || name.equals("model.xmi");
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.fixLibraryGuid(files[i], oldGuid, newGuid);
            } else {
                try {
                    String source = FileUtil.readFile((File)files[i], (String)"UTF-8").toString();
                    if (source.indexOf(oldGuid) >= 0) {
                        source = source.replaceAll(oldGuid, newGuid);
                        FileUtil.writeUTF8File((String)files[i].getAbsolutePath(), (String)source);
                    }
                }
                catch (IOException e) {
                    ImportPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    private boolean merge(LibraryDocument targetLibDoc) throws Exception {
        if (!this.importEntries(targetLibDoc)) {
            return false;
        }
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        Resource res0 = lib.eResource();
        ResourceManager resMgr0 = MultiFileSaveUtil.getResourceManager((Resource)res0);
        ResourceSet resSet = res0.getResourceSet();
        this.mergePlugins(targetLibDoc, lib, resMgr0, resSet);
        this.mergeConfigs(targetLibDoc, lib, resMgr0, resSet);
        lib.eResource().setModified(true);
        this.save(lib, null);
        LibraryService.getInstance().reopenCurrentMethodLibrary();
        if (!this.isCheckBasePlugins()) {
            lib = LibraryService.getInstance().getCurrentMethodLibrary();
            LibraryUtil.loadAll((MethodLibrary)lib);
            List<MethodPlugin> missingBasePlugins = this.collectMissingBasePlugins(lib);
            List configs = lib.getPredefinedConfigurations();
            this.checkModify(configs);
            if (!missingBasePlugins.isEmpty() || !configs.isEmpty()) {
                lib.eResource().setModified(true);
                LinkedHashSet<Resource> resouresToSave = new LinkedHashSet<Resource>();
                this.collectResourcestoSave(resouresToSave, missingBasePlugins);
                this.collectResourcestoSave(resouresToSave, configs);
                this.save(lib, resouresToSave);
                LibraryService.getInstance().reopenCurrentMethodLibrary();
            }
        }
        return true;
    }

    private void checkModify(List<MethodConfiguration> configs) {
        if (configs == null) {
            return;
        }
        final ArrayList<String> configFiles = new ArrayList<String>();
        int i = 0;
        while (i < configs.size()) {
            MethodConfiguration config = configs.get(i);
            Resource res = config.eResource();
            if (res != null) {
                String file = res.getURI().toFileString();
                configFiles.add(file);
            }
            ++i;
        }
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                PluginImportingService.this.fileCheckedOutStatus = FileModifyChecker.checkModify(configFiles);
            }
        });
    }

    private List<MethodPlugin> collectMissingBasePlugins(MethodLibrary lib) {
        ArrayList<MethodPlugin> ret = new ArrayList<MethodPlugin>();
        Map map = MethodElementUtil.buildMap((Collection)lib.getMethodPlugins());
        block0: for (PluginImportData.PluginInfo info : this.data.getPlugins()) {
            MethodPlugin plugin;
            if (!info.selected || (plugin = (MethodPlugin)map.get(info.guid)) == null) continue;
            List bases = plugin.getBases();
            int i = 0;
            while (i < bases.size()) {
                MethodPlugin base = (MethodPlugin)bases.get(i);
                if (!map.containsKey(base.getGuid())) {
                    ret.add(plugin);
                    continue block0;
                }
                ++i;
            }
        }
        return ret;
    }

    private void collectResourcestoSave(Set<Resource> resources, List<? extends MethodElement> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < elements.size()) {
            this.collectResourcestoSave(resources, elements.get(i));
            ++i;
        }
    }

    private void collectResourcestoSave(Set<Resource> resources, MethodElement parent) {
        if (parent instanceof MethodPlugin) {
            TreeIterator it = parent.eAllContents();
            while (it.hasNext()) {
                Resource res;
                EObject element = (EObject)it.next();
                if (element instanceof ContentDescription || (res = element.eResource()) == null) continue;
                resources.add(res);
                res.setModified(true);
            }
        }
        Resource res = parent.eResource();
        resources.add(res);
        res.setModified(true);
    }

    private void save(ILibraryPersister.FailSafeMethodLibraryPersister persister, Set<Resource> resouresToSave) throws Exception {
        if (resouresToSave == null) {
            return;
        }
        for (MultiFileXMIResourceImpl multiFileXMIResourceImpl : resouresToSave) {
            try {
                if (!multiFileXMIResourceImpl.isSynchronized()) {
                    multiFileXMIResourceImpl.load(multiFileXMIResourceImpl.getResourceSet().getLoadOptions());
                }
                persister.save((Resource)multiFileXMIResourceImpl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void save(MethodLibrary lib, Set<Resource> resouresToSave) {
        block10: {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)lib.eResource().getResourceSet();
            Map defaultSaveOptions = resourceSet.getDefaultSaveOptions();
            Object oldDefaultOptionVal = defaultSaveOptions.get("DISCARD_UNRESOLVED_REFERENCES");
            ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            Map saveOptions = persister.getSaveOptions();
            if (!this.isCheckBasePlugins() && resouresToSave != null) {
                saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", Boolean.TRUE);
                defaultSaveOptions.put("DISCARD_UNRESOLVED_REFERENCES", Boolean.TRUE);
            }
            try {
                try {
                    this.save(persister, resouresToSave);
                    persister.save(lib.eResource());
                    persister.commit();
                }
                catch (Exception e) {
                    persister.rollback();
                    e.printStackTrace();
                    if (this.isCheckBasePlugins() || resouresToSave == null) break block10;
                    if (oldDefaultOptionVal == null) {
                        defaultSaveOptions.remove("DISCARD_UNRESOLVED_REFERENCES");
                        break block10;
                    }
                    defaultSaveOptions.put("DISCARD_UNRESOLVED_REFERENCES", oldDefaultOptionVal);
                }
            }
            finally {
                if (!this.isCheckBasePlugins() && resouresToSave != null) {
                    if (oldDefaultOptionVal == null) {
                        defaultSaveOptions.remove("DISCARD_UNRESOLVED_REFERENCES");
                    } else {
                        defaultSaveOptions.put("DISCARD_UNRESOLVED_REFERENCES", oldDefaultOptionVal);
                    }
                }
            }
        }
    }

    private void mergePlugins(LibraryDocument targetLibDoc, MethodLibrary lib, ResourceManager resMgr0, ResourceSet resSet) {
        ArrayList<String> existingPluginGuids = null;
        for (PluginImportData.PluginInfo info : this.data.getPlugins()) {
            if (!info.selected || info.existingPlugin == null) continue;
            if (existingPluginGuids == null) {
                existingPluginGuids = new ArrayList<String>();
            }
            existingPluginGuids.add(info.guid);
        }
        Map pgToRgMap = this.importingLibDoc.buildPluginGuidToResMgrGuidMap(existingPluginGuids);
        for (PluginImportData.PluginInfo info : this.data.getPlugins()) {
            if (info.selected && info.existingPlugin == null) {
                this.mergeElement(info.guid, targetLibDoc, lib, resMgr0, resSet, lib.getMethodPlugins());
                continue;
            }
            if (!info.selected || pgToRgMap == null) continue;
            Resource res = info.existingPlugin.eResource();
            ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)res);
            String existingGuid = resMgr.getGuid();
            String importedGuid = (String)pgToRgMap.get(info.guid);
            if (importedGuid == null || importedGuid.equals(existingGuid)) continue;
            resMgr.setGuid(importedGuid);
        }
    }

    private void mergeConfigs(LibraryDocument targetLibDoc, MethodLibrary lib, ResourceManager resMgr0, ResourceSet resSet) {
        for (PluginImportData.ConfiguarationInfo info : this.data.getConfigs()) {
            if (!info.selected || info.existingConfig != null) continue;
            this.mergeElement(info.guid, targetLibDoc, lib, resMgr0, resSet, lib.getPredefinedConfigurations());
        }
    }

    private void mergeElement(String guid, LibraryDocument targetLibDoc, MethodLibrary lib, ResourceManager resMgr0, ResourceSet resSet, List elements) {
        String src_uri = this.importingLibDoc.getResourceUri(guid);
        if (src_uri == null || src_uri.length() == 0) {
            return;
        }
        File target_file = this.targetFileMap.get(guid);
        String path = target_file.getAbsolutePath();
        URI uri = URI.createFileURI((String)path);
        Resource res = resSet.getResource(uri, true);
        MethodElement element = PersistenceUtil.getMethodElement((Resource)res);
        elements.add(element);
        MultiFileSaveUtil.registerWithResourceManager((ResourceManager)resMgr0, (Object)element, (URI)uri);
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)res);
        if (resMgr != null) {
            resMgr0.getSubManagers().add(resMgr);
        }
    }

    private void buildConfigInfoFromFiles() {
        File copiedLibPath = this.upGradeInfo == null ? null : this.upGradeInfo.getCopiedLibFile();
        File importingLibPath = copiedLibPath == null ? new File(String.valueOf(this.data.llData.getParentFolder()) + File.separator + "export.xmi") : copiedLibPath;
        File configDir = new File(importingLibPath.getParent(), "configurations");
        LibraryDocument.ConfigDocVisitor visitor = new LibraryDocument.ConfigDocVisitor(){

            public void visit(File file, Element node) {
                PluginImportData.ConfiguarationInfo ci = PluginImportingService.this.data.new PluginImportData.ConfiguarationInfo();
                ci.guid = node.getAttribute("guid");
                ci.name = node.getAttribute("name");
                String uri = "configurations" + File.separator + file.getName();
                PluginImportingService.this.importingLibDoc.addToGuidToUriMap(ci.guid, uri);
                PluginImportingService.this.data.getConfigs().add(ci);
                PluginImportingService.this.loadExistingConfigInfo(ci);
                if (ci.existingConfig != null) {
                    URI resUri = ci.existingConfig.eResource().getURI();
                    uri = "configurations" + File.separator + resUri.lastSegment();
                    uri = PluginImportingService.this.targetLibDoc.decodeUri(uri);
                    PluginImportingService.this.targetLibDoc.addToGuidToUriMap(ci.guid, uri);
                }
            }
        };
        LibraryDocument.visitConfigFiles((File)configDir, (LibraryDocument.ConfigDocVisitor)visitor);
    }

    private void ensureUniqueNames(List elements) {
        if (elements.isEmpty()) {
            return;
        }
        HashMap<String, MethodElement> nameMap = new HashMap<String, MethodElement>();
        int i = 0;
        while (i < elements.size()) {
            MethodElement elem = (MethodElement)elements.get(i);
            nameMap.put(elem.getName().toUpperCase(), elem);
            ++i;
        }
        ArrayList<String> importedList = new ArrayList<String>();
        ArrayList<Object> importedExistList = new ArrayList<Object>();
        if (elements.get(0) instanceof MethodPlugin) {
            for (PluginImportData.PluginInfo pluginInfo : this.data.getPlugins()) {
                if (!pluginInfo.selected || pluginInfo.existingPlugin != null && pluginInfo.existingPlugin.getName().equals(pluginInfo.name)) continue;
                importedList.add(pluginInfo.name);
                if (pluginInfo.existingPlugin == null) continue;
                importedExistList.add(pluginInfo);
            }
        } else {
            for (PluginImportData.ConfiguarationInfo configuarationInfo : this.data.getConfigs()) {
                if (!configuarationInfo.selected || configuarationInfo.existingConfig != null && configuarationInfo.existingConfig.getName().equals(configuarationInfo.name)) continue;
                importedList.add(configuarationInfo.name);
                if (configuarationInfo.existingConfig == null) continue;
                importedExistList.add(configuarationInfo);
            }
        }
        int i2 = 0;
        while (i2 < importedList.size()) {
            String string;
            String renamed = string = (String)importedList.get(i2);
            while (nameMap.containsKey(renamed.toUpperCase())) {
                renamed = String.valueOf(renamed) + "_renamed";
            }
            if (renamed != string) {
                MethodElement elem = (MethodElement)nameMap.get(string.toUpperCase());
                LibraryView.runRename((NamedElement)elem, (String)renamed);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < importedExistList.size()) {
            Object e = importedExistList.get(i3);
            MethodPlugin elem = e instanceof PluginImportData.PluginInfo ? ((PluginImportData.PluginInfo)e).existingPlugin : ((PluginImportData.ConfiguarationInfo)e).existingConfig;
            String newName = e instanceof PluginImportData.PluginInfo ? ((PluginImportData.PluginInfo)e).name : ((PluginImportData.ConfiguarationInfo)e).name;
            LibraryView.runRename((NamedElement)elem, (String)newName);
            ++i3;
        }
    }

    private File getTargetFile(final MethodLibrary lib, String guid) {
        File parent = null;
        final File[] pfiles = new File[1];
        final IFileBasedLibraryPersister persister = (IFileBasedLibraryPersister)LibraryServiceUtil.getCurrentPersister();
        PluginImportData.ConfiguarationInfo cinfo = this.data.getConfigInfo(guid);
        if (cinfo != null) {
            File file = this.getResourceFile((MethodElement)cinfo.existingConfig);
            if (file != null) {
                return file;
            }
            if (this.defaultConfigFolder == null) {
                SafeUpdateController.syncExec((Runnable)new Runnable(){

                    public void run() {
                        pfiles[0] = persister.getDefaultMethodConfigurationFolder(lib);
                    }
                });
                parent = pfiles[0];
                if (parent == null) {
                    return null;
                }
                this.defaultConfigFolder = parent;
            } else {
                parent = this.defaultConfigFolder;
            }
            if (localDebug) {
                System.out.println("LD> defaultConfigFolder: " + parent);
            }
        } else {
            PluginImportData.PluginInfo pinfo = this.data.getPluginInfo(guid);
            if (pinfo != null) {
                File file = this.getResourceFile((MethodElement)pinfo.existingPlugin);
                if (file != null) {
                    return file;
                }
                parent = persister.createMethodPluginFolder(pinfo.name, lib);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        String fileName = cinfo == null ? "plugin.xmi" : String.valueOf(cinfo.name) + ".xmi";
        return new File(parent, fileName);
    }

    public boolean isCheckBasePlugins() {
        return this.checkBasePlugins;
    }

    public void setCheckBasePlugins(boolean checkBasePlugins) {
        this.checkBasePlugins = checkBasePlugins;
    }

    private File getResourceFile(MethodElement element) {
        if (element == null) {
            return null;
        }
        Resource res = element.eResource();
        URI uri = res.getURI();
        return new File(uri.toFileString());
    }

    public Object getValidateHookData() {
        return this.validateHookData;
    }

    public void setValidateHookData(Object validateHookData) {
        this.validateHookData = validateHookData;
    }
}

