/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.FeatureValue;
import org.eclipse.epf.library.configuration.ToManyFeatureValue;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.FulfillableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementRealizer {
    protected MethodConfiguration config;
    private boolean discardContributor = false;
    private boolean resolveContributor = true;
    private boolean resolveReplacer = true;
    private boolean showSubtracted = false;
    protected IFilter filter = null;
    private static boolean defaultEnableExtendReplace = false;

    static {
        String str = LibraryPlugin.getDefault().getString("EnableExtendReplace");
        if (str != null && str.trim().equals("true")) {
            defaultEnableExtendReplace = true;
        }
    }

    public ElementRealizer(MethodConfiguration config) {
        this(config, true, true);
    }

    public ElementRealizer(MethodConfiguration config, boolean resolveContributor, boolean resolveReplacer) {
        this.config = config;
        this.resolveContributor = resolveContributor;
        this.resolveReplacer = resolveReplacer;
    }

    public static boolean isExtendReplaceEnabled() {
        return defaultEnableExtendReplace;
    }

    public static boolean ignoreBaseToManyAssociations() {
        return BrowsingLayoutSettings.INSTANCE.isUseNewExtendSemantics();
    }

    public void setDiscardContributor(boolean discardContributor) {
        this.discardContributor = discardContributor;
    }

    public void setResolveContributor(boolean resolveContributor) {
        this.resolveContributor = resolveContributor;
    }

    public void setResolveReplacer(boolean resolveReplacer) {
        this.resolveReplacer = resolveReplacer;
    }

    public boolean showSubtracted() {
        return this.showSubtracted;
    }

    public void setShowSubtracted(boolean flag) {
        this.showSubtracted = flag;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    public MethodElement realize(MethodElement element) {
        if (element == null || !this.inConfig(element)) {
            return null;
        }
        Task linkedElement = null;
        if (element instanceof TaskDescriptor) {
            linkedElement = ((TaskDescriptor)element).getTask();
        } else if (element instanceof WorkProductDescriptor) {
            linkedElement = ((WorkProductDescriptor)element).getWorkProduct();
        } else if (element instanceof RoleDescriptor) {
            linkedElement = ((RoleDescriptor)element).getRole();
        }
        if (linkedElement != null && !this.inConfig((MethodElement)linkedElement)) {
            return null;
        }
        if (this.config == null) {
            return element;
        }
        if (element instanceof VariabilityElement) {
            VariabilityElement e;
            VariabilityElement ve = (VariabilityElement)element;
            if (this.discardContributor && ConfigurationHelper.isContributor(ve)) {
                return null;
            }
            if (this.resolveContributor) {
                while (ConfigurationHelper.isContributor(ve)) {
                    e = ve.getVariabilityBasedOnElement();
                    if (this.inConfig((MethodElement)e)) {
                        ve = e;
                        continue;
                    }
                    System.out.println("Configuration closure error: Base element '" + LibraryUtil.getTypeName((MethodElement)ve) + "' not in configuration");
                    break;
                }
            }
            if (this.resolveReplacer) {
                e = ConfigurationHelper.getReplacer(ve, this.config);
                if (e != null) {
                    return e;
                }
            } else if (!this.inConfig((MethodElement)ve)) {
                return null;
            }
            e = ve;
            while (e != null && ConfigurationHelper.isReplacer(e)) {
                if (!ConfigurationHelper.isContributor(e = e.getVariabilityBasedOnElement())) continue;
                return this.realize((MethodElement)e);
            }
            if (this.canShow((MethodElement)ve)) {
                return ve;
            }
            return null;
        }
        if (this.canShow(element)) {
            return element;
        }
        return null;
    }

    public abstract List realize(MethodElement var1, EStructuralFeature var2, List var3);

    public boolean inConfig(MethodElement element) {
        return ConfigurationHelper.inConfig(element, this.config, !this.showSubtracted());
    }

    public boolean canShow(MethodElement element) {
        return ConfigurationHelper.canShow(element, this.config, !this.showSubtracted());
    }

    public void dispose() {
        this.filter = null;
    }

    protected void addExtraFeatureValues(MethodElement element, EStructuralFeature feature, FeatureValue values) {
        if (!ElementRealizer.toAddExtraFeatureValues(element, feature, values, this.getConfiguration())) {
            return;
        }
        CustomCategory cc = (CustomCategory)element;
        List<DescribableElement> result = LibraryUtil.getIncludedElements(cc, this.getConfiguration());
        if (result == null || result.isEmpty()) {
            return;
        }
        ToManyFeatureValue manyValues = values instanceof ToManyFeatureValue ? (ToManyFeatureValue)values : null;
        List oldValues = manyValues == null ? null : (List)manyValues.getValue();
        HashSet<DescribableElement> seenSet = manyValues == null ? new HashSet<DescribableElement>() : new HashSet(oldValues);
        seenSet.add((DescribableElement)cc);
        List ccList = AssociationHelper.getCustomCategories((DescribableElement)cc);
        seenSet.addAll(ccList);
        List<DescribableElement> list = this.calculateList(result, seenSet);
        values.add((VariabilityElement)cc, list);
    }

    public List<DescribableElement> calculateList(Collection<?> result, Set<DescribableElement> seenSet) {
        ArrayList<DescribableElement> list = new ArrayList<DescribableElement>();
        for (Object o : result) {
            if (!(o instanceof DescribableElement)) continue;
            DescribableElement contElem = (DescribableElement)o;
            if ((contElem = (DescribableElement)ConfigurationHelper.getCalculatedElement((MethodElement)contElem, this)) == null || !seenSet.add(contElem)) continue;
            list.add(contElem);
        }
        if (list.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getPresNameComparator();
            Collections.sort(list, comparator);
        }
        return list;
    }

    protected boolean slotMatching(FulfillableElement slot, FulfillableElement element) {
        return true;
    }

    protected static boolean toAddExtraFeatureValues(MethodElement element, EStructuralFeature feature, FeatureValue values, MethodConfiguration config) {
        if (config == null) {
            return false;
        }
        if (!(values instanceof ToManyFeatureValue)) {
            return false;
        }
        if (!(element instanceof CustomCategory)) {
            return false;
        }
        return feature == UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
    }
}

