/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigDataBase;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.ElementReference;
import org.eclipse.epf.library.edit.util.DebugUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportingElementData
extends ConfigDataBase {
    private Set<MethodElement> supportingElements;
    private boolean duringUpdateSupporitngElements = false;
    private Set<MethodPlugin> supportingPlugins;
    private Set<MethodPackage> selectedPackages;
    private static boolean localDebug = false;
    private static boolean localDebug1 = false;
    private boolean enabled = true;
    public static boolean descriptorExclusiveOption = true;

    public SupportingElementData(MethodConfiguration config) {
        super(config);
    }

    private boolean determineEnable() {
        this.supportingPlugins = new HashSet<MethodPlugin>();
        HashSet plugins = new HashSet(this.getConfig().getMethodPluginSelection());
        for (MethodPlugin plugin : plugins) {
            if (!plugin.isSupporting()) continue;
            this.supportingPlugins.add(plugin);
        }
        this.setEnabled(this.supportingPlugins.size() < plugins.size());
        return this.isEnabled();
    }

    public void beginUpdateSupportingElements() {
        this.setUpdatingChanges(true);
        if (localDebug) {
            System.out.println("LD> beginUpdateSupportingElements -> ");
        }
        this.supportingElements = new HashSet<MethodElement>();
        this.determineEnable();
        this.selectedPackages = new HashSet<MethodPackage>();
        if (this.isEnabled() && !this.supportingPlugins.isEmpty()) {
            List packages = this.getConfig().getMethodPackageSelection();
            for (MethodPackage pkg : packages) {
                MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)pkg);
                if (!this.supportingPlugins.contains(plugin)) continue;
                this.selectedPackages.add(pkg);
            }
        }
        if (localDebug) {
            System.out.println("LD> isEnabled(): " + this.isEnabled());
            System.out.println("LD> supportingPlugins: " + this.supportingPlugins.size());
            System.out.println("LD> selectedPackages: " + this.selectedPackages.size());
            System.out.println("LD> beginUpdateSupportingElements <- ");
            System.out.println("");
        }
    }

    public void endUpdateSupportingElements(Map<String, ElementReference> outConfigRefMap) {
        if (localDebug) {
            System.out.println("LD> endUpdateSupportingElements -> ");
        }
        if (this.isEnabled()) {
            HashSet<MethodElement> supportingElementsToCollect = new HashSet<MethodElement>(this.supportingElements);
            while (!supportingElementsToCollect.isEmpty()) {
                HashSet<MethodElement> newSupportingElements = new HashSet<MethodElement>();
                this.processReferencesOutsideConfig(supportingElementsToCollect, outConfigRefMap, newSupportingElements);
                if (localDebug) {
                    System.out.println("LD> newSupportingElements: " + newSupportingElements.size());
                }
                supportingElementsToCollect = newSupportingElements;
            }
        }
        this.setUpdatingChanges(false);
        this.setNeedUpdateChanges(false);
        if (localDebug) {
            System.out.println("LD> supportingElements: " + this.supportingElements.size());
            System.out.println("LD> outConfigRefMap: " + outConfigRefMap.size());
            System.out.println("LD> endUpdateSupportingElements <- ");
            System.out.println("");
        }
    }

    private void processReferencesOutsideConfig(Collection<MethodElement> elements, Map<String, ElementReference> outConfigRefMap, Set<MethodElement> newSupportingElements) {
        for (MethodElement element : elements) {
            if (element instanceof ContentCategory) continue;
            this.processVariabilityChildren(element, newSupportingElements);
            this.processReferencesOutsideConfig(element, outConfigRefMap, newSupportingElements);
        }
    }

    private void processReferencesOutsideConfig(MethodElement element, Map<String, ElementReference> outConfigRefMap, Set<MethodElement> newSupportingElements) {
        IConfigurationManager configManager = LibraryService.getInstance().getConfigurationManager(this.getConfig());
        Set<VariabilityElement> replacerSet = null;
        if (configManager != null) {
            replacerSet = configManager.getDependencyManager().getReplacerSet();
        }
        List properties = LibraryUtil.getStructuralFeatures(element);
        for (EStructuralFeature f : properties) {
            Object value;
            EReference feature;
            if (!(f instanceof EReference) || (feature = (EReference)f).isContainer() || feature.isContainment() || (value = element.eGet((EStructuralFeature)feature)) == null) continue;
            ArrayList<Object> values = null;
            if (feature.isMany()) {
                values = (ArrayList<Object>)value;
            } else if (value instanceof MethodElement) {
                if (this.descriptorExclusiveCheck((MethodElement)value, element, (EStructuralFeature)feature)) continue;
                values = new ArrayList<Object>();
                values.add(value);
                if (replacerSet != null && feature == UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement()) {
                    VariabilityType variabilityType;
                    VariabilityElement ve = element instanceof VariabilityElement ? (VariabilityElement)element : null;
                    VariabilityType variabilityType2 = variabilityType = ve == null ? null : ve.getVariabilityType();
                    if (variabilityType == VariabilityType.EXTENDS_REPLACES || variabilityType == VariabilityType.REPLACES) {
                        replacerSet.add(ve);
                    }
                }
            }
            String guid = element.getGuid();
            for (Object e : values) {
                MethodElement referredElement;
                boolean isOutConfig;
                if (!(e instanceof MethodElement) || !(isOutConfig = this.checkOutConfigElement(referredElement = (MethodElement)e, element, newSupportingElements)) || outConfigRefMap == null) continue;
                String key = String.valueOf(guid) + referredElement.getGuid();
                ElementReference elementReference = outConfigRefMap.get(key);
                if (elementReference == null) {
                    elementReference = new ElementReference(element, referredElement);
                    outConfigRefMap.put(key, elementReference);
                }
                elementReference.addFeature((EStructuralFeature)feature);
            }
        }
    }

    private boolean descriptorExclusiveCheck(MethodElement referredElement, MethodElement referringElement, EStructuralFeature feature) {
        if (!descriptorExclusiveOption) {
            return false;
        }
        if (!(referringElement instanceof Descriptor)) {
            return false;
        }
        if (feature == UmaPackage.eINSTANCE.getTaskDescriptor_Task()) {
            return referredElement instanceof Task;
        }
        if (feature == UmaPackage.eINSTANCE.getRoleDescriptor_Role()) {
            return referredElement instanceof Role;
        }
        if (feature == UmaPackage.eINSTANCE.getWorkProductDescriptor_WorkProduct()) {
            return referredElement instanceof WorkProduct;
        }
        return false;
    }

    private boolean checkOutConfigElement(MethodElement referredElement, MethodElement referingElement, Set<MethodElement> newSupportingElements) {
        VariabilityElement replacer;
        if (referredElement instanceof MethodPackage || referredElement instanceof MethodConfiguration) {
            return false;
        }
        if (referredElement instanceof VariabilityElement && (replacer = ConfigurationHelper.getReplacer((VariabilityElement)referredElement, this.getConfig())) != null) {
            return false;
        }
        if (!this.supportingElements.contains(referingElement) && !ConfigurationHelper.inConfig(referingElement, this.getConfig(), true, false)) {
            return false;
        }
        return !ConfigurationHelper.inConfig(referredElement, this.getConfig()) && !this.isOwnerSelected(referredElement, newSupportingElements);
    }

    public int checkInConfigIndex(MethodElement element) {
        int ret = this.checkInConfigIndex_(element);
        if (localDebug1) {
            System.out.println("LD> isSE: " + ret + ", element: " + DebugUtil.toString((MethodElement)element, (int)2));
        }
        return ret;
    }

    private int checkInConfigIndex_(MethodElement element) {
        if (this.isUpdatingChanges()) {
            return 2;
        }
        if (this.isNeedUpdateChanges()) {
            this.updateChanges();
        }
        if (!this.isEnabled()) {
            return 0;
        }
        if (element instanceof ContentCategory) {
            return 1;
        }
        return this.supportingElements.contains(element) ? 1 : 2;
    }

    @Override
    protected void updateChangeImpl() {
        if (this.determineEnable()) {
            new ConfigurationClosure(null, this.getConfig());
        }
    }

    public boolean isSupportingElementCallDuringUpdating(ElementReference ref) {
        EStructuralFeature feature;
        if (!this.isEnabled()) {
            return false;
        }
        MethodElement referringElement = ref.getElement();
        MethodElement referredElement = ref.getRefElement();
        if (this.descriptorExclusiveCheck(referredElement, referringElement, feature = ref.getSingleFeature())) {
            return false;
        }
        return this.isOwnerSelected(referredElement, null);
    }

    private boolean isOwnerSelected(MethodElement element, Set<MethodElement> newSupportingElements) {
        return this.isOwnerSelected(element, newSupportingElements, true);
    }

    private boolean isOwnerSelected(MethodElement element, Set<MethodElement> newSupportingElements, boolean register) {
        if (!this.isUpdatingChanges()) {
            throw new UnsupportedOperationException();
        }
        if (this.supportingElements.contains(element)) {
            return true;
        }
        boolean ret = false;
        EObject selectable = LibraryUtil.getSelectable((EObject)element);
        if (selectable instanceof MethodPackage) {
            ret = this.selectedPackages.contains(selectable);
        } else if (selectable instanceof MethodPlugin) {
            ret = this.supportingPlugins.contains(selectable);
        } else if (selectable instanceof MethodLibrary) {
            ret = true;
        }
        if (!register) {
            return ret;
        }
        if (ret) {
            this.registerAsSupporting(element, newSupportingElements);
        }
        return ret;
    }

    private void registerAsSupporting(MethodElement element, Set<MethodElement> newSupportingElements) {
        this.supportingElements.add(element);
        EObject pkg = element.eContainer();
        while (pkg != null && pkg instanceof MethodPackage) {
            this.supportingElements.add((MethodElement)((MethodPackage)pkg));
            pkg = pkg.eContainer();
        }
        if (localDebug1) {
            System.out.println("LD> supportingElements added: " + DebugUtil.toString((MethodElement)element, (int)2));
        }
        if (newSupportingElements != null) {
            newSupportingElements.add(element);
        }
    }

    public boolean isSupportingSelectable(MethodElement element) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.selectedPackages.contains(element) || this.supportingPlugins.contains(element);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static synchronized boolean isDescriptorExclusiveOption() {
        return descriptorExclusiveOption;
    }

    public static synchronized void setDescriptorExclusiveOption(boolean descriptorExclusiveOption) {
        SupportingElementData.descriptorExclusiveOption = descriptorExclusiveOption;
    }

    public void processVariabilityChildren(MethodElement elementInConfig, Set<MethodElement> newSupportingElements) {
        if (!(elementInConfig instanceof VariabilityElement)) {
            return;
        }
        VariabilityElement base = (VariabilityElement)elementInConfig;
        List vChildren = AssociationHelper.getImmediateVarieties((VariabilityElement)base);
        if (vChildren == null || vChildren.isEmpty()) {
            return;
        }
        boolean isContentCategory = base instanceof ContentCategory;
        for (VariabilityElement child : vChildren) {
            if (child.getVariabilityBasedOnElement() != base || child.getVariabilityType() != VariabilityType.CONTRIBUTES && child.getVariabilityType() != VariabilityType.REPLACES || !this.isOwnerSelected((MethodElement)child, null, false)) continue;
            List<VariabilityElement> replacers = this.getReplacers(child);
            if (replacers != null && !replacers.isEmpty()) {
                for (VariabilityElement replacer : replacers) {
                    if (!this.isOwnerSelected((MethodElement)replacer, newSupportingElements, true)) continue;
                }
                continue;
            }
            this.registerAsSupporting((MethodElement)child, newSupportingElements);
        }
    }

    private List<VariabilityElement> getReplacers(VariabilityElement base) {
        MethodConfiguration config = this.getConfig();
        List vChildren = AssociationHelper.getImmediateVarieties((VariabilityElement)base);
        if (vChildren == null || vChildren.isEmpty()) {
            return null;
        }
        ArrayList<VariabilityElement> replacers = new ArrayList<VariabilityElement>();
        for (VariabilityElement child : vChildren) {
            if (child.getVariabilityBasedOnElement() != base || child.getVariabilityType() != VariabilityType.REPLACES || !ConfigurationHelper.inConfig((MethodElement)child, config) && !this.isOwnerSelected((MethodElement)child, null, false)) continue;
            replacers.add(child);
        }
        return replacers;
    }
}

