/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.library.configuration.closure.ErrorInfo;
import org.eclipse.epf.library.configuration.closure.PackageError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDependencyError {
    private Object errorElement;
    private Map<Object, PackageError> errorInfoMap = new HashMap<Object, PackageError>();
    private int errorBits = 0;

    public ElementDependencyError(Object element) {
        this.errorElement = element;
    }

    public Object getErrorElement() {
        return this.errorElement;
    }

    public Object[] getCauseElements() {
        return this.errorInfoMap.keySet().toArray();
    }

    public int size() {
        return this.errorInfoMap.size();
    }

    public void addError(PackageError errorInfo) {
        this.errorInfoMap.put(errorInfo.getCauseElement(), errorInfo);
        this.errorBits |= errorInfo.getErrorLevel();
    }

    public PackageError removeError(Object causeElement) {
        PackageError error = this.errorInfoMap.remove(causeElement);
        this.calculateErrorBits();
        return error;
    }

    public PackageError getError(Object causeElement) {
        return this.errorInfoMap.get(causeElement);
    }

    public List<PackageError> getAll() {
        return new ArrayList<PackageError>(this.errorInfoMap.values());
    }

    public boolean isError() {
        return (this.errorBits & 1) > 0;
    }

    public boolean isWarning() {
        return (this.errorBits & 2) > 0;
    }

    public boolean isChildError() {
        return (this.errorBits & 8) > 0;
    }

    public boolean isChildWarning() {
        return (this.errorBits & 0x10) > 0;
    }

    public void calculateErrorBits() {
        this.errorBits = 0;
        Iterator<PackageError> it = this.errorInfoMap.values().iterator();
        while (it.hasNext()) {
            this.errorBits |= ((ErrorInfo)it.next()).getErrorLevel();
        }
    }
}

