/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.configuration.closure.ElementReference;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;

public class PackageReference
extends ElementReference {
    private List refList = new ArrayList();

    public PackageReference(MethodElement element, MethodElement refElement) {
        super(element, refElement);
    }

    public void addReference(ElementReference ref) {
        this.refList.add(ref);
    }

    public List getReferences() {
        return this.refList;
    }

    public ElementReference getReference(Object element, Object refElement) {
        for (ElementReference ref : this.refList) {
            if (ref.getElement() != element || ref.getRefElement() != refElement) continue;
            return ref;
        }
        return null;
    }

    public boolean hasReference(MethodElement element, MethodElement refElement) {
        return this.getReference(element, refElement) != null;
    }

    public void removeReference(MethodElement ownerElement) {
        int i = 0;
        while (i < this.refList.size()) {
            ElementReference ref = (ElementReference)this.refList.get(i);
            MethodElement e = ref.getElement();
            if (e != null && e == ownerElement) {
                this.refList.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void print() {
        System.out.println(String.valueOf(LibraryUtil.getName(this.element)) + " --> " + LibraryUtil.getName(this.refElement));
        Iterator it = this.refList.iterator();
        while (it.hasNext()) {
            ((ElementReference)it.next()).print();
        }
        System.out.println();
    }

    public boolean canIgnore() {
        List refs = this.getReferences();
        if (refs.size() == 0) {
            return true;
        }
        for (ElementReference ref : refs) {
            if (ref.canIgnore()) continue;
            return false;
        }
        return true;
    }
}

