/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.elements.DescriptorLayout;
import org.eclipse.epf.library.layout.elements.TaskDescriptorLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.FulfillableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkProductDescriptorLayout
extends DescriptorLayout {
    public static final Collection<EStructuralFeature> extraFeaturesFromWorkProduct = Arrays.asList(UmaPackage.eINSTANCE.getWorkProduct_EstimationConsiderations(), UmaPackage.eINSTANCE.getWorkProduct_Reports(), UmaPackage.eINSTANCE.getWorkProduct_Templates(), UmaPackage.eINSTANCE.getWorkProduct_ToolMentors());

    @Override
    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    @Override
    public void loadReferences(XmlElement elementXml, boolean includeReferences) {
        super.loadReferences(elementXml, includeReferences);
        List modifyRoles = this.calcModifyRoleDescriptors();
        this.addReferences(null, elementXml, "workedOnBy", modifyRoles);
        elementXml.setAttribute("ShowFullMethodContent", this.layoutManager.getValidator().showExtraInfoForDescriptors() ? "true" : "false");
        if (this.elementLayout != null && this.layoutManager.getValidator().showExtraInfoForDescriptors()) {
            for (EStructuralFeature feature : this.getExtraFeaturesFromContentElement()) {
                this.elementLayout.loadFeature(feature, elementXml, false);
            }
        }
    }

    @Override
    protected Collection<EStructuralFeature> getExtraFeaturesFromContentElement() {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>(extraFeaturesFromWorkProduct);
        features.addAll(super.getExtraFeaturesFromContentElement());
        return features;
    }

    public List calcModifyRoleDescriptors() {
        ArrayList<RoleDescriptor> modifyRoles = new ArrayList<RoleDescriptor>();
        ElementRealizer realizer = this.getLayoutMgr().getElementRealizer();
        List taskDescriptors = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.WorkProductDescriptor_OutputFrom_TaskDescriptors, realizer);
        EReference feature = UmaPackage.eINSTANCE.getTaskDescriptor_Output();
        for (TaskDescriptor t : taskDescriptors) {
            List roleDescriptors;
            String path;
            TaskDescriptorLayout tl = (TaskDescriptorLayout)this.layoutManager.createLayout((MethodElement)t, this.owningProcess, path = DescriptorLayout.makePath(this.getSuperActivityPath(), (MethodElement)t));
            List outputs = (List)tl.getFeatureValue((EStructuralFeature)feature, null, false);
            if (outputs == null || !outputs.contains(this.element) || (roleDescriptors = (List)tl.getFeatureValue((EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), null, false)) == null) continue;
            for (RoleDescriptor r : roleDescriptors) {
                if (r == null || modifyRoles.contains(r)) continue;
                modifyRoles.add(r);
            }
        }
        return modifyRoles;
    }

    @Override
    protected boolean acceptFeatureValue(OppositeFeature feature, Object value) {
        if (!super.acceptFeatureValue(feature, value)) {
            return false;
        }
        if (!this.isTaskOppositeFeature(feature) || !(value instanceof List)) {
            return true;
        }
        List items = (List)value;
        int i = 0;
        while (i < items.size()) {
            MethodElement e = (MethodElement)items.get(i);
            String path = DescriptorLayout.makePath(this.getSuperActivityPath(), e);
            TaskDescriptorLayout tl = (TaskDescriptorLayout)this.layoutManager.createLayout(e, this.owningProcess, path);
            List o = null;
            if (feature == AssociationHelper.WorkProductDescriptor_ExternalInputTo_TaskDescriptors) {
                o = (List)tl.getFeatureValue((EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_ExternalInput(), null, false);
            } else if (feature == AssociationHelper.WorkProductDescriptor_MandatoryInputTo_TaskDescriptors) {
                o = (List)tl.getFeatureValue((EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput(), null, false);
            } else if (feature == AssociationHelper.WorkProductDescriptor_OptionalInputTo_TaskDescriptors) {
                o = (List)tl.getFeatureValue((EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput(), null, false);
            } else if (feature == AssociationHelper.WorkProductDescriptor_OutputFrom_TaskDescriptors) {
                o = (List)tl.getFeatureValue((EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Output(), null, false);
            }
            if (o != null && o.contains(this.element)) {
                ++i;
                continue;
            }
            items.remove(i);
        }
        return true;
    }

    @Override
    public XmlElement getXmlElement(boolean includeReferences) {
        EObject containingObj;
        ProcessPackage contaningPkg;
        XmlElement elementXml = super.getXmlElement(includeReferences);
        if (includeReferences) {
            this.includeContainedWpdReferences(elementXml);
        }
        WorkProductDescriptor wpd = null;
        WorkProduct wp = null;
        boolean isSlot = false;
        if (this.getElement() instanceof WorkProductDescriptor && (wp = (wpd = (WorkProductDescriptor)this.getElement()).getWorkProduct()) != null) {
            isSlot = wp.getIsAbstract();
        }
        if (isSlot) {
            elementXml.setAttribute("Type", "WorkProductSlot");
            elementXml.setAttribute("TypeName", LibraryResources.WorkProductSlot_text);
        }
        ProcessPackage processPackage = contaningPkg = (containingObj = wpd.eContainer()) instanceof ProcessPackage ? (ProcessPackage)containingObj : null;
        if (includeReferences && contaningPkg != null) {
            List<WorkProductDescriptor> wpdList;
            List<FulfillableElement> list;
            List processElements = contaningPkg.getProcessElements();
            HashMap<WorkProduct, WorkProductDescriptor> wpWpdMap = new HashMap<WorkProduct, WorkProductDescriptor>();
            MethodConfiguration config = this.layoutManager.getElementRealizer().getConfiguration();
            for (ProcessElement processElement : processElements) {
                WorkProductDescriptor wpdElem;
                WorkProduct wpElement;
                if (!(processElement instanceof WorkProductDescriptor) || (wpElement = (wpdElem = (WorkProductDescriptor)processElement).getWorkProduct()) == null || (wpElement = (WorkProduct)ConfigurationHelper.getCalculatedElement((MethodElement)wpElement, config)) == null) continue;
                wpWpdMap.put(wpElement, wpdElem);
            }
            if (isSlot) {
                OppositeFeature ofeature = AssociationHelper.FulFills_FullFillableElements;
                list = ConfigurationHelper.calcFulfills_FulfillableElement((FulfillableElement)wp, config);
                wpdList = this.getWpdList(wpWpdMap, list);
                this.addReferences(ofeature, elementXml, ofeature.getName(), wpdList);
            } else if (wp != null) {
                EReference feature = UmaPackage.eINSTANCE.getFulfillableElement_Fulfills();
                list = ConfigurationHelper.calcFulfillableElement_Fulfills((FulfillableElement)wp, config);
                wpdList = this.getWpdList(wpWpdMap, list);
                this.addReferences(feature, elementXml, feature.getName(), wpdList);
                this.includeSlotReferences(elementXml, wpdList);
            }
        }
        return elementXml;
    }

    private void includeSlotReferences(XmlElement elementXml, List<WorkProductDescriptor> wpdsWithslots) {
        ElementRealizer realizer = this.layoutManager.getElementRealizer();
        this.addSlotReferences(elementXml, AssociationHelper.WorkProductDescriptor_MandatoryInputTo_TaskDescriptors, "mandatoryInputToTaskDescriptors_fromSlots", wpdsWithslots, realizer);
        this.addSlotReferences(elementXml, AssociationHelper.WorkProductDescriptor_OptionalInputTo_TaskDescriptors, "optionalInputToTaskDescriptors_fromSlots", wpdsWithslots, realizer);
        this.addSlotReferences(elementXml, AssociationHelper.WorkProductDescriptor_OutputFrom_TaskDescriptors, "outputFromTaskDescriptors_fromSlots", wpdsWithslots, realizer);
    }

    private void addSlotReferences(XmlElement elementXml, OppositeFeature ofeature, String referenceName, List<WorkProductDescriptor> wpdsWithslots, ElementRealizer realizer) {
        ArrayList references = new ArrayList();
        for (WorkProductDescriptor wpd : wpdsWithslots) {
            List list = ConfigurationHelper.calc0nFeatureValue((MethodElement)wpd, ofeature, realizer);
            references.addAll(list);
        }
        this.addReferences(ofeature, elementXml, referenceName, references);
    }

    private List<WorkProductDescriptor> getWpdList(Map<WorkProduct, WorkProductDescriptor> wpWpdMap, List<WorkProduct> wpList) {
        ArrayList<WorkProductDescriptor> ret = new ArrayList<WorkProductDescriptor>();
        for (WorkProduct wp : wpList) {
            WorkProductDescriptor wpd = wpWpdMap.get(wp);
            if (wpd == null) continue;
            ret.add(wpd);
        }
        return ret;
    }

    private void includeContainedWpdReferences(XmlElement elementXml) {
        WorkProductDescriptor wpd;
        WorkProductDescriptor workProductDescriptor = wpd = this.getElement() instanceof WorkProductDescriptor ? (WorkProductDescriptor)this.getElement() : null;
        if (wpd == null) {
            return;
        }
        WorkProduct wp = wpd.getWorkProduct();
        if (!(wp instanceof Artifact)) {
            return;
        }
        EReference containerFeature = UmaPackage.eINSTANCE.getArtifact_ContainerArtifact();
        Artifact containerArtifact = (Artifact)ConfigurationHelper.calc01FeatureValue((MethodElement)wp, null, (EStructuralFeature)containerFeature, this.layoutManager.getElementRealizer());
        EReference feature = UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts();
        ArrayList<WorkProductDescriptor> wpdList = new ArrayList<WorkProductDescriptor>();
        Activity superAct = wpd.getSuperActivities();
        for (BreakdownElement be : superAct.getBreakdownElements()) {
            WorkProduct wpBe;
            if (!(be instanceof WorkProductDescriptor) || !((wpBe = ((WorkProductDescriptor)be).getWorkProduct()) instanceof Artifact)) continue;
            if (((Artifact)wpBe).getContainerArtifact() == wp) {
                wpdList.add((WorkProductDescriptor)be);
            }
            if (containerArtifact == null || containerArtifact != wpBe) continue;
            containerArtifact = null;
            this.processChild((Object)containerFeature, elementXml.newChild("reference").setAttribute("name", containerFeature.getName()), (MethodElement)be, false);
        }
        this.addReferences(feature, elementXml, feature.getName(), wpdList);
    }
}

