/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class MigrationUtil {
    public static Map getProcesses() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List<MethodPlugin> methodPlugins = LibraryUtil.getMethodPlugins(library);
        for (MethodPlugin methodPlugin : methodPlugins) {
            String[] deliveryProcessPaths;
            String[] capabilityPatternPaths;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(capabilityPatternPaths = ModelStructure.DEFAULT.capabilityPatternPath));
            if (methodPackage instanceof ProcessPackage && methodPackage instanceof ProcessPackage) {
                MigrationUtil.getCapabilityPatterns((ProcessPackage)methodPackage, result);
            }
            if (!((methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(deliveryProcessPaths = ModelStructure.DEFAULT.deliveryProcessPath))) instanceof ProcessPackage) || !(methodPackage instanceof ProcessPackage)) continue;
            MigrationUtil.getDeliveryProcesses((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getCapabilityPatterns() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List<MethodPlugin> methodPlugins = LibraryUtil.getMethodPlugins(library);
        for (MethodPlugin methodPlugin : methodPlugins) {
            String[] capabilityPatternPaths;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(capabilityPatternPaths = ModelStructure.DEFAULT.capabilityPatternPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            MigrationUtil.getCapabilityPatterns((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getDeliveryProcesses() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List<MethodPlugin> methodPlugins = LibraryUtil.getMethodPlugins(library);
        for (MethodPlugin methodPlugin : methodPlugins) {
            String[] deliveryProcessPaths;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(deliveryProcessPaths = ModelStructure.DEFAULT.deliveryProcessPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            MigrationUtil.getDeliveryProcesses((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getContexts(Process process) {
        if (process == null) {
            return null;
        }
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap<String, MethodConfiguration> result = new TreeMap<String, MethodConfiguration>();
        MethodConfiguration defaultContext = process.getDefaultContext();
        if (defaultContext != null) {
            result.put(defaultContext.getName(), defaultContext);
        }
        List contexts = process.getValidContext();
        for (MethodConfiguration context : contexts) {
            if (context == null) continue;
            result.put(context.getName(), context);
        }
        return result;
    }

    protected static void getCapabilityPatterns(ProcessPackage processPackage, Map result) {
        List childPackages = processPackage.getChildPackages();
        for (Object obj : childPackages) {
            if (obj instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)obj;
                Process process = processComponent.getProcess();
                if (!(process instanceof CapabilityPattern)) continue;
                String name = process.getName();
                result.put(name, process);
                continue;
            }
            if (!(obj instanceof ProcessPackage)) continue;
            MigrationUtil.getCapabilityPatterns((ProcessPackage)obj, result);
        }
    }

    protected static void getDeliveryProcesses(ProcessPackage processPackage, Map result) {
        List childPackages = processPackage.getChildPackages();
        for (Object obj : childPackages) {
            if (obj instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)obj;
                Process process = processComponent.getProcess();
                if (!(process instanceof DeliveryProcess)) continue;
                String name = process.getName();
                result.put(name, process);
                continue;
            }
            if (!(obj instanceof ProcessPackage)) continue;
            MigrationUtil.getDeliveryProcesses((ProcessPackage)obj, result);
        }
    }

    public static Map getActivities(Process process) {
        return MigrationUtil.getActivities(process, false);
    }

    public static Map getActivities(Process process, boolean linkedHashMap) {
        AbstractMap result = linkedHashMap ? new LinkedHashMap() : new TreeMap();
        MethodConfiguration defaultContext = process.getDefaultContext();
        ProcessConfigurator filter = new ProcessConfigurator(defaultContext);
        MigrationUtil.getActivities((Activity)process, result, filter);
        return result;
    }

    protected static void getActivities(Activity process, Map result, ProcessConfigurator filter) {
        result.put(process.getName(), process);
        List list = process.getBreakdownElements();
        if (list.size() > 0) {
            for (Object object : list) {
                if (!(object instanceof Activity)) continue;
                if (filter != null && filter.accept(object)) {
                    result.put(((Activity)object).getName(), object);
                }
                if (!(object instanceof Activity)) continue;
                MigrationUtil.getActivities((Activity)object, result, filter);
            }
        }
    }
}

