/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.ISiteGenerator;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;

public abstract class AbstractSiteGenerator
implements ISiteGenerator {
    public static final String DOC_ROOT = "docroot/";
    private static final String WEB_INF_PATH = "docroot/WEB-INF";
    private static final String WEB_INF_DIR = "WEB-INF";
    protected String pubDir;
    protected PublishHTMLOptions options;
    protected HtmlBuilder builder;

    public AbstractSiteGenerator(HtmlBuilder builder, PublishHTMLOptions options) {
        this.options = options;
        this.builder = builder;
        this.pubDir = builder.getPublishDir();
    }

    public abstract HtmlBuilder getHtmlBuilder();

    public abstract String getIndexFilePath();

    public abstract String getNodeIconPath();

    public abstract String getDefaultBannerImageFile();

    public abstract PublishOptions getPublishOptions();

    public abstract void postPublish() throws Exception;

    public abstract void prePublish() throws Exception;

    public abstract void writePublishedBookmarks(List var1, Bookmark var2) throws Exception;

    protected void copyCustomizedFiles() throws Exception {
        if (this.options.bannerImage != null && this.options.bannerImage.length() > 0) {
            FileUtil.copyFile((String)this.options.bannerImage, (String)(String.valueOf(this.pubDir) + "images"));
            this.options.bannerImage = FileUtil.getFileName((String)this.options.bannerImage);
        } else {
            this.options.bannerImage = this.getDefaultBannerImageFile();
        }
        if (this.options.isPublishDynamicWebApp()) {
            URL plugin_url = PublishingPlugin.getDefault().getInstallURL();
            String path = FileLocator.resolve((URL)new URL(plugin_url, WEB_INF_PATH)).getPath();
            String includes = "*.*, **/";
            LayoutResources.copyDir((String)path, (String)(String.valueOf(this.pubDir) + WEB_INF_DIR), (String)includes, null);
        }
    }

    protected void copyLocalizedFiles() throws Exception {
        PublishingPlugin.getDefault().copyLocalizedFiles("docroot/scripts/", new File(this.pubDir, "scripts/"), true, false);
        PublishingPlugin.getDefault().copyLocalizedFiles("docroot/images/", new File(this.pubDir, "images/"), true, false);
        PublishingPlugin.getDefault().copyLocalizedFiles(DOC_ROOT, new File(this.pubDir, "/"), false, false);
    }

    protected String getViewDataFileName(Bookmark b, String ext) {
        File f = new File(b.getFileName());
        String fileName = f.getName();
        int i = fileName.lastIndexOf(".");
        if (i >= 0) {
            fileName = fileName.substring(0, i);
        }
        return String.valueOf(fileName) + ext;
    }

    public void dispose() {
        if (this.builder != null) {
            this.builder.getLayoutManager().clear();
            this.builder.dispose();
            this.builder = null;
        }
    }
}

