/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveInListCommand
extends AbstractCommand
implements IResourceAwareCommand {
    public static final int UP = 1;
    public static final int DOWN = 0;
    private MethodElement element;
    private EStructuralFeature feature;
    private List<Object> elementsList;
    private ContentElementOrderList elementOrderList;
    private Collection<Resource> modifiedResources;
    private int direction = -1;
    private boolean moved;

    public MoveInListCommand(MethodElement element, List<Object> elementsList, ContentElementOrderList orderList, EStructuralFeature feature, int direction) {
        this.element = element;
        this.feature = feature;
        this.elementsList = elementsList;
        this.elementOrderList = orderList;
        this.direction = direction;
        this.modifiedResources = new HashSet<Resource>();
    }

    protected boolean prepare() {
        return true;
    }

    public MoveInListCommand(String label) {
        super(label);
    }

    public MoveInListCommand(String label, String description) {
        super(label, description);
    }

    @Override
    public Collection<Resource> getModifiedResources() {
        this.modifiedResources.add(this.element.eResource());
        return this.modifiedResources;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.element == null) {
            return;
        }
        for (Object object : this.elementsList) {
            if (this.feature.isMany()) {
                int index = this.elementOrderList.indexOf(object);
                if (this.direction == 1) {
                    if (index > 0) {
                        this.elementOrderList.move(index - 1, object);
                    }
                } else if (this.direction == 0 && index < this.elementOrderList.size()) {
                    this.elementOrderList.move(index + this.elementsList.size(), object);
                }
                this.moved = true;
                continue;
            }
            this.element.eSet(this.feature, null);
        }
        this.elementOrderList.apply();
    }

    public void undo() {
        if (this.moved) {
            for (Object object : this.elementsList) {
                if (this.feature.isMany()) {
                    int index = this.elementOrderList.indexOf(object);
                    if (this.direction == 1) {
                        if (index < this.elementOrderList.size()) {
                            this.elementOrderList.move(index + this.elementsList.size(), object);
                        }
                    } else if (this.direction == 0 && index > 0) {
                        this.elementOrderList.move(index - 1, object);
                    }
                    this.moved = true;
                    continue;
                }
                this.element.eSet(this.feature, object);
            }
            this.elementOrderList.apply();
            this.moved = false;
        }
    }

    public Collection<MethodElement> getAffectedObjects() {
        return Collections.singletonList(this.element);
    }
}

