/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.navigator.MethodLibraryItemProvider;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.PluginUIPackagesMap;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.provider.MethodPluginItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUIPackagesItemProvider
extends ItemProviderAdapter
implements IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
ILibraryItemProvider,
IStatefulItemProvider {
    public static final String PLUGIN_PACKAGE_SEPARATOR = ".";
    private Object parent;
    private String name;
    private Collection<MethodPlugin> plugins;
    private Map<String, PluginUIPackagesItemProvider> pluginPackagesItemProvidersMap = new HashMap<String, PluginUIPackagesItemProvider>();

    public PluginUIPackagesItemProvider(AdapterFactory adapterFactory, String packageName, Collection<MethodPlugin> plugins) {
        super(adapterFactory);
        this.name = packageName;
        this.plugins = plugins;
    }

    @Override
    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        return super.getChildrenFeatures(object);
    }

    public String getText(Object object) {
        return this.name;
    }

    public Object getImage(Object object) {
        return LibraryEditPlugin.INSTANCE.getImage("full/obj16/package_obj");
    }

    public static String getNameDelta(PluginUIPackagesItemProvider topObject, Object bottomObject) {
        String topName = topObject.getFullName();
        String bottomName = null;
        if (bottomObject instanceof PluginUIPackagesItemProvider) {
            bottomName = ((PluginUIPackagesItemProvider)bottomObject).getFullName();
        } else if (bottomObject instanceof MethodPlugin) {
            bottomName = ((MethodPlugin)bottomObject).getName();
        }
        if (bottomName == null || topName.equals(bottomName)) {
            return topName;
        }
        try {
            String deltaname = bottomName.substring(topName.length() + 1);
            return deltaname;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return bottomName;
        }
    }

    public Collection<Object> getChildren(Object parentElement) {
        return this.addChildren(this.plugins);
    }

    private Collection<Object> addChildren(Collection<MethodPlugin> plugins) {
        ArrayList<Object> children = new ArrayList<Object>();
        PluginUIPackagesMap map = new PluginUIPackagesMap();
        for (MethodPlugin plugin : plugins) {
            String deltaName = PluginUIPackagesItemProvider.getNameDelta(this, plugin);
            int dotIdx = deltaName.indexOf(PLUGIN_PACKAGE_SEPARATOR);
            if (dotIdx != -1) {
                map.add(deltaName.substring(0, dotIdx), plugin);
                continue;
            }
            children.add(plugin);
            Adapter adapter = this.adapterFactory.adapt((Notifier)plugin, ITreeItemContentProvider.class);
            if (!(adapter instanceof ILibraryItemProvider)) continue;
            ((ILibraryItemProvider)adapter).setParent(this);
        }
        HashSet<String> existingNames = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Set plugSet = (Set)entry.getValue();
            PluginUIPackagesItemProvider provider = this.pluginPackagesItemProvidersMap.get(String.valueOf(this.getFullName()) + PLUGIN_PACKAGE_SEPARATOR + name);
            if (provider == null) {
                provider = new PluginUIPackagesItemProvider(this.adapterFactory, name, plugSet);
                this.pluginPackagesItemProvidersMap.put(String.valueOf(this.getFullName()) + PLUGIN_PACKAGE_SEPARATOR + name, provider);
            } else {
                provider.setPlugins(plugSet);
            }
            existingNames.add(String.valueOf(this.getFullName()) + PLUGIN_PACKAGE_SEPARATOR + name);
            provider.setParent(this);
            children.add(provider);
        }
        this.retainPluginPackagesItemProviders(existingNames);
        Collections.sort(children, Comparators.PLUGINPACKAGE_COMPARATOR);
        return children;
    }

    public String getFullName() {
        String fullName = this.getName();
        Object parent = this.getParent();
        while (parent instanceof PluginUIPackagesItemProvider) {
            fullName = String.valueOf(((PluginUIPackagesItemProvider)parent).getName()) + PLUGIN_PACKAGE_SEPARATOR + fullName;
            parent = ((PluginUIPackagesItemProvider)parent).getParent();
        }
        return fullName;
    }

    public String getName() {
        return this.name;
    }

    public Object getParent(Object object) {
        if (this.parent != null) {
            return this.parent;
        }
        return this.target;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(MethodPlugin.class)) {
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
            }
        }
        super.notifyChanged(notification);
    }

    public void dispose() {
        if (this.pluginPackagesItemProvidersMap != null) {
            this.pluginPackagesItemProvidersMap.clear();
            this.pluginPackagesItemProvidersMap = null;
        }
        super.dispose();
    }

    private void retainPluginPackagesItemProviders(Collection<String> names) {
        Iterator<String> iter = this.pluginPackagesItemProvidersMap.keySet().iterator();
        while (iter.hasNext()) {
            String keyName = iter.next();
            if (names.contains(keyName)) continue;
            PluginUIPackagesItemProvider provider = this.pluginPackagesItemProvidersMap.get(keyName);
            if (provider != null) {
                provider.dispose();
            }
            iter.remove();
        }
    }

    public Collection<MethodPlugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Collection<MethodPlugin> plugins) {
        this.plugins = plugins;
    }

    public ItemProviderAdapter getPluginItemProvider(MethodPlugin plugin) {
        String deltaName = PluginUIPackagesItemProvider.getNameDelta(this, plugin);
        int dotIdx = deltaName.indexOf(PLUGIN_PACKAGE_SEPARATOR);
        if (dotIdx != -1) {
            PluginUIPackagesItemProvider provider;
            String packageProviderName = deltaName.substring(0, dotIdx);
            if (this.pluginPackagesItemProvidersMap != null && (provider = this.pluginPackagesItemProvidersMap.get(String.valueOf(this.getFullName()) + PLUGIN_PACKAGE_SEPARATOR + packageProviderName)) != null) {
                return provider;
            }
        } else {
            return (MethodPluginItemProvider)TngUtil.getAdapter((EObject)plugin, MethodPluginItemProvider.class);
        }
        return null;
    }

    public static Object findPluginItemProvider(String itemName, MethodLibrary lib) {
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory().adapt((Notifier)lib, ITreeItemContentProvider.class);
        if (adapter instanceof MethodLibraryItemProvider) {
            MethodLibraryItemProvider libraryAdapter = (MethodLibraryItemProvider)adapter;
            List pluginList = lib.getMethodPlugins();
            for (MethodPlugin plugin : pluginList) {
                if (itemName.equals(plugin.getName())) {
                    return plugin;
                }
                libraryAdapter.getChildren(lib);
                ItemProviderAdapter pluginTreeAdapter = libraryAdapter.getPluginItemProvider(plugin);
                while (pluginTreeAdapter instanceof PluginUIPackagesItemProvider) {
                    if (itemName.equals(((PluginUIPackagesItemProvider)pluginTreeAdapter).getFullName())) {
                        return pluginTreeAdapter;
                    }
                    pluginTreeAdapter.getChildren((Object)pluginTreeAdapter);
                    pluginTreeAdapter = ((PluginUIPackagesItemProvider)pluginTreeAdapter).getPluginItemProvider(plugin);
                }
            }
        }
        return null;
    }
}

