/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.SynchronizeCommand;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ActivityHandler;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDropCommand
extends BSDropCommand {
    private Object viewer;
    private List<CapabilityPattern> oldPatterns;
    private List<CapabilityPattern> patterns;
    protected Process targetProcess;
    private boolean isDeliveryProcess;
    private int type;
    private Collection<Activity> appliedActivities;
    protected AdapterFactory adapterFactory;
    protected ActivityHandler activityHandler;
    protected boolean preExecuted;
    protected HashSet<?> addedObjects;
    protected IConfigurator activityDeepCopyConfigurator;

    public ActivityDropCommand(Activity target, List activities, Object viewer, AdapterFactory adapterFactory) {
        super(target, activities);
        this.setLabel(LibraryEditResources.ActivityDropCommand_label);
        this.viewer = viewer;
        this.adapterFactory = adapterFactory;
        this.targetProcess = TngUtil.getOwningProcess((BreakdownElement)target);
        this.isDeliveryProcess = this.targetProcess instanceof DeliveryProcess;
        if (this.isDeliveryProcess) {
            this.oldPatterns = new ArrayList<CapabilityPattern>(((DeliveryProcess)this.targetProcess).getIncludesPatterns());
        }
    }

    public ActivityDropCommand(Activity target, List activities, Object viewer, AdapterFactory adapterFactory, IConfigurator deepCopyConfigurator) {
        this(target, activities, viewer, adapterFactory);
        this.activityDeepCopyConfigurator = deepCopyConfigurator;
    }

    @Override
    protected void prepareDropElements() {
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Suppression supp;
            Object element = iter.next();
            Process proc = TngUtil.getOwningProcess(element);
            if (proc == null || !(supp = Suppression.getSuppression(proc)).isSuppressed(element)) continue;
            iter.remove();
        }
        super.prepareDropElements();
    }

    public void setType(int type) {
        this.type = type;
        if (type == 3) {
            this.runAsJob = true;
        }
    }

    public IStatus checkCopy() {
        for (Object e : this.dropElements) {
            IStatus status;
            if (!(e instanceof Activity) || (status = this.checkCircular((Activity)e)).isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus checkExtend() {
        for (Activity act : this.dropElements) {
            Process srcProc = TngUtil.getOwningProcess((BreakdownElement)act);
            if (srcProc instanceof DeliveryProcess && srcProc != this.targetProcess) {
                return new Status(4, "org.eclipse.epf.library.edit", 0, LibraryEditResources.cannot_copy_or_extend_delivery_process, null);
            }
            IStatus status = this.checkCircular(act);
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkCircular(Activity act) {
        boolean result = DependencyChecker.newCheckAct ? DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)this.activity, Collections.singletonList(act), true) : DependencyChecker.checkCircularDependency(act, this.activity).isOK();
        if (!result) {
            return new Status(4, "org.eclipse.epf.library.edit", 0, LibraryEditResources.circular_dependency_error_msg, null);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void execute() {
        IActionTypeProvider actionTypeProvider = (IActionTypeProvider)this.viewer;
        if (this.viewer != null) {
            this.viewer = null;
            boolean canCopy = this.checkCopy().isOK();
            boolean canExtend = this.checkExtend().isOK();
            int[] choices = new int[1 + (canCopy ? 1 : 0) + (canExtend ? 1 : 0)];
            int i = 0;
            if (canCopy) {
                choices[i++] = 1;
            }
            if (canExtend) {
                choices[i++] = 2;
            }
            choices[i] = 3;
            actionTypeProvider.execute(this, choices);
            return;
        }
        this.activityHandler = new ActivityHandler();
        try {
            if (this.type == 3) {
                this.doDeepCopy();
            } else {
                super.execute();
            }
        }
        finally {
            this.activityHandler.dispose();
        }
        if (TngUtil.DEBUG) {
            System.out.println("ActivityDropCommand.execute(): done");
        }
    }

    protected void doDeepCopy() {
        boolean copyExternalVariations;
        if (!UserInteractionHelper.confirmDeepCopy(this.dropElements)) {
            return;
        }
        MethodConfiguration deepCopyConfig = null;
        try {
            deepCopyConfig = UserInteractionHelper.chooseDeepCopyConfiguration(this.targetProcess, this.adapterFactory);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.getModifiedResources().clear();
            return;
        }
        try {
            copyExternalVariations = UserInteractionHelper.copyExternalVariationsAllowed(this.targetProcess, this.adapterFactory);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.getModifiedResources().clear();
            return;
        }
        this.activityHandler.setCopyExternalVariations(copyExternalVariations);
        this.activityHandler.setDeepCopyConfig(deepCopyConfig);
        this.activityHandler.setTargetProcess(this.targetProcess);
        this.activityHandler.setActivityDeepCopyConfigurator(this.activityDeepCopyConfigurator);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ActivityDropCommand.this.activityHandler.setMonitor(monitor);
                ActivityDropCommand.this.preExecuted = ActivityDropCommand.this.preExecute();
            }
        };
        UserInteractionHelper.runWithProgress(runnable, this.getLabel());
        if (this.preExecuted) {
            this.redo();
        }
    }

    @Override
    protected boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        if (this.isDeliveryProcess) {
            this.patterns = new ArrayList<CapabilityPattern>();
        }
        block5: for (Object element : this.dropElements) {
            if (!(element instanceof Activity)) continue;
            Activity act = (Activity)element;
            switch (this.type) {
                case 3: {
                    this.activityHandler.deepCopy(element);
                    break;
                }
                case 2: {
                    Process proc;
                    this.activityHandler.extend(act);
                    if (this.patterns == null || !((proc = TngUtil.getOwningProcess((BreakdownElement)act)) instanceof CapabilityPattern)) continue block5;
                    this.patterns.add((CapabilityPattern)proc);
                    break;
                }
                case 1: {
                    this.activityHandler.copy(act);
                }
            }
        }
        this.appliedActivities = new ArrayList<Activity>(this.activityHandler.getActivities());
        return !this.appliedActivities.isEmpty();
    }

    @Override
    protected void doExecute() {
        Iterator<Activity> itor = this.appliedActivities.iterator();
        ProcessPackage pkg = (ProcessPackage)this.activity.eContainer();
        while (itor.hasNext()) {
            Activity act = itor.next();
            if (act.eContainer() != null && act.eContainer().eContainer() != pkg) {
                pkg.getChildPackages().add((MethodPackage)act.eContainer());
            }
            if (this.patterns == null || this.patterns.isEmpty()) continue;
            DeliveryProcess proc = (DeliveryProcess)this.targetProcess;
            for (CapabilityPattern pattern : this.patterns) {
                if (proc.getIncludesPatterns().contains(pattern)) continue;
                proc.getIncludesPatterns().add(pattern);
            }
        }
        long time = 0L;
        if (TngUtil.DEBUG) {
            time = System.currentTimeMillis();
        }
        this.activity.getBreakdownElements().addAll(this.appliedActivities);
        if (TngUtil.DEBUG) {
            System.out.println("ActivityDropCommand.doExecute(): new activities added. " + (System.currentTimeMillis() - time));
        }
        if (!this.activityHandler.getDeepCopies().isEmpty()) {
            if (TngUtil.DEBUG) {
                time = System.currentTimeMillis();
            }
            this.postDeepCopy();
            if (TngUtil.DEBUG) {
                System.out.println("ActivityDropCommand.doExecute(): postDeepCopy(). " + (System.currentTimeMillis() - time));
            }
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)this.adapterFactory.adapt((Notifier)this.activity, ITreeItemContentProvider.class);
        adapter.getChildren((Object)this.activity);
        this.fixDuplicateNames();
        this.getModifiedResources().add(this.activity.eResource());
    }

    private void postDeepCopy() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (ActivityDropCommand.this.addedObjects == null) {
                    ActivityDropCommand.this.addedObjects = new HashSet();
                } else {
                    ActivityDropCommand.this.addedObjects.clear();
                }
                boolean defaultConfigChanged = false;
                Iterator iter = ActivityDropCommand.this.activityHandler.getDeepCopies().iterator();
                while (iter.hasNext()) {
                    AbstractTreeIterator iterator = new AbstractTreeIterator(iter.next()){
                        private static final long serialVersionUID = 1L;

                        protected Iterator getChildren(Object object) {
                            if (object instanceof Activity) {
                                return ((Activity)object).getBreakdownElements().iterator();
                            }
                            return Collections.EMPTY_LIST.iterator();
                        }
                    };
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof Descriptor)) continue;
                        MethodElement me = ProcessUtil.getAssociatedElement((Descriptor)e);
                        int size = ActivityDropCommand.this.addedObjects.size();
                        ProcessUtil.addToDefaultConfiguration(ActivityDropCommand.this.targetProcess, (EObject)me, ActivityDropCommand.this.addedObjects);
                        if (defaultConfigChanged || size == ActivityDropCommand.this.addedObjects.size()) continue;
                        ActivityDropCommand.this.getModifiedResources().add(ActivityDropCommand.this.targetProcess.getDefaultContext().eResource());
                        defaultConfigChanged = true;
                    }
                }
            }
        };
        UserInteractionHelper.runWithProgress(runnable, this.getLabel());
        final SynchronizeCommand synchCmd = new SynchronizeCommand(this.activityHandler.getDeepCopies(), this.targetProcess.getDefaultContext(), null, false);
        try {
            runnable = new Runnable(){

                public void run() {
                    synchCmd.initilize();
                }
            };
            UserInteractionHelper.runWithProgress(runnable, LibraryEditResources.ProcessAutoSynchronizeAction_prepare);
            if (synchCmd.isIntialized()) {
                synchCmd.execute();
            }
        }
        finally {
            synchCmd.dispose();
        }
    }

    protected Suppression getSuppression() {
        return Suppression.getSuppression(this.targetProcess);
    }

    private void fixDuplicateNames() {
        Suppression suppression = this.getSuppression();
        for (Activity act : this.appliedActivities) {
            this.fixDuplicateNames((BreakdownElement)act, suppression);
            this.fixTeamProfileDuplicateNames(act, suppression);
        }
    }

    private void fixDuplicateNames(BreakdownElement e, Suppression suppression) {
        ActivityDropCommand.fixDuplicateNames(e, suppression, this.adapterFactory);
    }

    private static void fixDuplicateNames(BreakdownElement e, Suppression suppression, AdapterFactory adapterFactory) {
        String name;
        int i;
        String baseName = e.getName();
        if (ProcessUtil.checkBreakdownElementName(adapterFactory, e, baseName, suppression) != null) {
            i = 1;
            while (true) {
                if (ProcessUtil.checkBreakdownElementName(adapterFactory, e, name = String.valueOf(baseName) + '_' + i, suppression) == null) {
                    e.setName(name);
                    break;
                }
                ++i;
            }
        }
        if (ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, e, baseName = ProcessUtil.getPresentationName(e), suppression) != null) {
            i = 1;
            while (true) {
                if (ProcessUtil.checkBreakdownElementPresentationName(adapterFactory, e, name = String.valueOf(baseName) + '_' + i, suppression) == null) {
                    e.setPresentationName(name);
                    break;
                }
                ++i;
            }
        }
    }

    private void fixTeamProfileDuplicateNames(Activity act, Suppression suppression) {
        int i = act.getBreakdownElements().size() - 1;
        while (i > -1) {
            Object element = act.getBreakdownElements().get(i);
            if (element instanceof TeamProfile) {
                ActivityDropCommand.fixDuplicateNames((BreakdownElement)element, suppression, (AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
            } else if (element instanceof Activity) {
                this.fixTeamProfileDuplicateNames((Activity)element, suppression);
            }
            --i;
        }
    }

    @Override
    protected void doUndo() {
        this.activity.getBreakdownElements().removeAll(this.appliedActivities);
        if (this.isDeliveryProcess) {
            DeliveryProcess proc = (DeliveryProcess)this.targetProcess;
            proc.getIncludesPatterns().clear();
            proc.getIncludesPatterns().addAll(this.oldPatterns);
        }
    }

    public static void setName(List siblings, Activity e) {
        String baseName = e.getName();
        if (!ActivityDropCommand.isNameTaken(siblings, (DescribableElement)e, baseName)) {
            return;
        }
        int i = 1;
        while (true) {
            String name;
            if (!ActivityDropCommand.isNameTaken(siblings, (DescribableElement)e, name = String.valueOf(baseName) + '_' + i)) {
                e.setName(name);
                return;
            }
            ++i;
        }
    }

    public static void setDefaultPresentationName(List siblings, Activity e) {
        String basePresentationName = ProcessUtil.getPresentationName((BreakdownElement)e);
        if (!ActivityDropCommand.isPresentationNameTaken(siblings, (DescribableElement)e, basePresentationName)) {
            return;
        }
        int i = 1;
        while (true) {
            String name;
            if (!ActivityDropCommand.isPresentationNameTaken(siblings, (DescribableElement)e, name = String.valueOf(basePresentationName) + '_' + i)) {
                e.setPresentationName(name);
                return;
            }
            ++i;
        }
    }

    private static boolean isNameTaken(List siblings, DescribableElement e, String name) {
        int i = siblings.size() - 1;
        while (i > -1) {
            BreakdownElement sibling = (BreakdownElement)siblings.get(i);
            if (sibling != e && name.equals(sibling.getName())) {
                return true;
            }
            --i;
        }
        return false;
    }

    private static boolean isPresentationNameTaken(List siblings, DescribableElement e, String name) {
        int i = siblings.size() - 1;
        while (i > -1) {
            BreakdownElement sibling = (BreakdownElement)siblings.get(i);
            if (sibling != e && name.equals(ProcessUtil.getPresentationName(sibling))) {
                return true;
            }
            --i;
        }
        return false;
    }

    public Collection<?> getAffectedObjects() {
        if (this.executed) {
            return this.appliedActivities;
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<?> getResult() {
        return this.getAffectedObjects();
    }

    public ActivityHandler getActivityHandler() {
        return this.activityHandler;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public int getType() {
        return this.type;
    }

    public void setActivityDeepCopyConfigurator(IConfigurator activityDeepCopyConfigurator) {
        this.activityDeepCopyConfigurator = activityDeepCopyConfigurator;
    }
}

