/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.NestedCommandExcecutor;
import org.eclipse.epf.library.edit.process.command.DescriptorUpdateBatchCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BSDropCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private static final Set<EReference> BASIC_SYNC_REFERENCES = Collections.unmodifiableSet(new HashSet(Arrays.asList(UmaPackage.eINSTANCE.getContentElement_Checklists(), UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers(), UmaPackage.eINSTANCE.getContentElement_Examples(), UmaPackage.eINSTANCE.getContentElement_Guidelines(), UmaPackage.eINSTANCE.getContentElement_Assets(), UmaPackage.eINSTANCE.getContentElement_SupportingMaterials())));
    public static final Set<EStructuralFeature> DEFAULT_SYNCH_FEATURES = new HashSet<EStructuralFeature>((Collection)Arrays.asList(UmaPackage.eINSTANCE.getNamedElement_Name(), UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), UmaPackage.eINSTANCE.getMethodElement_PresentationName(), UmaPackage.eINSTANCE.getTask_OptionalInput(), UmaPackage.eINSTANCE.getTask_MandatoryInput(), UmaPackage.eINSTANCE.getTask_Output(), UmaPackage.eINSTANCE.getTask_Steps(), UmaPackage.eINSTANCE.getTask_PerformedBy(), UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy(), UmaPackage.eINSTANCE.getRole_ResponsibleFor(), UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts()));
    public static final Map<EStructuralFeature, EStructuralFeature> FEATURE_MAP = new HashMap<EStructuralFeature, EStructuralFeature>();
    protected Activity activity;
    protected List<Object> dropElements;
    protected List<Object> unwrappedDropElements;
    private Set<Resource> modifiedResources;
    protected List<Object> elementsToAddToDefaultConfig;
    protected Set<Object> addedObjects;
    private Process process;
    private boolean addedToDefaultConfig = false;
    protected boolean synchronize = false;
    protected ArrayList<TaskDescriptor> taskDescList;
    protected ArrayList<Descriptor> taskDescriptorsToUpdate;
    private Map<Descriptor, Map<?, ?>> descriptorToOldRefreshableFeaturesMap;
    protected DescriptorUpdateBatchCommand batchCommand;
    private Map taskDescToNewStepsMap;
    private Map taskDescToOldEstimateMap;
    protected boolean canceled;
    private MethodConfiguration config;
    protected Set synchFeatures = DEFAULT_SYNCH_FEATURES;
    private BatchCommand refreshResponsibleForCommand;
    protected boolean executed;
    protected boolean runAsJob;
    private IProgressMonitor monitor;
    private int workedUnits;
    private NestedCommandExcecutor nestedCommandExcecutor;

    static {
        DEFAULT_SYNCH_FEATURES.addAll(BASIC_SYNC_REFERENCES);
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_OptionalInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_MandatoryInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_Output(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Output());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getRole_ResponsibleFor(), (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_Steps(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Checklists(), (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Checklists());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers(), (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Concepts());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Examples(), (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Examples());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Guidelines(), (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Guidelines());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_Assets(), (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_ReusableAssets());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getContentElement_SupportingMaterials(), (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_SupportingMaterials());
    }

    public BSDropCommand(Activity activity, List<Object> dropElements) {
        this(activity, dropElements, null, null, false);
    }

    public BSDropCommand(Activity activity, List<Object> dropElements, boolean synch) {
        this(activity, dropElements, null, null, synch);
    }

    public BSDropCommand(Activity activity, List<Object> dropElements, MethodConfiguration config, Set synchFeatures) {
        this(activity, dropElements, config, synchFeatures, true);
    }

    public BSDropCommand(Activity activity, List<Object> dropElements, MethodConfiguration config, Set synchFeatures, boolean synch) {
        this.activity = activity;
        this.process = TngUtil.getOwningProcess((BreakdownElement)activity);
        this.synchronize = synch;
        this.config = config;
        this.synchFeatures = synchFeatures == null ? DEFAULT_SYNCH_FEATURES : synchFeatures;
        this.dropElements = dropElements;
        this.nestedCommandExcecutor = this.createNestedCommandExcecutor();
    }

    protected NestedCommandExcecutor createNestedCommandExcecutor() {
        return new NestedCommandExcecutor(this){

            public void executeNestedCommands() {
                List<INestedCommandProvider> nestedCommandProviders;
                if (BSDropCommand.this.taskDescList != null && !BSDropCommand.this.taskDescList.isEmpty() && !(nestedCommandProviders = ExtensionManager.getNestedCommandProviders()).isEmpty()) {
                    for (INestedCommandProvider cmdProvider : nestedCommandProviders) {
                        try {
                            Command cmd = cmdProvider.createRelatedObjects(BSDropCommand.this.taskDescList, BSDropCommand.this);
                            if (cmd == null || !cmd.canExecute()) continue;
                            cmd.execute();
                            this.getNestedCommands().add(cmd);
                        }
                        catch (Exception e) {
                            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                    }
                }
                super.executeNestedCommands();
            }
        };
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    protected void prepareDropElements() {
        ArrayList<Object> elements = new ArrayList<Object>();
        this.getMethodConfiguration();
        this.unwrappedDropElements = new ArrayList<Object>();
        for (Object o : this.dropElements) {
            Object element = TngUtil.unwrap(o);
            element = Providers.getConfigurationApplicator().resolve(element, this.config);
            if (elements.contains(element) || element instanceof EObject && ((EObject)element).eIsProxy()) continue;
            elements.add(element);
            this.unwrappedDropElements.add(o);
        }
        this.dropElements = elements;
    }

    public MethodConfiguration getMethodConfiguration() {
        if (this.config == null) {
            this.config = TngUtil.getOwningProcess((BreakdownElement)this.activity).getDefaultContext();
        }
        return this.config;
    }

    public void dispose() {
        if (this.dropElements != null) {
            this.dropElements.clear();
        }
        if (this.unwrappedDropElements != null) {
            this.unwrappedDropElements.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        if (this.elementsToAddToDefaultConfig != null) {
            this.elementsToAddToDefaultConfig.clear();
        }
        if (this.addedObjects != null) {
            this.addedObjects.clear();
        }
        if (this.descriptorToOldRefreshableFeaturesMap != null) {
            this.descriptorToOldRefreshableFeaturesMap.clear();
        }
        if (this.taskDescList != null) {
            this.taskDescList.clear();
        }
        if (this.taskDescToNewStepsMap != null) {
            this.taskDescToNewStepsMap.clear();
        }
        if (this.taskDescToOldEstimateMap != null) {
            this.taskDescToOldEstimateMap.clear();
        }
        if (this.refreshResponsibleForCommand != null) {
            this.refreshResponsibleForCommand.dispose();
        }
        if (this.taskDescriptorsToUpdate != null) {
            this.taskDescriptorsToUpdate.clear();
        }
        if (this.batchCommand != null) {
            this.batchCommand.dispose();
        }
        this.process = null;
        this.activity = null;
        if (this.nestedCommandExcecutor != null) {
            this.nestedCommandExcecutor.dispose();
        }
        super.dispose();
    }

    @Override
    public Collection<Resource> getModifiedResources() {
        if (this.modifiedResources == null) {
            this.modifiedResources = new HashSet<Resource>();
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
        }
        this.modifiedResources.addAll(this.nestedCommandExcecutor.getModifiedResources());
        return this.modifiedResources;
    }

    private boolean clearDescriptor(Descriptor descriptor) {
        HashSet<Object> excludeFeatures;
        HashSet<EStructuralFeature> excludeSynchFeatures = new HashSet<EStructuralFeature>(DEFAULT_SYNCH_FEATURES);
        excludeSynchFeatures.removeAll(this.synchFeatures);
        if (excludeSynchFeatures.isEmpty()) {
            excludeFeatures = excludeSynchFeatures;
        } else {
            excludeFeatures = new HashSet();
            Iterator iter = excludeSynchFeatures.iterator();
            while (iter.hasNext()) {
                EStructuralFeature feature = BSDropCommand.getDescriptorFeature((EStructuralFeature)iter.next());
                if (feature == null) continue;
                excludeFeatures.add(feature);
            }
        }
        boolean ret = ProcessCommandUtil.clearDescriptor(descriptor, this.descriptorToOldRefreshableFeaturesMap, excludeFeatures);
        if (ret && descriptor instanceof TaskDescriptor) {
            if (this.taskDescriptorsToUpdate == null) {
                this.taskDescriptorsToUpdate = new ArrayList();
            }
            this.taskDescriptorsToUpdate.add(descriptor);
        }
        return ret;
    }

    private static EStructuralFeature getDescriptorFeature(EStructuralFeature linkedElementFeature) {
        return FEATURE_MAP.get(linkedElementFeature);
    }

    protected boolean preExecute() {
        boolean b;
        this.prepareDropElements();
        boolean bl = b = !this.dropElements.isEmpty();
        if (b) {
            this.batchCommand = new DescriptorUpdateBatchCommand(false, this.synchFeatures, this.config);
        }
        return b;
    }

    protected boolean collectElementsToAddToDefaultConfig() {
        if (this.elementsToAddToDefaultConfig == null) {
            this.elementsToAddToDefaultConfig = new ArrayList<Object>();
            Iterator<Object> iter = this.dropElements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                switch (UserInteractionHelper.checkAgainstDefaultConfiguration(this.process, element)) {
                    case 0: {
                        iter.remove();
                        break;
                    }
                    case 2: {
                        this.elementsToAddToDefaultConfig.add(element);
                        break;
                    }
                    case -1: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean addToDefaultConfiguration() {
        if (!this.addedToDefaultConfig && this.elementsToAddToDefaultConfig != null && !this.elementsToAddToDefaultConfig.isEmpty()) {
            if (this.addedObjects == null) {
                this.addedObjects = new HashSet<Object>();
            } else {
                this.addedObjects.clear();
            }
            for (EObject eObject : this.elementsToAddToDefaultConfig) {
                ProcessUtil.addToDefaultConfiguration(this.process, eObject, this.addedObjects);
            }
            if (!this.addedObjects.isEmpty()) {
                this.getModifiedResources().add(this.process.getDefaultContext().eResource());
                return true;
            }
            this.addedToDefaultConfig = true;
        }
        return false;
    }

    protected int getTotalWork() {
        return 20;
    }

    protected void worked(int unitsOfWork) {
        this.monitor.worked(unitsOfWork);
        this.workedUnits += unitsOfWork;
    }

    protected int getRemainingWork() {
        int remaining = this.getTotalWork() - this.workedUnits;
        if (remaining < 0) {
            remaining = 0;
        }
        return remaining;
    }

    protected boolean updateDefaultConfigurationNeeded() {
        return !this.synchronize;
    }

    public void execute() {
        if (this.updateDefaultConfigurationNeeded() && !this.collectElementsToAddToDefaultConfig()) {
            return;
        }
        final String taskName = this.label == null ? "" : this.label;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(taskName, BSDropCommand.this.getTotalWork());
                    BSDropCommand.this.monitor = monitor;
                    BSDropCommand.this.worked(BSDropCommand.this.getRemainingWork() / 3);
                    BSDropCommand.this.addToDefaultConfiguration();
                    BSDropCommand.this.worked(BSDropCommand.this.getRemainingWork() / 3);
                    if (BSDropCommand.this.preExecute()) {
                        BSDropCommand.this.worked(BSDropCommand.this.getRemainingWork() / 3);
                        BSDropCommand.this.redo();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        if (this.runAsJob) {
            UserInteractionHelper.runAsJob(runnable, taskName);
        } else {
            UserInteractionHelper.runWithProgress(runnable, null);
        }
    }

    public void redo() {
        try {
            this.addToDefaultConfiguration();
            this.doExecute();
            this.updateDescriptors();
            long time = 0L;
            if (TngUtil.DEBUG) {
                time = System.currentTimeMillis();
            }
            this.nestedCommandExcecutor.executeNestedCommands();
            if (TngUtil.DEBUG) {
                System.out.println("BSDropCommand.redo(): executeNestedCommands(). " + (System.currentTimeMillis() - time));
            }
            this.executed = true;
        }
        catch (RuntimeException e) {
            if (TngUtil.DEBUG) {
                e.printStackTrace();
            }
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            throw e;
        }
    }

    protected void updateDescriptors() {
        if (this.synchronize) {
            this.clearDescriptors();
            if (!this.batchCommand.getDescriptorsToRefresh().isEmpty()) {
                ArrayList<EReference> basicSyncReferences = new ArrayList<EReference>();
                for (Object feature : this.synchFeatures) {
                    if (!BASIC_SYNC_REFERENCES.contains(feature)) continue;
                    basicSyncReferences.add((EReference)feature);
                }
                if (!basicSyncReferences.isEmpty()) {
                    for (Object desc : this.batchCommand.getDescriptorsToRefresh()) {
                        Descriptor descriptor = (Descriptor)desc;
                        MethodElement element = ProcessUtil.getAssociatedElement(descriptor);
                        if (!(element instanceof VariabilityElement)) continue;
                        for (EReference ref : basicSyncReferences) {
                            Object value = Providers.getConfigurationApplicator().getReference((VariabilityElement)element, ref, this.config);
                            EStructuralFeature descriptorFeature = FEATURE_MAP.get(ref);
                            if (descriptorFeature.isMany()) {
                                this.batchCommand.addFeatureValues((EObject)descriptor, descriptorFeature, (Collection)value);
                                continue;
                            }
                            this.batchCommand.addFeatureValue((EObject)descriptor, descriptorFeature, value);
                        }
                    }
                }
            }
        }
        this.batchCommand.execute();
        this.updateTaskDescriptors();
        this.setResponsibleRoles();
    }

    protected void undoUpdateDescriptors() {
        this.undoSetResponsibleRole();
        this.undoUpdateTaskDescriptors();
        this.batchCommand.undo();
        if (this.synchronize) {
            this.undoClearDescriptors();
        }
    }

    private void clearDescriptors() {
        if (this.descriptorToOldRefreshableFeaturesMap == null) {
            this.descriptorToOldRefreshableFeaturesMap = new HashMap();
            if (!this.batchCommand.getDescriptorsToRefresh().isEmpty()) {
                Iterator iter = this.batchCommand.getDescriptorsToRefresh().iterator();
                while (iter.hasNext()) {
                    this.clearDescriptor((Descriptor)iter.next());
                }
            }
        }
    }

    private void updateTaskDescriptors() {
        if (this.taskDescriptorsToUpdate != null && this.synchFeatures.contains(UmaPackage.eINSTANCE.getTask_Steps())) {
            if (this.taskDescToNewStepsMap == null) {
                this.taskDescToNewStepsMap = new HashMap();
            }
            IConfigurationApplicator configApplicator = Providers.getConfigurationApplicator();
            for (TaskDescriptor taskDescriptor : this.taskDescriptorsToUpdate) {
                Task task = taskDescriptor.getTask();
                if (task == null || task.eIsProxy()) continue;
                List steps = (List)configApplicator.getReference(task.getPresentation(), (DescribableElement)task, UmaPackage.eINSTANCE.getContentDescription_Sections(), this.config);
                ArrayList newSteps = new ArrayList();
                taskDescriptor.getSelectedSteps().retainAll(steps);
                for (Object step : steps) {
                    if (taskDescriptor.getSelectedSteps().contains(step)) continue;
                    newSteps.add(step);
                }
                if (newSteps.isEmpty()) continue;
                taskDescriptor.getSelectedSteps().addAll(newSteps);
                this.taskDescToNewStepsMap.put(taskDescriptor, newSteps);
            }
        }
    }

    private void undoUpdateTaskDescriptors() {
        if (this.taskDescToNewStepsMap != null) {
            for (Map.Entry entry : this.taskDescToNewStepsMap.entrySet()) {
                TaskDescriptor taskDesc = (TaskDescriptor)entry.getKey();
                taskDesc.getSelectedSteps().removeAll((Collection)entry.getValue());
            }
        }
    }

    private void setResponsibleRoles() {
        if (!this.synchFeatures.contains(UmaPackage.eINSTANCE.getRole_ResponsibleFor())) {
            return;
        }
        if (this.refreshResponsibleForCommand != null) {
            this.refreshResponsibleForCommand.dispose();
        }
        this.refreshResponsibleForCommand = new BatchCommand(true);
        List brElements = this.activity.getBreakdownElements();
        ArrayList wpDescList = new ArrayList();
        ArrayList roleDescriptors = new ArrayList();
        for (Object obj : brElements) {
            if (obj instanceof WorkProductDescriptor) {
                wpDescList.add(obj);
                continue;
            }
            if (!(obj instanceof RoleDescriptor)) continue;
            roleDescriptors.add(obj);
        }
        for (RoleDescriptor roleDesc : roleDescriptors) {
            Role role = roleDesc.getRole();
            if (role == null) continue;
            List responsibleWorkProducts = (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)role, UmaPackage.eINSTANCE.getRole_ResponsibleFor(), this.config);
            ArrayList<WorkProductDescriptor> responsibleWPDList = new ArrayList<WorkProductDescriptor>();
            int j = wpDescList.size() - 1;
            while (j > -1) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)wpDescList.get(j);
                if (responsibleWorkProducts.contains(wpDesc.getWorkProduct())) {
                    responsibleWPDList.add(wpDesc);
                }
                --j;
            }
            if (roleDesc.getResponsibleFor().equals(responsibleWPDList)) continue;
            this.refreshResponsibleForCommand.addFeatureValues((EObject)roleDesc, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor(), responsibleWPDList);
        }
        this.refreshResponsibleForCommand.execute();
    }

    public void undo() {
        this.nestedCommandExcecutor.undoNestedCommands();
        if (this.addedObjects != null && !this.addedObjects.isEmpty()) {
            MethodConfiguration config = this.process.getDefaultContext();
            for (Object element : this.addedObjects) {
                if (element instanceof MethodPlugin) {
                    config.getMethodPluginSelection().remove(element);
                    continue;
                }
                if (!(element instanceof MethodPackage)) continue;
                config.getMethodPackageSelection().remove(element);
            }
            this.addedToDefaultConfig = false;
        }
        this.undoUpdateDescriptors();
        this.doUndo();
    }

    private void undoClearDescriptors() {
        if (this.descriptorToOldRefreshableFeaturesMap != null) {
            for (Map.Entry<Descriptor, Map<?, ?>> entry : this.descriptorToOldRefreshableFeaturesMap.entrySet()) {
                Descriptor desc = entry.getKey();
                Map<?, ?> featureMap = entry.getValue();
                for (Map.Entry<?, ?> entry2 : featureMap.entrySet()) {
                    desc.eSet((EStructuralFeature)entry2.getKey(), entry2.getValue());
                }
            }
        }
    }

    private void undoSetResponsibleRole() {
        if (this.refreshResponsibleForCommand != null) {
            this.refreshResponsibleForCommand.undo();
        }
    }

    protected boolean prepare() {
        return true;
    }

    protected abstract void doExecute();

    protected abstract void doUndo();

    public static interface IExecutor {
        public boolean preExecute();

        public void doExcecute();

        public void doUndo();
    }
}

