/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IInteractive;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.util.AdapterFactoryItemLabelProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.WorkProductDescriptor;

public abstract class DeleteUnusedDescriptorsCommand
extends CompoundCommand
implements IInteractive {
    private Collection elements;
    private List descriptorsToDelete;
    private boolean includeChildren;
    private Collection deletedDescriptors;
    private IUserInteractionHandler userInteractionHandler;

    public DeleteUnusedDescriptorsCommand(Collection elements, boolean includeChildren, Collection deletedDescriptors) {
        this.elements = elements;
        this.includeChildren = includeChildren;
        this.deletedDescriptors = deletedDescriptors;
    }

    protected abstract Command delete(List var1);

    public void execute() {
        if (this.descriptorsToDelete == null) {
            this.descriptorsToDelete = new ArrayList();
            Object iter = this.includeChildren ? new AbstractTreeIterator(this.elements, false){
                private static final long serialVersionUID = 4718889409403141707L;

                protected Iterator getChildren(Object object) {
                    if (object == DeleteUnusedDescriptorsCommand.this.elements) {
                        return DeleteUnusedDescriptorsCommand.this.elements.iterator();
                    }
                    if (object instanceof Activity) {
                        return ((Activity)object).getBreakdownElements().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            } : this.elements.iterator();
            ArrayList currentDescriptorsToDelete = new ArrayList();
            if (this.deletedDescriptors != null) {
                currentDescriptorsToDelete.addAll(this.deletedDescriptors);
            }
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof RoleDescriptor) && !(element instanceof WorkProductDescriptor) || ProcessUtil.checkDescriptorReferences(currentDescriptorsToDelete, (Descriptor)element)) continue;
                currentDescriptorsToDelete.add(element);
            }
            currentDescriptorsToDelete.removeAll(this.deletedDescriptors);
            if (!currentDescriptorsToDelete.isEmpty()) {
                Command cmd;
                this.selectDescriptorsToDelete(currentDescriptorsToDelete);
                if (!currentDescriptorsToDelete.isEmpty() && (cmd = this.delete(currentDescriptorsToDelete)) != null) {
                    this.commandList.add(cmd);
                    this.descriptorsToDelete.addAll(currentDescriptorsToDelete);
                }
            }
        } else if (!this.descriptorsToDelete.isEmpty()) {
            this.commandList.clear();
            this.append(this.delete(this.descriptorsToDelete));
        }
    }

    private void selectDescriptorsToDelete(List descriptorsToDelete) {
        if (this.userInteractionHandler != null) {
            String msg;
            String title;
            ArrayList list = new ArrayList(descriptorsToDelete);
            AdapterFactoryItemLabelProvider labelProvider = new AdapterFactoryItemLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
            List selected = this.userInteractionHandler.select(list, labelProvider, true, list, title = LibraryEditResources.ui_references, msg = LibraryEditResources.selectDescriptorsToDelete_msg);
            if (selected == null) {
                throw new OperationCanceledException();
            }
            descriptorsToDelete.retainAll(selected);
        }
    }

    public void setUserInteractionHandler(IUserInteractionHandler handler) {
        this.userInteractionHandler = handler;
    }
}

