/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.osgi.util.NLS;

public class MethodConfigurationNameValidator
extends AbstractStringValidator {
    private MethodLibrary library;
    private MethodConfiguration config;

    public MethodConfigurationNameValidator(MethodLibrary lib, MethodConfiguration config) {
        this.library = lib;
        this.config = config;
    }

    public String isValid(String newText) {
        Integer max;
        if (!NameChecker.checkFilePathLength((MethodElement)this.library, (MethodElement)this.config, newText = newText.trim(), max = new Integer(255), null)) {
            String msg = NLS.bind((String)LibraryEditResources.filePathNameTooLong_msg, (Object[])new Object[]{max});
            return msg;
        }
        String configFolder = ((IFileBasedLibraryPersister)Services.getLibraryPersister((String)"xmi")).getFolderRelativePath((MethodElement)this.config);
        File dir = new File(new File(this.library.eResource().getURI().toFileString()).getParent(), configFolder);
        return TngUtil.checkName(dir, this.library.getPredefinedConfigurations(), (NamedElement)this.config, newText, TngUtil.getTypeText((EObject)this.config), false);
    }
}

