/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.impl.LinkedObjectImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.uma.GraphConnector;
import org.eclipse.epf.uma.GraphEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkImpl
extends LinkedObjectImpl
implements Link {
    protected static final String NAME_EDEFAULT = "";
    protected String name = "";
    protected Node target;
    protected EList<AbsoluteBendpoint> bendpoints;
    protected static final Point SOURCE_END_POINT_EDEFAULT = null;
    protected Point sourceEndPoint = SOURCE_END_POINT_EDEFAULT;
    protected static final Point TARGET_END_POINT_EDEFAULT = null;
    protected Point targetEndPoint = TARGET_END_POINT_EDEFAULT;

    protected LinkImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.LINK;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public Node getSource() {
        if (this.eContainerFeatureID != 2) {
            return null;
        }
        return (Node)this.eContainer();
    }

    public NotificationChain basicSetSource(Node newSource, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newSource, 2, msgs);
        return msgs;
    }

    @Override
    public void setSource(Node newSource) {
        if (newSource != this.eInternalContainer() || this.eContainerFeatureID != 2 && newSource != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newSource)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newSource != null) {
                msgs = ((InternalEObject)newSource).eInverseAdd((InternalEObject)this, 5, Node.class, msgs);
            }
            if ((msgs = this.basicSetSource(newSource, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newSource, (Object)newSource));
        }
    }

    @Override
    public Node getTarget() {
        if (this.target != null && this.target.eIsProxy()) {
            InternalEObject oldTarget = (InternalEObject)this.target;
            this.target = (Node)this.eResolveProxy(oldTarget);
            if (this.target != oldTarget && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldTarget, (Object)this.target));
            }
        }
        return this.target;
    }

    public Node basicGetTarget() {
        return this.target;
    }

    public NotificationChain basicSetTarget(Node newTarget, NotificationChain msgs) {
        Node oldTarget = this.target;
        this.target = newTarget;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldTarget, (Object)newTarget);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTarget(Node newTarget) {
        if (newTarget != this.target) {
            NotificationChain msgs = null;
            if (this.target != null) {
                msgs = ((InternalEObject)this.target).eInverseRemove((InternalEObject)this, 4, Node.class, msgs);
            }
            if (newTarget != null) {
                msgs = ((InternalEObject)newTarget).eInverseAdd((InternalEObject)this, 4, Node.class, msgs);
            }
            if ((msgs = this.basicSetTarget(newTarget, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newTarget, (Object)newTarget));
        }
    }

    @Override
    public EList<AbsoluteBendpoint> getBendpoints() {
        if (this.bendpoints == null) {
            this.bendpoints = new EDataTypeUniqueEList(AbsoluteBendpoint.class, (InternalEObject)this, 4);
        }
        return this.bendpoints;
    }

    @Override
    public Point getSourceEndPoint() {
        return this.sourceEndPoint;
    }

    @Override
    public void setSourceEndPoint(Point newSourceEndPoint) {
        Point oldSourceEndPoint = this.sourceEndPoint;
        this.sourceEndPoint = newSourceEndPoint;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldSourceEndPoint, (Object)this.sourceEndPoint));
        }
    }

    @Override
    public Point getTargetEndPoint() {
        return this.targetEndPoint;
    }

    @Override
    public void setTargetEndPoint(Point newTargetEndPoint) {
        Point oldTargetEndPoint = this.targetEndPoint;
        this.targetEndPoint = newTargetEndPoint;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldTargetEndPoint, (Object)this.targetEndPoint));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetSource((Node)otherEnd, msgs);
            }
            case 3: {
                if (this.target != null) {
                    msgs = ((InternalEObject)this.target).eInverseRemove((InternalEObject)this, 4, Node.class, msgs);
                }
                return this.basicSetTarget((Node)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetSource(null, msgs);
            }
            case 3: {
                return this.basicSetTarget(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 2: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 5, Node.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getSource();
            }
            case 3: {
                if (resolve) {
                    return this.getTarget();
                }
                return this.basicGetTarget();
            }
            case 4: {
                return this.getBendpoints();
            }
            case 5: {
                return this.getSourceEndPoint();
            }
            case 6: {
                return this.getTargetEndPoint();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setSource((Node)newValue);
                return;
            }
            case 3: {
                this.setTarget((Node)newValue);
                return;
            }
            case 4: {
                this.getBendpoints().clear();
                this.getBendpoints().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setSourceEndPoint((Point)newValue);
                return;
            }
            case 6: {
                this.setTargetEndPoint((Point)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setSource(null);
                return;
            }
            case 3: {
                this.setTarget(null);
                return;
            }
            case 4: {
                this.getBendpoints().clear();
                return;
            }
            case 5: {
                this.setSourceEndPoint(SOURCE_END_POINT_EDEFAULT);
                return;
            }
            case 6: {
                this.setTargetEndPoint(TARGET_END_POINT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.getSource() != null;
            }
            case 3: {
                return this.target != null;
            }
            case 4: {
                return this.bendpoints != null && !this.bendpoints.isEmpty();
            }
            case 5: {
                return SOURCE_END_POINT_EDEFAULT == null ? this.sourceEndPoint != null : !SOURCE_END_POINT_EDEFAULT.equals((Object)this.sourceEndPoint);
            }
            case 6: {
                return TARGET_END_POINT_EDEFAULT == null ? this.targetEndPoint != null : !TARGET_END_POINT_EDEFAULT.equals((Object)this.targetEndPoint);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", bendpoints: ");
        result.append(this.bendpoints);
        result.append(", sourceEndPoint: ");
        result.append(this.sourceEndPoint);
        result.append(", targetEndPoint: ");
        result.append(this.targetEndPoint);
        result.append(')');
        return result.toString();
    }

    @Override
    public void setObject(Object newObject) {
        super.setObject(newObject);
        if (newObject == null) {
            return;
        }
        GraphEdge edge = (GraphEdge)newObject;
        Iterator iter = edge.getWaypoints().iterator();
        while (iter.hasNext()) {
            this.getBendpoints().add((Object)new AbsoluteBendpoint(GraphicalDataHelper.toPoint((org.eclipse.epf.uma.Point)iter.next())));
        }
        if (this.getSourceGraphConnector().getPosition() != null) {
            this.sourceEndPoint = GraphicalDataHelper.toPoint(this.getSourceGraphConnector().getPosition());
        }
        if (this.getTargetGraphConnector().getPosition() != null) {
            this.targetEndPoint = GraphicalDataHelper.toPoint(this.getTargetGraphConnector().getPosition());
        }
        this.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                GraphEdge edge = (GraphEdge)LinkImpl.this.getObject();
                switch (msg.getFeatureID(Link.class)) {
                    case 4: {
                        switch (msg.getEventType()) {
                            case 3: {
                                AbsoluteBendpoint p = (AbsoluteBendpoint)msg.getNewValue();
                                int index = msg.getPosition();
                                org.eclipse.epf.uma.Point umaPoint = GraphicalDataHelper.newModelPoint(p.x, p.y);
                                if (index == -1) {
                                    edge.getWaypoints().add(umaPoint);
                                } else {
                                    edge.getWaypoints().add(index, umaPoint);
                                }
                                return;
                            }
                            case 4: {
                                int index = msg.getPosition();
                                if (index == -1) {
                                    edge.getWaypoints().remove(msg.getPosition());
                                } else {
                                    edge.getWaypoints().remove(index);
                                }
                                return;
                            }
                            case 5: {
                                Collection collection = (Collection)msg.getNewValue();
                                ArrayList<org.eclipse.epf.uma.Point> umaPoints = new ArrayList<org.eclipse.epf.uma.Point>();
                                for (AbsoluteBendpoint p : collection) {
                                    umaPoints.add(GraphicalDataHelper.newModelPoint(p.x, p.y));
                                }
                                int index = msg.getPosition();
                                if (index == -1) {
                                    edge.getWaypoints().addAll(umaPoints);
                                } else {
                                    edge.getWaypoints().addAll(index, umaPoints);
                                }
                                return;
                            }
                            case 1: {
                                AbsoluteBendpoint p = (AbsoluteBendpoint)msg.getNewValue();
                                int pointIndex = msg.getPosition();
                                org.eclipse.epf.uma.Point newUmaPoint = GraphicalDataHelper.newModelPoint(p.x, p.y);
                                if (pointIndex == -1) {
                                    System.out.println("Index for bendpoint is -1, Cannot set the bend point location.");
                                } else {
                                    edge.getWaypoints().remove(pointIndex);
                                    edge.getWaypoints().add(pointIndex, newUmaPoint);
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 5: {
                        Point p = (Point)msg.getNewValue();
                        if (p != null) {
                            LinkImpl.this.getSourceGraphConnector().setPosition(GraphicalDataHelper.newModelPoint(p.x, p.y));
                        }
                        return;
                    }
                    case 6: {
                        Point p = (Point)msg.getNewValue();
                        if (p != null) {
                            LinkImpl.this.getTargetGraphConnector().setPosition(GraphicalDataHelper.newModelPoint(p.x, p.y));
                        }
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        return;
                    }
                }
            }
        });
    }

    private GraphConnector getSourceGraphConnector() {
        return (GraphConnector)((GraphEdge)this.getObject()).getAnchor().get(0);
    }

    private GraphConnector getTargetGraphConnector() {
        return (GraphConnector)((GraphEdge)this.getObject()).getAnchor().get(1);
    }
}

