/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;

public class NamedNodeImpl
extends NodeImpl
implements NamedNode {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    private AdapterImpl baseListener;
    protected BreakdownElementWrapperItemProvider itemProvider;

    protected NamedNodeImpl() {
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.NAMED_NODE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldName, (Object)this.name));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    protected Link addIncomingConnection(MethodElement source) {
        Node srcNode = this.findNode(source);
        if (srcNode == null) {
            return null;
        }
        Link link = ModelFactory.eINSTANCE.createLink();
        link.setTarget(this);
        NodeImpl srcNodeImpl = (NodeImpl)srcNode;
        boolean notify = srcNodeImpl.notificationEnabled;
        try {
            srcNodeImpl.notificationEnabled = false;
            link.setSource(srcNode);
        }
        finally {
            srcNodeImpl.notificationEnabled = notify;
        }
        if (this.isGraphicalDataRequired()) {
            GraphicalDataHelper.addGraphicalData(link);
        }
        return link;
    }

    protected Node findNode(MethodElement linkedElement) {
        return GraphicalDataHelper.findNode(this.getDiagram(), (Object)linkedElement);
    }

    protected Link addOutgoingConnection(MethodElement target) {
        Node targetNode = this.findNode(target);
        if (targetNode == null) {
            return null;
        }
        Link link = ModelFactory.eINSTANCE.createLink();
        NodeImpl nodeImpl = (NodeImpl)targetNode;
        boolean notify = nodeImpl.notificationEnabled;
        try {
            nodeImpl.notificationEnabled = false;
            link.setTarget(targetNode);
        }
        finally {
            nodeImpl.notificationEnabled = notify;
        }
        link.setSource(this);
        if (this.isGraphicalDataRequired()) {
            GraphicalDataHelper.addGraphicalData(link);
        }
        return link;
    }

    protected boolean removeIncomingConnection(MethodElement source) {
        for (Link link : this.getIncomingConnections()) {
            if (link.getSource() == null || link.getSource().getObject() != source) continue;
            GraphicalDataHelper.removeGraphicalData(link);
            NodeImpl sourceNode = (NodeImpl)link.getSource();
            boolean oldNotify = sourceNode.notificationEnabled;
            try {
                sourceNode.notificationEnabled = false;
                link.setSource(null);
            }
            finally {
                sourceNode.notificationEnabled = oldNotify;
            }
            link.setTarget(null);
            link.setObject(null);
            return true;
        }
        return false;
    }

    protected boolean removeOutgoingConnection(MethodElement target) {
        for (Link link : this.getOutgoingConnections()) {
            if (link.getTarget() == null || link.getTarget().getObject() != target) continue;
            GraphicalDataHelper.removeGraphicalData(link);
            NodeImpl targetNode = (NodeImpl)link.getTarget();
            boolean oldNotify = targetNode.notificationEnabled;
            try {
                targetNode.notificationEnabled = false;
                link.setTarget(null);
            }
            finally {
                targetNode.notificationEnabled = oldNotify;
            }
            link.setSource(null);
            link.setObject(null);
            return true;
        }
        return false;
    }

    public void setObject(Object newObject) {
        DescribableElement element;
        super.setObject(newObject);
        if (newObject == null) {
            return;
        }
        String name = null;
        if (newObject instanceof DescribableElement) {
            element = (DescribableElement)newObject;
            name = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)element));
        }
        if (StrUtil.isBlank(name)) {
            element = (MethodElement)newObject;
            name = element.getName();
        }
        this.name = name;
    }

    protected void basicSetObject(Object newObject) {
        VariabilityElement base;
        super.basicSetObject(newObject);
        if (newObject instanceof VariabilityElement && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)newObject)) && (base = ((VariabilityElement)newObject).getVariabilityBasedOnElement()) != null) {
            if (this.baseListener == null) {
                this.baseListener = new AdapterImpl(){

                    public void notifyChanged(Notification msg) {
                        switch (msg.getFeatureID(DescribableElement.class)) {
                            case 2: {
                                DescribableElement e = (DescribableElement)NamedNodeImpl.this.getObject();
                                if (!StrUtil.isBlank((String)e.getPresentationName())) break;
                                String oldName = NamedNodeImpl.this.name;
                                NamedNodeImpl.this.name = msg.getNewStringValue();
                                if (NamedNodeImpl.this.name.equals(oldName)) break;
                                NamedNodeImpl.this.eNotify((Notification)new ENotificationImpl((InternalEObject)NamedNodeImpl.this, -1, 7, (Object)oldName, (Object)NamedNodeImpl.this.name));
                            }
                        }
                    }
                };
            }
            base.eAdapters().add((Object)this.baseListener);
        }
    }

    protected void dispose() {
        EObject obj = (EObject)this.getObject();
        if (obj != null && this.baseListener != null) {
            obj.eAdapters().remove((Object)this.baseListener);
        }
        super.dispose();
    }

    protected Adapter createNodeAdapter() {
        return new NodeImpl.NodeAdapter(this){

            public void notifyChanged(Notification msg) {
                if (!NamedNodeImpl.this.notificationEnabled) {
                    return;
                }
                NamedNodeImpl.this.notificationEnabled = false;
                try {
                    switch (msg.getFeatureID(NamedNode.class)) {
                        case 7: {
                            if (msg.getEventType() == 1 && NamedNodeImpl.this.getObject() instanceof BreakdownElement) {
                                String newName = msg.getNewStringValue();
                                BreakdownElement e = (BreakdownElement)NamedNodeImpl.this.getObject();
                                e.setPresentationName(newName);
                                if (StrUtil.isBlank((String)e.getName())) {
                                    e.setName(newName);
                                }
                            }
                            return;
                        }
                    }
                    super.notifyChanged(msg);
                }
                finally {
                    NamedNodeImpl.this.notificationEnabled = true;
                }
            }
        };
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public void setNotificationEnabled(boolean notificationEnabled) {
        this.notificationEnabled = notificationEnabled;
    }

    public boolean isSuppressed() {
        Suppression suppression = this.getDiagram().getSuppression();
        if (suppression != null) {
            BreakdownElementWrapperItemProvider o = this.itemProvider != null ? this.itemProvider : this.getLinkedElement();
            return this.getDiagram().getSuppression().isSuppressed((Object)o);
        }
        return false;
    }

    public Object getWrapper() {
        return this.itemProvider;
    }

    void setItemProvider(Collection allElements) {
        BreakdownElementWrapperItemProvider wrapper;
        Object object = GraphicalDataHelper.findElement(allElements, this.getObject());
        if (object instanceof BreakdownElementWrapperItemProvider && (wrapper = (BreakdownElementWrapperItemProvider)object).isReadOnly()) {
            this.itemProvider = wrapper;
            this.readOnly = true;
        }
    }

    protected class MethodElementAdapter
    extends NodeImpl.TransactionalNodeLink {
        protected MethodElementAdapter() {
            super(NamedNodeImpl.this);
        }

        protected void handleNotification(Notification msg) {
            switch (msg.getFeatureID(DescribableElement.class)) {
                case 2: {
                    NamedNodeImpl.this.setName(msg.getNewStringValue());
                    return;
                }
            }
        }

        public void notifyChanged(final Notification msg) {
            if (!NamedNodeImpl.this.notificationEnabled) {
                return;
            }
            NamedNodeImpl.this.notificationEnabled = false;
            try {
                try {
                    TxUtil.runInTransaction(this.getNode(), new Runnable(){

                        public void run() {
                            MethodElementAdapter.this.handleNotification(msg);
                        }
                    });
                }
                catch (Exception e) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)e);
                    NamedNodeImpl.this.notificationEnabled = true;
                }
            }
            finally {
                NamedNodeImpl.this.notificationEnabled = true;
            }
        }

        public Node getNode() {
            return NamedNodeImpl.this;
        }
    }
}

