/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.ui.util;

import org.eclipse.epf.common.ui.util.WrappedMessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class MsgBox {
    public static final void nativeShowError(Shell shell, String msg) {
        if (shell == null && (shell = MsgBox.getDefaultShell()) == null) {
            return;
        }
        MessageBox msgBox = new MessageBox(shell, 33);
        msgBox.setMessage(msg);
        msgBox.setText(shell.getText());
        msgBox.open();
    }

    public static final void showError(String msg) {
        MsgBox.showError(MsgBox.getDefaultShell(), msg);
    }

    public static final void showError(Shell shell, String msg) {
        WrappedMessageDialog.openError(shell, shell == null ? null : shell.getText(), msg);
    }

    public static final void showWarning(String msg) {
        MsgBox.showWarning(MsgBox.getDefaultShell(), msg);
    }

    public static final void showWarning(Shell shell, String msg) {
        WrappedMessageDialog.openWarning(shell, shell == null ? null : shell.getText(), msg);
    }

    public static final Shell getDefaultShell() {
        try {
            Display d = Display.getCurrent();
            if (d == null) {
                d = Display.getDefault();
            }
            Shell s = null;
            if (d != null) {
                s = d.getActiveShell();
            }
            return s;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static final Display getDisplay() {
        try {
            Display d = Display.getCurrent();
            if (d == null) {
                d = Display.getDefault();
            }
            return d;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static final int prompt(String msg) {
        return MsgBox.prompt(MsgBox.getDefaultShell(), msg);
    }

    public static final int prompt(Shell shell, String msg) {
        return MsgBox.prompt(shell, null, msg, 448);
    }

    public static final int prompt(String msg, int buttons) {
        return MsgBox.prompt(MsgBox.getDefaultShell(), null, msg, buttons);
    }

    public static final int prompt(String title, String msg, int buttons) {
        return MsgBox.prompt(MsgBox.getDefaultShell(), title, msg, buttons);
    }

    public static final int prompt(Shell shell, String msg, int buttons) {
        return MsgBox.prompt(shell, null, msg, buttons);
    }

    public static final int prompt(Shell shell, String title, String msg, int buttons) {
        MessageBox msgBox = new MessageBox(shell, buttons | 4);
        msgBox.setText(title != null && title.length() > 0 ? title : shell.getText());
        msgBox.setMessage(msg);
        return msgBox.open();
    }
}

