/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.cmdline;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.diagram.ui.service.DiagramImageService;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.publishing.cmdline.CmdlinePlugin;
import org.eclipse.epf.publishing.cmdline.Messages;
import org.eclipse.epf.publishing.cmdline.TextProgressMonitor;
import org.eclipse.epf.publishing.cmdline.UsageException;
import org.eclipse.epf.publishing.cmdline.dummyui.DummyWorkbenchAdvisor;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishManager;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Publish
implements IPlatformRunnable {
    private static final String ABOUT = "-about";
    private static final String BANNER = "-banner";
    private static final String BANNER_HEIGHT = "-bannerHeight";
    private static final String CHECK_LINKS = "-checkLinks";
    private static final String CONFIG = "-config";
    private static final String DYNAMIC = "-dynamic";
    private static final String FEEDBACK = "-feedback";
    private static final String GLOSSARY = "-glossary";
    private static final String INDEX = "-index";
    private static final String LIBRARY_PATH = "-libraryPath";
    private static final String PUBLISH_PATH = "-publishPath";
    private static final String PUBLISH_UNVERIFIED_DIAGRAMS = "-publishUnverifiedDiagrams";
    private static final String TITLE = "-title";
    private static final String PDELAUNCH = "-pdelaunch";
    private static final String LIBRARY_XMI = "/library.xmi";
    private String libraryPath;
    private String configuration;
    private Shell shell;

    public Object run(Object args) throws Exception {
        try {
            PublishOptions publishDataModel = this.parseArgs((String[])args);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Display display = new Display();
                        Publish.this.shell = new Shell(display);
                        Publish.this.shell.setLayoutData((Object)new GridData(1, 1));
                        Publish.this.shell.setLayout((Layout)new GridLayout());
                        Publish.this.shell.setVisible(false);
                        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new DummyWorkbenchAdvisor());
                        Publish.this.shell.close();
                        display.dispose();
                    }
                    catch (Exception e) {
                        CmdlinePlugin.log(e);
                        e.printStackTrace();
                        System.err.println(Messages.internalError);
                    }
                }
            });
            thread.start();
            ILibraryService libService = LibraryService.getInstance();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("library.path", this.libraryPath);
            libService.openMethodLibrary("xmi", params);
            return this.run(args, this.shell, publishDataModel);
        }
        catch (UsageException ex) {
            System.err.println(ex.getMessage());
            System.err.println(Messages.usage);
            return new Integer(1);
        }
        catch (Throwable ex) {
            CmdlinePlugin.log(ex);
            ex.printStackTrace();
            System.err.println(Messages.internalError);
            return new Integer(2);
        }
    }

    public Object run(Object args, Shell shell, PublishOptions publishDataModel) throws Exception {
        ILibraryService lp = LibraryService.getInstance();
        MethodLibrary library = lp.getCurrentMethodLibrary();
        try {
            MethodConfiguration config = null;
            List configurations = library.getPredefinedConfigurations();
            for (MethodConfiguration configuration : configurations) {
                if (!configuration.getName().equals(this.configuration)) continue;
                config = configuration;
            }
            if (config == null) {
                throw new UsageException(NLS.bind((String)Messages.badConfig, (Object)this.configuration, (Object)this.libraryPath));
            }
            PublishManager mgr = new PublishManager();
            mgr.init(publishDataModel.getPublishDir(), config, publishDataModel);
            AbstractViewBuilder viewBuilder = mgr.getViewBuilder();
            ElementLayoutManager layoutMgr = viewBuilder.getLayoutMgr();
            DiagramImageService diagramService = new DiagramImageService((Composite)shell, new File(layoutMgr.getPublishDir()));
            diagramService.setConfig(config);
            diagramService.setPublishedUnCreatedADD(publishDataModel.isPublishUnopenADD());
            diagramService.setPublishADForActivityExtension(publishDataModel.isPublishBaseAD());
            layoutMgr.setActivityDiagramService((IActivityDiagramService)diagramService);
            TextProgressMonitor monitor = new TextProgressMonitor();
            mgr.publish((IProgressMonitor)monitor);
        }
        finally {
            lp.closeCurrentMethodLibrary();
            shell.getDisplay().wake();
        }
        return EXIT_OK;
    }

    private PublishOptions parseArgs(String[] args) throws UsageException {
        PublishHTMLOptions options = new PublishHTMLOptions();
        options.setPublishConfiguration(true);
        options.setPublishProcess(true);
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals(LIBRARY_PATH)) {
                    File path;
                    if (!(path = new File(args[++i])).isAbsolute()) {
                        path = path.getAbsoluteFile();
                    }
                    if (!new File(path, LIBRARY_XMI).exists()) {
                        throw new UsageException(NLS.bind((String)Messages.invalidLibraryPath, (Object)args[i]));
                    }
                    this.libraryPath = path.getAbsolutePath();
                    System.out.println(this.libraryPath);
                } else if (args[i].equals(PUBLISH_PATH)) {
                    options.setPublishDir(args[++i]);
                } else if (args[i].equals(CONFIG)) {
                    this.configuration = args[++i];
                } else if (args[i].equals(BANNER)) {
                    options.setBannerImage(args[++i]);
                    if (!new File(args[i]).exists()) {
                        throw new UsageException(NLS.bind((String)Messages.invalidBannerPath, (Object)args[i]));
                    }
                } else if (args[i].equals(BANNER_HEIGHT)) {
                    try {
                        options.setBannerImageHeight(Integer.parseInt(args[++i]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new UsageException(NLS.bind((String)Messages.invalidImageHeight, (Object)args[i]));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new UsageException(NLS.bind((String)Messages.invalidImageHeight, (Object)"<Missing>"));
                    }
                } else if (args[i].equals(FEEDBACK)) {
                    options.setFeedbackURL(args[++i]);
                } else if (args[i].equals(TITLE)) {
                    options.setTitle(args[++i]);
                } else if (args[i].equals(ABOUT)) {
                    options.setAboutHTML(args[++i]);
                    if (!new File(args[i]).exists()) {
                        throw new UsageException(NLS.bind((String)Messages.invalidAboutPath, (Object)args[i]));
                    }
                } else if (args[i].equals(GLOSSARY)) {
                    options.setPublishGlossary(true);
                } else if (args[i].equals(INDEX)) {
                    options.setPublishIndex(true);
                } else if (args[i].equals(DYNAMIC)) {
                    options.setPublishDynamicWebApp(true);
                    options.setDynamicWebAppName(args[++i]);
                } else if (args[i].equals(CHECK_LINKS)) {
                    options.setCheckExternalLinks(true);
                    options.setConvertBrokenLinks(true);
                } else if (args[i].equals(PUBLISH_UNVERIFIED_DIAGRAMS)) {
                    options.setPublishUnopenADD(true);
                    options.setPublishBaseAD(true);
                } else if (!args[i].equals(PDELAUNCH)) {
                    throw new UsageException(NLS.bind((String)Messages.unknownArg, (Object)args[i]));
                }
            } else {
                throw new UsageException(NLS.bind((String)Messages.unknownArg, (Object)args[i]));
            }
            ++i;
        }
        if (this.libraryPath == null) {
            throw new UsageException(NLS.bind((String)Messages.missingRequiredParameter, (Object)LIBRARY_PATH));
        }
        if (options.getPublishDir() == null) {
            throw new UsageException(NLS.bind((String)Messages.missingRequiredParameter, (Object)PUBLISH_PATH));
        }
        if (this.configuration == null) {
            throw new UsageException(NLS.bind((String)Messages.missingRequiredParameter, (Object)CONFIG));
        }
        return options;
    }
}

